/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.ride_the_wind.mixin;

import com.cleannrooster.ride_the_wind.client.AnimatablePlayer;
import com.cleannrooster.ride_the_wind.client.animation.AnimationSubStack;
import com.cleannrooster.ride_the_wind.client.animation.StateCollectionHelper;
import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Optional;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerMixin
extends class_1657
implements AnimatablePlayer {
    private final AnimationSubStack flyAnimation = new AnimationSubStack(this.createPitchAdjustment_RidetheWind());
    private boolean flyingAnimationPitching = true;

    public AbstractClientPlayerMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit_RidetheWind(class_638 world, GameProfile profile, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).getAnimationStack();
        stack.addAnimLayer(880, (IAnimation)this.flyAnimation.base);
    }

    private AdjustmentModifier createPitchAdjustment_RidetheWind() {
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (this.flyingAnimationPitching) {
                if (FirstPersonMode.isFirstPersonPass()) {
                    float pitch = this.method_36455();
                    pitch = (float)Math.toRadians(pitch);
                    switch (partName) {
                        case "rightArm": 
                        case "leftArm": {
                            rotationX = pitch;
                            break;
                        }
                        default: {
                            return Optional.empty();
                        }
                    }
                } else {
                    float pitch = this.method_36455() / 2.0f;
                    pitch = (float)Math.toRadians(pitch);
                    switch (partName) {
                        case "body": {
                            rotationX = -1.0f * pitch;
                            break;
                        }
                        case "rightArm": 
                        case "leftArm": {
                            rotationX = pitch;
                            break;
                        }
                        case "rightLeg": 
                        case "leftLeg": {
                            rotationX = -1.0f * pitch;
                            break;
                        }
                        default: {
                            return Optional.empty();
                        }
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private void updateAnimationByCurrentActivity_RidetheWind(KeyframeAnimation.AnimationBuilder animation) {
        if (this.isMounting_RidetheWind()) {
            StateCollectionHelper.configure(animation.rightLeg, false, false);
            StateCollectionHelper.configure(animation.leftLeg, false, false);
        }
    }

    @Override
    public void modifyFlyAnimation() {
        try {
            if (!this.method_31549().field_7479) {
                AnimationSubStack stack = this.flyAnimation;
                stack.base.setAnimation(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void playFlyAnimation(String name, float speed) {
        AnimationSubStack stack = this.flyAnimation;
        try {
            if (name != null && !name.isEmpty()) {
                class_2960 id = class_2960.method_60654((String)name);
                KeyframeAnimation animation = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)id);
                KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
                this.updateAnimationByCurrentActivity_RidetheWind(copy);
                copy.torso.fullyEnablePart(true);
                copy.body.fullyEnablePart(true);
                copy.head.yaw.setEnabled(false);
                if (this.isLeftHanded_RidetheWind()) {
                    copy.leftArm.yaw.setEnabled(false);
                } else {
                    copy.rightArm.yaw.setEnabled(false);
                }
                copy.head.pitch.setEnabled(false);
                copy.head.yaw.setEnabled(false);
                boolean mirror = this.isLeftHanded_RidetheWind();
                int fadeIn = copy.beginTick;
                stack.mirror.setEnabled(mirror);
                KeyframeAnimationPlayer animation1 = new KeyframeAnimationPlayer(copy.build(), 0);
                if (stack.base.getAnimation() == null || !stack.base.getAnimation().isActive()) {
                    stack.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeIn, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(copy.build(), 0).setFirstPersonMode(FirstPersonMode.NONE));
                    stack.speed.speed = 1.0f;
                }
            } else {
                int fadeOutLength = 5;
                stack.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeOutLength, (Ease)Ease.INOUTSINE), (IAnimation)null);
                stack.adjustment.fadeOut(fadeOutLength);
                stack.speed.speed = speed;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isMounting_RidetheWind() {
        return this.method_5854() != null;
    }

    public boolean isLeftHanded_RidetheWind() {
        return this.method_6068() == class_1306.field_6182;
    }
}

