/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.commands;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.mixin.LocateCommandInvoker;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3079;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import net.minecraft.class_7157;
import net.minecraft.class_7924;

public final class StructurifyCommand {
    public static void createCommand(CommandDispatcher<class_2168> dispatcher, class_7157 context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"structurify").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"dump").executes(ctx -> {
            Structurify.getConfig().dump();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Structurify config dumped to \"" + String.valueOf(Structurify.getConfig().configDumpPath) + "\".")), !((class_2168)ctx.getSource()).method_43737());
            return 1;
        }))).then(class_2170.method_9247((String)"locate").then(class_2170.method_9247((String)"structure").then(class_2170.method_9244((String)"structure", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41246)).executes(commandContext -> StructurifyCommand.locateStructure((class_2168)commandContext.getSource(), (class_7066.class_7068<class_3195>)class_7066.method_41166((CommandContext)commandContext, (String)"structure", (class_5321)class_7924.field_41246, (DynamicCommandExceptionType)LocateCommandInvoker.structurify$getStructureInvalidError())))))));
    }

    private static int locateStructure(class_2168 source, class_7066.class_7068<class_3195> structure) throws CommandSyntaxException {
        class_3218 serverLevel = source.method_9225();
        class_2338 blockPos = class_2338.method_49638((class_2374)source.method_9222());
        class_2378 registry = source.method_9225().method_30349().method_30530(class_7924.field_41246);
        class_6885 holderSet = (class_6885)LocateCommandInvoker.structurify$invokeGetHolders(structure, (class_2378<class_3195>)registry).orElseThrow(() -> LocateCommandInvoker.structurify$getStructureInvalidError().create((Object)structure.method_41176()));
        source.method_9226(() -> class_2561.method_43470((String)("Locating " + structure.method_41176() + " in the radius of " + LocateCommandInvoker.structurify$getMaxStructureSearchRadius() + " chunks")), false);
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)class_156.field_37250);
        CompletableFuture.supplyAsync(() -> serverLevel.method_14178().method_12129().method_12103(serverLevel, holderSet, blockPos, LocateCommandInvoker.structurify$getMaxStructureSearchRadius(), false), class_156.method_18349()).thenAcceptAsync(pair -> {
            stopwatch.stop();
            source.method_9211().execute(() -> {
                if (pair == null) {
                    source.method_9213((class_2561)class_2561.method_43471((String)LocateCommandInvoker.structurify$getStructureNotFoundError().create((Object)structure.method_41176()).getLocalizedMessage()));
                } else {
                    class_3079.method_24499((class_2168)source, (class_7066.class_7068)structure, (class_2338)blockPos, (Pair)pair, (String)"commands.locate.structure.success", (boolean)false, (Duration)stopwatch.elapsed());
                }
            });
        }, (Executor)class_156.method_18349());
        return 0;
    }
}

