/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.s2c;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.item.upgrade.VehicleUpgrade;
import immersive_aircraft.item.upgrade.VehicleUpgradeRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class VehicleUpgradesMessage
extends Message {
    public static final class_9139<class_9129, VehicleUpgradesMessage> STREAM_CODEC = class_9139.method_56438(VehicleUpgradesMessage::encode, VehicleUpgradesMessage::new);
    public static final class_8710.class_9154<VehicleUpgradesMessage> TYPE = Message.createType("vehicle_upgrades");
    private final Map<class_1792, VehicleUpgrade> upgrades;

    public class_8710.class_9154<VehicleUpgradesMessage> method_56479() {
        return TYPE;
    }

    public VehicleUpgradesMessage() {
        this.upgrades = VehicleUpgradeRegistry.INSTANCE.getAll();
    }

    public VehicleUpgradesMessage(class_9129 buffer) {
        this.upgrades = new HashMap<class_1792, VehicleUpgrade>();
        int upgradeCount = buffer.readInt();
        for (int i = 0; i < upgradeCount; ++i) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(buffer.method_10810());
            this.upgrades.put(item, this.readUpgrade(buffer));
        }
    }

    @Override
    public void encode(class_9129 buffer) {
        Map<class_1792, VehicleUpgrade> upgrades = VehicleUpgradeRegistry.INSTANCE.getAll();
        buffer.method_53002(upgrades.size());
        for (class_1792 item : upgrades.keySet()) {
            buffer.method_10812(class_7923.field_41178.method_10221((Object)item));
            this.writeUpgrade(buffer, upgrades.get(item));
        }
    }

    protected void writeUpgrade(class_9129 buffer, VehicleUpgrade upgrade) {
        Map<VehicleStat, Float> upgradeMap = upgrade.getAll();
        buffer.method_53002(upgradeMap.size());
        for (VehicleStat stat : upgradeMap.keySet()) {
            buffer.method_10814(stat.name());
            buffer.method_52941(upgradeMap.get(stat).floatValue());
        }
    }

    protected VehicleUpgrade readUpgrade(class_9129 buffer) {
        VehicleUpgrade upgrade = new VehicleUpgrade();
        int statCount = buffer.readInt();
        for (int j = 0; j < statCount; ++j) {
            upgrade.set(VehicleStat.STATS.get(buffer.method_19772()), buffer.readFloat());
        }
        return upgrade;
    }

    @Override
    public void receiveClient() {
        VehicleUpgradeRegistry.INSTANCE.replace(this.upgrades);
    }
}

