/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.TrailDescriptor;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class AirshipEntity
extends Rotorcraft {
    public AirshipEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world, true);
    }

    @Override
    protected float getEngineReactionSpeed() {
        return 50.0f;
    }

    @Override
    protected class_3414 getEngineSound() {
        return Sounds.PROPELLER_SMALL.get();
    }

    @Override
    public class_1792 asItem() {
        return Items.AIRSHIP.get();
    }

    @Override
    protected double method_7490() {
        return this.field_5957 ? (double)-0.04f : (double)(1.0f - this.getEnginePower()) * super.method_7490();
    }

    @Override
    protected void updateController() {
        super.updateController();
        if (this.canTurnOnEngine((class_1297)this.method_5642())) {
            this.setEngineTarget(1.0f);
        }
        this.method_18799(this.method_18798().method_1031(0.0, (double)(this.getEnginePower() * this.getProperties().get(VehicleStat.VERTICAL_SPEED) * this.pressingInterpolatedY.getSmooth()), 0.0));
        Vector3f direction = this.getForwardDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.getProperties().get(VehicleStat.ENGINE_SPEED)) * this.pressingInterpolatedZ.getSmooth();
        Vector3f f = direction.mul(thrust);
        this.method_18799(this.method_18798().method_1031((double)f.x, (double)f.y, (double)f.z));
    }

    @Override
    protected float getBaseTrailWidth(Matrix4f transform, int index, TrailDescriptor trail) {
        return Math.max(0.0f, Math.min(1.0f, (float)(this.method_18798().method_1033() - (double)0.05f)));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        float power = this.getEnginePower();
        if (this.method_37908().field_9236 && this.isWithinParticleRange() && (double)power > 0.01) {
            Matrix4f transform = this.getVehicleTransform();
            if (this.field_6012 % 2 == 0) {
                Vector4f p = this.transformPosition(transform, (this.field_5974.method_43057() - 0.5f) * 0.4f, 0.8f, -0.8f);
                class_243 velocity = this.method_18798();
                this.method_37908().method_8406((class_2394)class_2398.field_11251, (double)p.x, (double)p.y, (double)p.z, velocity.field_1352, velocity.field_1351, velocity.field_1350);
            }
        }
    }

    @Override
    public double getZoom() {
        return 5.0;
    }

    @Override
    public float getPropellerSpeed() {
        return super.getPropellerSpeed() * (0.25f + Math.abs(this.pressingInterpolatedZ.get(0.0f)));
    }
}

