/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import immersive_aircraft.Main;
import immersive_aircraft.WeaponRendererRegistry;
import immersive_aircraft.client.render.entity.renderer.DyeableVehicleEntityRenderer;
import immersive_aircraft.client.render.entity.renderer.utils.BBModelRenderer;
import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_aircraft.client.render.entity.weaponRenderer.WeaponRenderer;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.inventory.VehicleInventoryDescription;
import immersive_aircraft.entity.weapon.Weapon;
import immersive_aircraft.resources.bbmodel.BBFaceContainer;
import immersive_aircraft.resources.bbmodel.BBMesh;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_9307;
import net.minecraft.class_9334;

public abstract class InventoryVehicleRenderer<T extends InventoryVehicleEntity>
extends DyeableVehicleEntityRenderer<T> {
    public InventoryVehicleRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public void renderLocal(T entity, float yaw, float tickDelta, class_4587 matrixStack, class_4587.class_4665 peek, class_4597 vertexConsumerProvider, int light) {
        super.renderLocal(entity, yaw, tickDelta, matrixStack, peek, vertexConsumerProvider, light);
        class_746 player = class_310.method_1551().field_1724;
        for (List<Weapon> weapons : ((InventoryVehicleEntity)((Object)entity)).getWeapons().values()) {
            for (Weapon weapon : weapons) {
                WeaponRenderer<Weapon> renderer;
                if (weapon.getMount().blocking() && Main.firstPersonGetter.isFirstPerson() && player != null && entity.method_5626((class_1297)player) || (renderer = WeaponRendererRegistry.get(weapon)) == null) continue;
                renderer.render(entity, weapon, matrixStack, vertexConsumerProvider, light, tickDelta);
            }
        }
    }

    public void renderBanners(BBModel model, BBObject ignoredObject, class_4597 vertexConsumerProvider, T entity, class_4587 matrixStack, int light, float ignoredTime, ModelPartRenderHandler<T> ignoredModelPartRenderer) {
        List<class_1799> slots = ((InventoryVehicleEntity)((Object)entity)).getSlots(VehicleInventoryDescription.BANNER);
        int i = 0;
        for (class_1799 slot : slots) {
            BBObject bannerObject;
            class_1792 class_17922;
            if (slot.method_7960() || !((class_17922 = slot.method_7909()) instanceof class_1746)) continue;
            class_1746 bannerItem = (class_1746)class_17922;
            class_1767 baseColor = bannerItem.method_7706();
            class_9307 banner = (class_9307)slot.method_57824(class_9334.field_49619);
            if (banner == null || !((bannerObject = model.objectsByName.get("banner_" + i++)) instanceof BBFaceContainer)) continue;
            BBFaceContainer bannerContainer = (BBFaceContainer)((Object)bannerObject);
            BBModelRenderer.renderBanner(bannerContainer, matrixStack, vertexConsumerProvider, light, true, baseColor, banner.comp_2428());
        }
    }

    public void renderSails(BBObject object, class_4597 vertexConsumerProvider, T entity, class_4587 matrixStack, int light, float time) {
        class_1767 color;
        List<class_1799> slots = ((InventoryVehicleEntity)((Object)entity)).getSlots(VehicleInventoryDescription.DYE);
        class_1799 stack = slots.stream().findFirst().orElse(class_1799.field_8037);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 item = (class_1769)class_17922;
            color = item.method_7802();
        } else {
            color = class_1767.field_7952;
        }
        int c = color.method_7787();
        float r = (float)(c >> 16 & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c & 0xFF) / 255.0f;
        if (object instanceof BBMesh) {
            BBMesh mesh = (BBMesh)object;
            BBModelRenderer.renderSailObject(mesh, matrixStack, vertexConsumerProvider, light, time, r, g, b, 1.0f);
        }
    }
}

