/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.render.item;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.common.render.item.AzItemRenderer;
import net.minecraft.class_1792;
import org.jetbrains.annotations.Nullable;

public class AzItemRendererRegistry {
    private static final Map<class_1792, AzItemRenderer> ITEM_TO_RENDERER = new HashMap<class_1792, AzItemRenderer>();
    private static final Map<class_1792, Supplier<AzItemRenderer>> ITEM_TO_RENDERER_SUPPLIER = new HashMap<class_1792, Supplier<AzItemRenderer>>();

    public static void register(class_1792 item, Supplier<AzItemRenderer> itemRendererSupplier) {
        ITEM_TO_RENDERER_SUPPLIER.put(item, itemRendererSupplier);
    }

    public static void register(Supplier<AzItemRenderer> itemRendererSupplier, class_1792 item, class_1792 ... items) {
        AzItemRendererRegistry.register(item, itemRendererSupplier);
        for (class_1792 otherItem : items) {
            AzItemRendererRegistry.register(otherItem, itemRendererSupplier);
        }
    }

    @Nullable
    public static AzItemRenderer getOrNull(class_1792 item) {
        return ITEM_TO_RENDERER.computeIfAbsent(item, $ -> {
            Supplier<AzItemRenderer> rendererSupplier = ITEM_TO_RENDERER_SUPPLIER.get(item);
            return rendererSupplier == null ? null : rendererSupplier.get();
        });
    }
}

