/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.render.item;

import java.util.UUID;
import mod.azure.azurelibarmor.AzureLib;
import mod.azure.azurelibarmor.common.animation.impl.AzItemAnimator;
import mod.azure.azurelibarmor.common.model.AzBakedModel;
import mod.azure.azurelibarmor.common.render.AzProvider;
import mod.azure.azurelibarmor.common.render.AzRendererPipelineContext;
import mod.azure.azurelibarmor.common.render.item.AzItemGuiRenderUtil;
import mod.azure.azurelibarmor.common.render.item.AzItemRendererConfig;
import mod.azure.azurelibarmor.common.render.item.AzItemRendererPipeline;
import mod.azure.azurelibarmor.common.render.item.AzItemRendererPipelineContext;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AzItemRenderer {
    private final AzItemRendererConfig config;
    private final AzProvider<UUID, class_1799> provider;
    public final AzItemRendererPipeline rendererPipeline;
    @Nullable
    private AzItemAnimator reusedAzItemAnimator;

    protected AzItemRenderer(AzItemRendererConfig config) {
        this.rendererPipeline = this.createPipeline(config);
        this.provider = new AzProvider<UUID, class_1799>(config::createAnimator, config::modelLocation, animator -> (UUID)animator.method_57824(AzureLib.AZ_ID.get()));
        this.config = config;
    }

    protected AzItemRendererPipeline createPipeline(AzItemRendererConfig config) {
        return new AzItemRendererPipeline(config, this);
    }

    public void renderByGui(class_1799 stack, class_811 transformType, @NotNull class_4587 poseStack, @NotNull class_4597 source, int packedLight) {
        AzRendererPipelineContext context = this.rendererPipeline.context();
        AzBakedModel model = this.provider.provideBakedModel(context.currentEntity(), stack);
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        itemContext.setTransformType(transformType);
        this.prepareAnimator(stack, model);
        AzItemGuiRenderUtil.renderInGui(this.config, this.rendererPipeline, stack, model, stack, poseStack, source, packedLight);
    }

    public void renderByItem(class_1799 stack, class_811 transformType, @NotNull class_4587 poseStack, @NotNull class_4597 source, int packedLight) {
        AzRendererPipelineContext context = this.rendererPipeline.context();
        AzBakedModel model = this.provider.provideBakedModel(context.currentEntity(), stack);
        float partialTick = class_310.method_1551().method_60646().method_60636();
        class_2960 textureLocation = this.config.textureLocation(context.currentEntity(), stack);
        class_1921 renderType = this.rendererPipeline.context().getDefaultRenderType(stack, textureLocation, source, partialTick, this.config.getRenderType(context.currentEntity(), stack), this.config.alpha(stack));
        boolean withGlint = stack != null && stack.method_7958();
        class_4588 buffer = class_918.method_29711((class_4597)source, (class_1921)renderType, (boolean)false, (boolean)withGlint);
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        itemContext.setTransformType(transformType);
        this.prepareAnimator(stack, model);
        this.rendererPipeline.render(poseStack, model, stack, source, renderType, buffer, 0.0f, partialTick, packedLight);
    }

    private void prepareAnimator(class_1799 stack, AzBakedModel model) {
        this.reusedAzItemAnimator = (AzItemAnimator)this.provider.provideAnimator(this.rendererPipeline.context().currentEntity(), stack);
    }

    @Nullable
    public AzItemAnimator getAnimator() {
        return this.reusedAzItemAnimator;
    }

    public AzItemRendererConfig config() {
        return this.config;
    }
}

