/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.structure.placement;

import cn.leolezury.eternalstarlight.common.data.ESStructures;
import cn.leolezury.eternalstarlight.common.registry.ESStructurePlacementTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2382;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6874;
import net.minecraft.class_6875;
import net.minecraft.class_7869;
import net.minecraft.class_7924;

public class LandmarkStructurePlacement
extends class_6874 {
    public static final MapCodec<LandmarkStructurePlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41246).fieldOf("landmark").forGetter(o -> o.landmark)).apply((Applicative)instance, LandmarkStructurePlacement::new));
    private static final List<StructureInfo> STRUCTURES = List.of(new StructureInfo(ESStructures.GOLEM_FORGE, 20), new StructureInfo(ESStructures.CURSED_GARDEN, 40));
    private final class_5321<class_3195> landmark;

    public LandmarkStructurePlacement(class_5321<class_3195> landmark) {
        super(class_2382.field_11176, class_6874.class_7154.field_37782, 1.0f, 0, Optional.empty());
        this.landmark = landmark;
    }

    public static class_1923 getRegionLandmarkPos(class_7869 structureState, int x, int z) {
        int centerX = (x >> 5) * 32 + 16;
        int centerZ = (z >> 5) * 32 + 16;
        int seed = (int)structureState.method_46714() - centerX * 20090707 + centerZ * 2024;
        int seed1 = (int)structureState.method_46714() + centerX * 10370 - centerZ * 1274;
        double random = Math.sin(seed) * 10000.0 - Math.floor(Math.sin(seed) * 10000.0);
        double random1 = Math.sin(seed1) * 10000.0 - Math.floor(Math.sin(seed1) * 10000.0);
        return new class_1923(centerX += (int)(-8.0 + random * 16.0), centerZ += (int)(-8.0 + random1 * 16.0));
    }

    protected boolean method_40168(class_7869 structureState, int x, int z) {
        List<StructureInfo> possibleStructures = STRUCTURES.stream().filter(i -> Math.pow(x, 2.0) + Math.pow(z, 2.0) >= Math.pow(i.minSpawnDistance(), 2.0)).toList();
        if (possibleStructures.isEmpty()) {
            return false;
        }
        class_1923 chunkPos = LandmarkStructurePlacement.getRegionLandmarkPos(structureState, x, z);
        if (chunkPos.field_9181 != x || chunkPos.field_9180 != z) {
            return false;
        }
        return possibleStructures.get(Math.floorMod((x >> 5) + (z >> 5), possibleStructures.size())).structure().method_29177().equals((Object)this.landmark.method_29177());
    }

    public class_6875<?> method_40166() {
        return ESStructurePlacementTypes.LANDMARK.get();
    }

    private record StructureInfo(class_5321<class_3195> structure, int minSpawnDistance) {
    }
}

