/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.Grappling;
import cn.leolezury.eternalstarlight.common.entity.interfaces.GrapplingOwner;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class ChainOfSouls
extends class_1676
implements Grappling {
    private static final String TAG_REACHED_TARGET = "reached_target";
    private static final String TAG_LENGTH = "length";
    private static final String TAG_TARGET = "target";
    private static final String TAG_WEAPON = "weapon";
    private static final double SPEED = 5.0;
    public static final class_2940<Boolean> REACHED_TARGET = class_2945.method_12791(ChainOfSouls.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> LENGTH = class_2945.method_12791(ChainOfSouls.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Integer> TARGET_ID = class_2945.method_12791(ChainOfSouls.class, (class_2941)class_2943.field_13327);
    @Nullable
    private class_1799 firedFromWeapon;
    private int absorbSoulTicks;
    @Nullable
    private class_1297 target;
    @Nullable
    private UUID targetId;

    public class_1297 getTarget() {
        return this.target;
    }

    public void setTarget(class_1297 target) {
        this.targetId = target.method_5667();
        this.target = target;
    }

    public ChainOfSouls(class_1299<? extends ChainOfSouls> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5985 = true;
    }

    public ChainOfSouls(class_1937 level, class_1657 player, @Nullable class_1799 weapon) {
        this(ESEntities.CHAIN_OF_SOULS.get(), level);
        this.method_7432((class_1297)player);
        this.method_5814(player.method_23317(), player.method_23320() - 0.1, player.method_23321());
        this.method_18799(player.method_5828(1.0f).method_1021(5.0));
        this.firedFromWeapon = weapon;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(REACHED_TARGET, (Object)false).method_56912(LENGTH, (Object)Float.valueOf(0.0f)).method_56912(TARGET_ID, (Object)-1);
    }

    public boolean method_5640(double d) {
        return true;
    }

    protected double method_7490() {
        return 0.05;
    }

    public void method_5773() {
        super.method_5773();
        class_1657 player = this.getPlayerOwner();
        if (!this.method_37908().field_9236) {
            class_1937 class_19372;
            if (this.target == null && this.targetId != null && (class_19372 = this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_1297 entity = serverLevel.method_14190(this.targetId);
                if (entity != null) {
                    this.target = entity;
                }
                if (this.target == null) {
                    this.targetId = null;
                }
            }
            if (this.target != null) {
                this.setTargetId(this.target.method_5628());
                this.method_18799(class_243.field_1353);
                if (!this.target.method_5805() || this.target.method_31481() || this.target.method_5858((class_1297)this) > this.getMaxRange() * this.getMaxRange()) {
                    this.target = null;
                    this.targetId = null;
                } else {
                    class_1937 class_19373;
                    class_243 targetPos = this.target.method_19538().method_1031(0.0, (double)(this.target.method_17682() / 2.0f), 0.0);
                    this.method_33574(targetPos);
                    if (this.target instanceof class_1309 && !(this.target instanceof class_1531) && (class_19373 = this.method_37908()) instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)class_19373;
                        class_1657 playerOwner = this.getPlayerOwner();
                        if (playerOwner != null) {
                            class_243 ownerPos;
                            class_243 posDiff;
                            float damage = (float)ESConfig.INSTANCE.itemsConfig.chainOfSouls.soulAbsorbDamage();
                            class_1282 damageSource = ESDamageTypes.getIndirectEntityDamageSource(this.method_37908(), ESDamageTypes.SOUL_ABSORB, (class_1297)this, (class_1297)playerOwner);
                            if (this.method_59958() != null) {
                                damage = class_1890.method_60120((class_3218)serverLevel, (class_1799)this.method_59958(), (class_1297)this.target, (class_1282)damageSource, (float)damage);
                            }
                            if (this.target.method_5643(damageSource, damage)) {
                                int i;
                                playerOwner.method_6025((float)((double)damage * ESConfig.INSTANCE.itemsConfig.chainOfSouls.healPercentage()));
                                this.method_43077(ESSoundEvents.CHAIN_OF_SOULS_ABSORB.get());
                                for (i = 0; i < 7; ++i) {
                                    serverLevel.method_14199((class_2394)class_2398.field_50247, this.target.method_23322(1.0), this.target.method_23319(), this.target.method_23325(1.0), 5, 0.0, 0.0, 0.0, 0.0);
                                }
                                for (i = 0; i < 7; ++i) {
                                    serverLevel.method_14199((class_2394)class_2398.field_50247, playerOwner.method_23322(1.0), playerOwner.method_23319(), playerOwner.method_23325(1.0), 5, 0.0, 0.0, 0.0, 0.0);
                                }
                            }
                            if (!this.target.method_5864().method_20210(ESTags.EntityTypes.CHAIN_OF_SOULS_CANNOT_PULL) && (posDiff = (ownerPos = playerOwner.method_19538().method_1031(0.0, (double)(playerOwner.method_17682() / 2.0f), 0.0)).method_1020(targetPos)).method_1033() > (double)(this.length() * 1.2f)) {
                                double scale = 1.0 - Math.sqrt(Math.min(posDiff.method_1027(), 4096.0)) / 64.0;
                                this.target.method_45319(posDiff.method_1029().method_1021(scale * scale));
                                this.target.field_6037 = true;
                            }
                            ++this.absorbSoulTicks;
                            if (this.absorbSoulTicks > 50) {
                                this.method_31472();
                            }
                        }
                    }
                }
            } else {
                this.absorbSoulTicks = 0;
            }
            AtomicBoolean blockSupport = new AtomicBoolean(false);
            ESBlockUtil.getBlocksInBoundingBox(this.method_5829().method_1009(0.1, 0.05, 0.1).method_989(0.0, 0.05, 0.0)).forEach(pos -> blockSupport.set(blockSupport.get() || this.method_37908().method_8320(pos).method_26220((class_1922)this.method_37908(), pos).method_1090().stream().anyMatch(box -> box.method_996(pos).method_994(this.method_5829()))));
            if (this.reachedTarget() && this.target == null && !blockSupport.get()) {
                this.method_56990();
            }
        }
        if (player != null && (this.method_37908().method_8608() || !this.shouldRetract(player))) {
            class_239 hitResult = class_1675.method_49997((class_1297)this, this::method_26958);
            if (hitResult.method_17783() != class_239.class_240.field_1333 && this.target == null) {
                this.method_7488(hitResult);
            }
            if (this.target == null) {
                this.method_33574(hitResult.method_17784());
            }
            this.method_5852();
        } else {
            this.method_31472();
        }
    }

    private boolean shouldRetract(class_1657 player) {
        if (!(player.method_31481() || !player.method_5805() || player.method_6047() != this.firedFromWeapon && player.method_6079() != this.firedFromWeapon || this.method_5858((class_1297)player) > this.getMaxRange() * this.getMaxRange())) {
            return false;
        }
        this.method_31472();
        return true;
    }

    private double getMaxRange() {
        return ESConfig.INSTANCE.itemsConfig.chainOfSouls.maxRange();
    }

    protected boolean method_26958(class_1297 entity) {
        return entity != this.method_24921();
    }

    protected void method_7454(class_3966 hitResult) {
        super.method_7454(hitResult);
        if (this.target == null && !this.method_37908().field_9236) {
            this.setTarget(hitResult.method_17782());
            class_1657 player = this.getPlayerOwner();
            if (player != null && !this.reachedTarget()) {
                double d = player.method_33571().method_1020(hitResult.method_17784()).method_1033();
                this.setLength(Math.max((float)d * 0.5f - 1.0f, 1.5f));
            }
            this.setReachedTarget(true);
        }
    }

    protected void method_24920(class_3965 hitResult) {
        super.method_24920(hitResult);
        this.method_18799(class_243.field_1353);
        if (!this.method_37908().field_9236) {
            class_1657 player = this.getPlayerOwner();
            if (player != null && !this.reachedTarget()) {
                double d = player.method_33571().method_1020(hitResult.method_17784()).method_1033();
                this.setLength(Math.max((float)d * 0.5f - 3.0f, 1.5f));
            }
            this.setReachedTarget(true);
        }
    }

    @Nullable
    public class_1799 method_59958() {
        return this.firedFromWeapon;
    }

    public void method_5652(class_2487 compoundTag) {
        compoundTag.method_10556(TAG_REACHED_TARGET, this.reachedTarget());
        compoundTag.method_10548(TAG_LENGTH, this.length());
        if (this.target != null) {
            compoundTag.method_25927(TAG_TARGET, this.target.method_5667());
        }
        if (this.firedFromWeapon != null && !this.firedFromWeapon.method_7960()) {
            compoundTag.method_10566(TAG_WEAPON, this.firedFromWeapon.method_57376((class_7225.class_7874)this.method_56673(), (class_2520)new class_2487()));
        }
    }

    public void method_5749(class_2487 compoundTag) {
        this.setReachedTarget(compoundTag.method_10577(TAG_REACHED_TARGET));
        this.setLength(compoundTag.method_10583(TAG_LENGTH));
        if (compoundTag.method_25928(TAG_TARGET)) {
            this.targetId = compoundTag.method_25926(TAG_TARGET);
        }
        this.firedFromWeapon = compoundTag.method_10573(TAG_WEAPON, 10) ? (class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)compoundTag.method_10562(TAG_WEAPON)).orElse(null) : null;
    }

    private void setReachedTarget(boolean reachedTarget) {
        this.method_5841().method_12778(REACHED_TARGET, (Object)reachedTarget);
    }

    private void setLength(float length) {
        this.method_5841().method_12778(LENGTH, (Object)Float.valueOf(length));
    }

    private void setTargetId(int targetId) {
        this.method_5841().method_12778(TARGET_ID, (Object)targetId);
    }

    @Override
    public boolean reachedTarget() {
        return (Boolean)this.method_5841().method_12789(REACHED_TARGET);
    }

    @Override
    public boolean shouldPull() {
        return this.getTarget() == null;
    }

    @Override
    public float length() {
        return ((Float)this.method_5841().method_12789(LENGTH)).floatValue();
    }

    public int getTargetId() {
        return (Integer)this.method_5841().method_12789(TARGET_ID);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public void method_5650(class_1297.class_5529 removalReason) {
        this.updateOwnerInfo(null);
        super.method_5650(removalReason);
    }

    public void method_36209() {
        this.updateOwnerInfo(null);
    }

    public void method_7432(@Nullable class_1297 entity) {
        super.method_7432(entity);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable ChainOfSouls chain) {
        class_1657 player = this.getPlayerOwner();
        if (player instanceof GrapplingOwner) {
            GrapplingOwner owner = (GrapplingOwner)player;
            owner.setESGrappling((class_1297)chain);
        }
    }

    @Nullable
    public class_1657 getPlayerOwner() {
        class_1297 entity = this.method_24921();
        return entity instanceof class_1657 ? (class_1657)entity : null;
    }

    public boolean method_61113(class_1937 level, class_1937 level2) {
        return false;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (this.getPlayerOwner() == null) {
            this.method_5768();
        }
    }
}

