/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.monster;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorManager;
import cn.leolezury.eternalstarlight.common.entity.living.phase.MeleeAttackPhase;
import cn.leolezury.eternalstarlight.common.entity.living.phase.MultiBehaviorUser;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5534;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class ThirstWalker
extends class_1588
implements MultiBehaviorUser,
class_5354 {
    private static final String TAG_HUNGER_LEVEL = "hunger_level";
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private float hungerLevel = 1.0f;
    private class_243 fleeTo;
    private int fleeTicks;
    private class_1297 fleeFrom;
    private static final int MELEE_ID = 1;
    public class_7094 idleAnimationState = new class_7094();
    public class_7094 meleeAnimationState = new class_7094();
    protected static final class_2940<Integer> BEHAVIOR_STATE = class_2945.method_12791(ThirstWalker.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> BEHAVIOR_TICKS = class_2945.method_12791(ThirstWalker.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> INTENTIONAL_ATTACK = class_2945.method_12791(ThirstWalker.class, (class_2941)class_2943.field_13323);
    private final BehaviorManager<ThirstWalker> behaviorManager = new BehaviorManager<ThirstWalker>(this, List.of(new MeleeAttackPhase(1, 1, 20, 10).with(2, 7)));

    @Override
    public int getBehaviorState() {
        return (Integer)this.method_5841().method_12789(BEHAVIOR_STATE);
    }

    @Override
    public void setBehaviorState(int attackState) {
        this.method_5841().method_12778(BEHAVIOR_STATE, (Object)attackState);
    }

    @Override
    public int getBehaviorTicks() {
        return (Integer)this.method_5841().method_12789(BEHAVIOR_TICKS);
    }

    @Override
    public void setBehaviorTicks(int behaviourTicks) {
        this.method_5841().method_12778(BEHAVIOR_TICKS, (Object)behaviourTicks);
    }

    public boolean isIntentionalAttack() {
        return (Boolean)this.method_5841().method_12789(INTENTIONAL_ATTACK);
    }

    public void setIntentionalAttack(boolean intentionalAttack) {
        this.method_5841().method_12778(INTENTIONAL_ATTACK, (Object)intentionalAttack);
    }

    public ThirstWalker(class_1299<? extends ThirstWalker> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(BEHAVIOR_STATE, (Object)0).method_56912(BEHAVIOR_TICKS, (Object)0).method_56912(INTENTIONAL_ATTACK, (Object)false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1366(this, (class_1314)this, 1.0, false){

            protected void method_6288(class_1309 livingEntity) {
            }
        });
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_5398((class_1308)this, false));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, ESConfig.INSTANCE.mobsConfig.thirstWalker.maxHealth()).method_26868(class_5134.field_23724, ESConfig.INSTANCE.mobsConfig.thirstWalker.armor()).method_26868(class_5134.field_23721, ESConfig.INSTANCE.mobsConfig.thirstWalker.attackDamage()).method_26868(class_5134.field_23717, ESConfig.INSTANCE.mobsConfig.thirstWalker.followRange()).method_26868(class_5134.field_23719, 0.3);
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        ESBookUtil.unlock(serverPlayer, EternalStarlight.id("thirst_walker"));
    }

    public void method_5980(@Nullable class_1309 livingEntity) {
        super.method_5980(livingEntity);
        if (livingEntity != null) {
            this.setIntentionalAttack(false);
        }
    }

    public boolean method_6121(class_1297 entity) {
        class_1309 living;
        boolean flag = super.method_6121(entity);
        if (flag && entity instanceof class_1309) {
            living = (class_1309)entity;
            float f = this.method_37908().method_8404(this.method_24515()).method_5457();
            living.method_37222(new class_1293(class_1294.field_5903, 140 * (int)f), (class_1297)this);
            this.hungerLevel = Math.min(this.hungerLevel + (this.isIntentionalAttack() ? 0.6f : 0.1f), 1.0f);
        }
        if (this.isIntentionalAttack()) {
            this.method_29922();
            this.fleeFrom = entity;
            this.fleeTicks = 100;
            this.tryFlee();
            if (entity instanceof class_1309 && (living = (class_1309)entity).method_6039() && this.method_59922().method_43048(6) == 0) {
                int i = this.method_59922().method_43048(3);
                for (int j = 0; j < i; ++j) {
                    class_1542 itemEntity = this.method_5870((class_1935)ESItems.TOOTH_OF_HUNGER.get(), 1);
                    if (itemEntity == null) continue;
                    itemEntity.method_18799(itemEntity.method_18798().method_1031((double)((this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.1f), (double)(this.method_59922().method_43057() * 0.05f), (double)((this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.1f)));
                }
            }
        }
        return flag;
    }

    protected void method_5958() {
        super.method_5958();
        if (this.method_5968() != null && !this.method_5968().method_5805()) {
            this.method_5980(null);
        }
        if (!this.method_5987() && this.method_5805()) {
            this.behaviorManager.tick();
        }
        if (this.fleeTicks > 0) {
            --this.fleeTicks;
            if (this.field_6012 % 20 == 0) {
                this.tryFlee();
            }
        }
    }

    private void tryFlee() {
        class_243 fleePos;
        if (this.fleeFrom != null && (fleePos = class_5534.method_31534((class_1314)this, (int)20, (int)8, (class_243)this.fleeFrom.method_19538())) != null) {
            this.fleeTo = fleePos;
        }
        if (this.fleeTo != null) {
            this.method_5942().method_6340();
            this.method_5942().method_6337(this.fleeTo.field_1352, this.fleeTo.field_1351, this.fleeTo.field_1350, 1.5);
            this.method_5962().method_6239(this.fleeTo.field_1352, this.fleeTo.field_1351, this.fleeTo.field_1350, 1.5);
        }
    }

    public void method_5773() {
        class_1937 class_19372;
        super.method_5773();
        if (!this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218) {
            List players;
            class_3218 serverLevel = (class_3218)class_19372;
            this.method_29510(serverLevel, true);
            if ((double)this.hungerLevel < 0.3 && this.method_5968() == null && (this.field_6012 + this.method_5628() * 17) % 1200 == 0 && !(players = this.method_37908().method_18466(class_1657.class, class_4051.field_18092, (class_1309)this, this.method_5829().method_1014(20.0))).isEmpty()) {
                class_1657 target = (class_1657)players.get(this.method_59922().method_43048(players.size()));
                this.method_5980((class_1309)target);
                this.setIntentionalAttack(true);
            }
            this.hungerLevel = Math.max(this.hungerLevel - 0.001f, 0.0f);
        }
        if (this.method_37908().field_9236) {
            this.idleAnimationState.method_41324(this.field_6012);
        }
    }

    public void method_5674(class_2940<?> accessor) {
        if (accessor.equals(BEHAVIOR_STATE) && this.getBehaviorState() != 0) {
            if (this.getBehaviorState() == 1) {
                this.meleeAnimationState.method_41322(this.field_6012);
            } else {
                this.meleeAnimationState.method_41325();
            }
        }
        super.method_5674(accessor);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.method_29517(compoundTag);
        compoundTag.method_10548(TAG_HUNGER_LEVEL, this.hungerLevel);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.method_29512(this.method_37908(), compoundTag);
        if (compoundTag.method_10573(TAG_HUNGER_LEVEL, 5)) {
            this.hungerLevel = compoundTag.method_10583(TAG_HUNGER_LEVEL);
        }
    }

    @Nullable
    protected class_3414 method_5994() {
        return ESSoundEvents.THIRST_WALKER_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return ESSoundEvents.THIRST_WALKER_HURT.get();
    }

    protected class_3414 method_6002() {
        return ESSoundEvents.THIRST_WALKER_DEATH.get();
    }

    public int method_29507() {
        return this.remainingPersistentAngerTime;
    }

    public void method_29514(int i) {
        this.remainingPersistentAngerTime = i;
    }

    @Nullable
    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public void method_29513(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.method_59922()));
    }

    public static boolean checkThirstWalkerSpawnRules(class_1299<? extends ThirstWalker> type, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        return ThirstWalker.method_20681(type, (class_1936)level, (class_3730)spawnType, (class_2338)pos, (class_5819)random) && ESConfig.INSTANCE.mobsConfig.thirstWalker.canSpawn();
    }
}

