/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.TangledHatredPart;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.TangledHatredSmokePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.TangledHatredSporePhase;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorManager;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.Chain;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3988;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class TangledHatred
extends ESBoss {
    private static final String TAG_CHAIN = "chain";
    protected static final class_2940<class_2487> CHAIN = class_2945.method_12791(TangledHatred.class, (class_2941)class_2943.field_13318);
    public Chain chain;
    public Chain oldChain;
    public final List<TangledHatredPart> parts = new ArrayList<TangledHatredPart>();
    private class_243 targetPos = null;
    private class_243 currentTargetPos = null;
    private int ticksToNextMeleeAttack;
    private final BehaviorManager<TangledHatred> behaviorManager = new BehaviorManager<TangledHatred>(this, List.of(new TangledHatredSmokePhase(), new TangledHatredSporePhase()));

    public Chain getSyncedChain() {
        return Chain.load((class_2487)this.method_5841().method_12789(CHAIN));
    }

    public void setSyncedChain(Chain chain) {
        class_2487 tag = new class_2487();
        chain.save(tag);
        this.method_5841().method_12778(CHAIN, (Object)tag);
    }

    public TangledHatred(class_1299<? extends TangledHatred> type, class_1937 level) {
        super(type, level);
        this.chain = this.createChain();
        this.oldChain = this.createChain();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, ESConfig.INSTANCE.mobsConfig.tangledHatred.maxHealth()).method_26868(class_5134.field_23724, ESConfig.INSTANCE.mobsConfig.tangledHatred.armor()).method_26868(class_5134.field_23721, 5.0 * ESConfig.INSTANCE.mobsConfig.tangledHatred.attackDamageScale()).method_26868(class_5134.field_23717, ESConfig.INSTANCE.mobsConfig.tangledHatred.followRange()).method_26868(class_5134.field_23719, 0.0);
    }

    private Chain createChain() {
        Chain c = new Chain(this.method_19538(), 18, 1.5625f);
        float lastPitch = 0.0f;
        float lastYaw = 0.0f;
        class_243 lastLowerPos = this.method_19538();
        for (int i = 0; i < c.segments().size(); ++i) {
            Chain.Segment segment = c.segments().get(i);
            segment.setPitch(lastPitch);
            segment.setYaw(lastYaw);
            lastPitch += 7.5f;
            lastYaw += 5.0f;
            segment.setUpperPosition(lastLowerPos);
            lastLowerPos = segment.getLowerPosition();
        }
        class_243 offset = this.method_19538().method_1020(lastLowerPos);
        for (Chain.Segment segment : c.segments()) {
            segment.setLowerPosition(segment.getLowerPosition().method_1019(offset));
        }
        return c;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        if (this.chain == null) {
            this.chain = this.createChain();
        }
        class_2487 tag = new class_2487();
        this.chain.save(tag);
        builder.method_56912(CHAIN, (Object)tag);
    }

    protected void method_5959() {
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{TangledHatred.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    public void method_18799(class_243 vec3) {
        super.method_18799(new class_243(0.0, vec3.field_1351 < 0.0 ? vec3.field_1351 : 0.0, 0.0));
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        ESBookUtil.unlock(serverPlayer, EternalStarlight.id("tangled_hatred"));
    }

    public boolean method_6121(class_1297 entity) {
        boolean flag = super.method_6121(entity);
        if (flag && !this.method_37908().field_9236) {
            this.ticksToNextMeleeAttack = 40;
            this.chain.getEndPos().ifPresent(vec3 -> ((class_3218)entity.method_37908()).method_14199((class_2394)ESExplosionParticleOptions.LUNAR, vec3.field_1352, vec3.field_1351, vec3.field_1350, 3, 0.1, 0.1, 0.1, 0.0));
        }
        return flag;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972;
        if (source.method_5529() != null && source.method_5529().method_5864().method_20210(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS)) {
            return false;
        }
        boolean flag = super.method_5643(source, amount * (this.method_5809() ? 1.6f : 1.0f));
        if (flag && this.getBehaviorState() == 1 && (class_12972 = source.method_5526()) instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            entity.field_6037 = true;
            entity.method_18799(entity.method_19538().method_1020(this.method_19538()).method_1029().method_1021(1.5));
        }
        return flag;
    }

    public boolean method_5722(class_1297 entity) {
        return super.method_5722(entity) || entity.method_5864().method_20210(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS);
    }

    public Optional<class_243> calculateAttackTargetPos() {
        class_1309 target = this.method_5968();
        if (target != null && this.getBehaviorState() == 2) {
            return Optional.of(target.method_19538().method_1031(0.0, (double)(target.method_17682() * 6.0f), 0.0));
        }
        if (target != null && this.ticksToNextMeleeAttack == 0) {
            return Optional.of(target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0));
        }
        return Optional.empty();
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            Object targetPitch2;
            if (!this.method_5987() && this.method_5805()) {
                this.behaviorManager.tick();
            }
            class_1309 target = this.method_5968();
            if (this.ticksToNextMeleeAttack > 0) {
                --this.ticksToNextMeleeAttack;
            }
            if (this.targetPos != null) {
                if (this.currentTargetPos == null) {
                    this.currentTargetPos = this.method_19538();
                }
            } else {
                this.targetPos = this.method_19538().method_49272(this.method_59922(), 10.0f);
            }
            if (this.chain.getEndPos().isPresent()) {
                class_243 endPos = this.chain.getEndPos().get();
                float targetPitch2 = ESMathUtil.positionToPitch(this.method_19538(), this.targetPos);
                float targetYaw = ESMathUtil.positionToYaw(this.method_19538(), this.targetPos);
                float currentPitch = ESMathUtil.positionToPitch(this.method_19538(), endPos);
                float currentYaw = ESMathUtil.positionToYaw(this.method_19538(), endPos);
                float speed = 0.3f;
                float turnSpeed = 0.5f;
                float pitch = class_3532.method_15388((float)currentPitch, (float)targetPitch2, (float)turnSpeed);
                float yaw = class_3532.method_15388((float)currentYaw, (float)targetYaw, (float)turnSpeed);
                float radius = class_3532.method_15348((float)((float)endPos.method_1022(this.method_19538())), (float)((float)this.targetPos.method_1022(this.method_19538())), (float)speed);
                this.currentTargetPos = ESMathUtil.rotationToPosition(this.method_19538(), radius, pitch, yaw);
            }
            if (target != null) {
                this.calculateAttackTargetPos().ifPresent(vec3 -> {
                    this.targetPos = vec3;
                });
            }
            if (target == null && this.field_6012 % 60 == 0) {
                this.targetPos = this.method_19538().method_49272(this.method_59922(), 10.0f);
                if (this.targetPos.field_1351 < this.method_19538().field_1351) {
                    this.targetPos = new class_243(this.targetPos.field_1352, this.method_19538().method_10214() + (double)this.method_59922().method_43051(5, 15), this.targetPos.field_1350);
                }
            }
            if (target != null && this.ticksToNextMeleeAttack == 0 && target.method_5829().method_1006(this.chain.getEndPos().orElse(this.method_19538().method_1031(0.0, (double)this.method_17682(), 0.0)))) {
                this.method_6121((class_1297)target);
            }
            if (this.currentTargetPos != null) {
                this.chain.update(this.currentTargetPos, this.method_19538(), 3.0f);
            }
            if ((targetPitch2 = this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)targetPitch2;
                for (Chain.Segment segment : this.chain.segments()) {
                    if (!this.method_29504() && this.method_37908().method_8320(class_2338.method_49638((class_2374)segment.getLowerPosition())).method_26215() && this.method_37908().method_8320(class_2338.method_49638((class_2374)segment.getMiddlePosition())).method_26215() && this.method_37908().method_8320(class_2338.method_49638((class_2374)segment.getUpperPosition())).method_26215()) continue;
                    class_243 base = segment.getMiddlePosition();
                    for (int j = 0; j < 2; ++j) {
                        class_243 vec32 = base.method_49272(this.method_59922(), 2.0f);
                        for (int m = 0; m < serverLevel.method_18456().size(); ++m) {
                            class_3222 serverPlayer = (class_3222)serverLevel.method_18456().get(m);
                            serverLevel.method_14166(serverPlayer, (class_2394)ESExplosionParticleOptions.LUNAR, true, vec32.field_1352, vec32.field_1351, vec32.field_1350, 3, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            int numSegments = this.chain.segments().size();
            ArrayList<TangledHatredPart> partsToRemove = new ArrayList<TangledHatredPart>();
            for (TangledHatredPart part : this.parts) {
                if (!part.method_31481() && part.getParent() == this) continue;
                partsToRemove.add(part);
            }
            for (TangledHatredPart part : partsToRemove) {
                this.parts.remove((Object)part);
            }
            if (this.parts.size() != numSegments) {
                for (TangledHatredPart part : this.parts) {
                    part.method_31472();
                }
                this.parts.clear();
                for (int i = 0; i < numSegments; ++i) {
                    TangledHatredPart part = new TangledHatredPart(ESEntities.TANGLED_HATRED_PART.get(), this.method_37908());
                    part.method_33574(this.chain.segments().get(i).getMiddlePosition());
                    part.setParent(this);
                    this.method_37908().method_8649((class_1297)part);
                    this.parts.add(part);
                }
            }
            if (this.parts.size() == numSegments) {
                for (int i = 0; i < numSegments; ++i) {
                    TangledHatredPart part = this.parts.get(i);
                    part.method_33574(this.chain.segments().get(i).getMiddlePosition());
                }
            }
            this.setSyncedChain(this.chain);
        } else {
            this.oldChain = this.chain;
            if (!this.getSyncedChain().segments().isEmpty()) {
                this.chain = this.getSyncedChain();
            }
        }
    }

    @Override
    public boolean shouldPlayBossMusic() {
        return false;
    }

    @Override
    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_10573(TAG_CHAIN, 10)) {
            this.chain = Chain.load(compoundTag.method_10562(TAG_CHAIN));
        }
    }

    @Override
    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        class_2487 chainTag = new class_2487();
        this.chain.save(chainTag);
        compoundTag.method_10566(TAG_CHAIN, (class_2520)chainTag);
    }

    @Nullable
    protected class_3414 method_5994() {
        return ESSoundEvents.TANGLED_HATRED_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return ESSoundEvents.TANGLED_HATRED_HURT.get();
    }

    protected class_3414 method_6002() {
        return ESSoundEvents.TANGLED_HATRED_HURT.get();
    }
}

