/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class DuskLightBlockEntity
extends class_2586 {
    private static final String TAG_FACING = "facing";
    private static final String TAG_LENGTH = "length";
    private static final String TAG_LIT = "lit";
    public static final float MAX_LENGTH = 15.0f;
    private static final List<class_2350> ORDER = Arrays.stream(class_2350.values()).toList();
    private class_2350 facing = class_2350.field_11036;
    private float length = 15.0f;
    private int ticksLeft = 0;
    private boolean lit = false;
    private final Object2FloatMap<class_2350> beamProgresses = new Object2FloatArrayMap();
    private final Object2FloatMap<class_2350> oldBeamProgresses = new Object2FloatArrayMap();

    public DuskLightBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ESBlockEntities.DUSK_LIGHT.get(), blockPos, blockState);
    }

    public boolean isLit() {
        return this.lit;
    }

    public Object2FloatMap<class_2350> getBeamProgresses() {
        return this.beamProgresses;
    }

    public Object2FloatMap<class_2350> getOldBeamProgresses() {
        return this.oldBeamProgresses;
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        compoundTag.method_10569(TAG_FACING, this.facing.method_10146());
        compoundTag.method_10548(TAG_LENGTH, this.length);
        compoundTag.method_10556(TAG_LIT, this.lit);
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.facing = class_2350.method_10143((int)compoundTag.method_10550(TAG_FACING));
        this.length = compoundTag.method_10583(TAG_LENGTH);
        this.lit = compoundTag.method_10577(TAG_LIT);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38242(provider);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, DuskLightBlockEntity entity) {
        if (level.field_9236) {
            entity.oldBeamProgresses.clear();
            entity.oldBeamProgresses.putAll(entity.beamProgresses);
            for (class_2350 direction : class_2350.values()) {
                if (!entity.beamProgresses.containsKey((Object)direction)) {
                    entity.beamProgresses.put((Object)direction, 0.0f);
                }
                if (direction.equals((Object)entity.facing) && entity.lit) {
                    entity.beamProgresses.put((Object)direction, class_3532.method_15363((float)(entity.beamProgresses.getFloat((Object)direction) + 0.05f), (float)0.0f, (float)(entity.length / 15.0f)));
                    continue;
                }
                entity.beamProgresses.put((Object)direction, class_3532.method_15363((float)(entity.beamProgresses.getFloat((Object)direction) - 0.15f), (float)0.0f, (float)1.0f));
            }
            if (entity.lit) {
                EternalStarlight.getClientHelper().spawnManaCrystalItemParticles(ManaType.BLAZE, pos.method_46558().method_1019(new class_243((double)entity.facing.method_10148(), (double)entity.facing.method_10164(), (double)entity.facing.method_10165()).method_1021((double)entity.length)));
            }
        } else {
            float oldLength = entity.length;
            boolean oldLit = entity.lit;
            class_3965 result = level.method_17742(new class_3959(pos.method_46558().method_1019(new class_243((double)entity.facing.method_10148(), (double)entity.facing.method_10164(), (double)entity.facing.method_10165()).method_1021(0.51)), pos.method_46558().method_1019(new class_243((double)entity.facing.method_10148(), (double)entity.facing.method_10164(), (double)entity.facing.method_10165()).method_1021(15.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
            if (result.method_17783() != class_239.class_240.field_1333) {
                Object object;
                entity.length = (float)result.method_17784().method_1020(pos.method_46558()).method_1033();
                if (entity.lit && (object = level.method_8321(result.method_17777())) instanceof DuskLightBlockEntity) {
                    DuskLightBlockEntity light = (DuskLightBlockEntity)((Object)object);
                    light.ticksLeft = 5;
                }
                if (level.method_8320(result.method_17777()).method_27852((class_2248)ESBlocks.ECLIPSE_CORE.get())) {
                    level.method_22352(result.method_17777(), false);
                }
            } else {
                entity.length = 15.0f;
            }
            if (level.method_8320(pos.method_10074()).method_26164(ESTags.Blocks.DUSK_LIGHT_ENERGY_SOURCES)) {
                entity.ticksLeft = 5;
            }
            --entity.ticksLeft;
            if (entity.ticksLeft < 0) {
                entity.ticksLeft = 0;
            }
            boolean bl = entity.lit = entity.ticksLeft > 0;
            if (entity.lit) {
                List entities = level.method_18467(class_1297.class, new class_238(pos.method_46558().method_1023(0.5, 0.5, 0.5), pos.method_46558().method_43206(entity.facing, (double)entity.length).method_1031(0.5, 0.5, 0.5)));
                for (class_1297 e : entities) {
                    e.method_20803(Math.max(e.method_20802(), 100));
                }
            }
            if ((double)Math.abs(entity.length - oldLength) < 0.01 || oldLit != entity.lit) {
                entity.markUpdated();
            }
        }
    }

    public void setFacing() {
        this.facing = ORDER.get((ORDER.indexOf(this.facing) + 1) % ORDER.size());
        this.markUpdated();
    }

    private void markUpdated() {
        if (this.method_10997() != null) {
            this.method_5431();
            this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }
}

