/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.entity.living.AethersentGolem;
import cn.leolezury.eternalstarlight.common.entity.living.GrimstoneGolem;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1439;
import net.minecraft.class_1473;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2694;
import net.minecraft.class_2697;
import net.minecraft.class_2700;
import net.minecraft.class_2715;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class CarvedLunarisCactusFruitBlock
extends class_2383 {
    public static final MapCodec<CarvedLunarisCactusFruitBlock> CODEC = CarvedLunarisCactusFruitBlock.method_54094(CarvedLunarisCactusFruitBlock::new);
    public static final class_2753 FACING = class_2383.field_11177;
    @Nullable
    private class_2700 snowGolemBase;
    @Nullable
    private class_2700 snowGolemFull;
    @Nullable
    private class_2700 ironGolemBase;
    @Nullable
    private class_2700 ironGolemFull;
    @Nullable
    private class_2700 grimstoneGolemBase;
    @Nullable
    private class_2700 grimstoneGolemFull;
    @Nullable
    private class_2700 aethersentGolemBase;
    @Nullable
    private class_2700 aethersentGolemFull;
    private static final Predicate<class_2680> LUNARIS_CACTUS_FRUIT_PREDICATE = state -> state != null && (state.method_27852((class_2248)ESBlocks.CARVED_LUNARIS_CACTUS_FRUIT.get()) || state.method_27852((class_2248)ESBlocks.LUNARIS_CACTUS_FRUIT_LANTERN.get()));

    public CarvedLunarisCactusFruitBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public MapCodec<? extends CarvedLunarisCactusFruitBlock> method_53969() {
        return CODEC;
    }

    protected void method_9615(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        super.method_9615(blockState, level, blockPos, blockState2, bl);
        if (!blockState2.method_27852(blockState.method_26204())) {
            this.trySpawnGolem(level, blockPos);
        }
    }

    public boolean canSpawnGolem(class_4538 levelReader, class_2338 blockPos) {
        return this.getOrCreateSnowGolemBase().method_11708(levelReader, blockPos) != null || this.getOrCreateIronGolemBase().method_11708(levelReader, blockPos) != null || this.getOrCreateGrimstoneGolemBase().method_11708(levelReader, blockPos) != null || this.getOrCreateAethersentGolemBase().method_11708(levelReader, blockPos) != null;
    }

    private void trySpawnGolem(class_1937 level, class_2338 blockPos) {
        AethersentGolem aethersentGolem;
        class_2700.class_2702 snowGolemMatch = this.getOrCreateSnowGolemFull().method_11708((class_4538)level, blockPos);
        class_2700.class_2702 ironGolemMatch = this.getOrCreateIronGolemFull().method_11708((class_4538)level, blockPos);
        class_2700.class_2702 grimstoneGolemMatch = this.getOrCreateGrimstoneGolemFull().method_11708((class_4538)level, blockPos);
        class_2700.class_2702 aethersentGolemMatch = this.getOrCreateAethersentGolemFull().method_11708((class_4538)level, blockPos);
        if (snowGolemMatch != null) {
            class_1473 snowGolem = (class_1473)class_1299.field_6047.method_5883(level);
            if (snowGolem != null) {
                CarvedLunarisCactusFruitBlock.spawnGolemInWorld(level, snowGolemMatch, (class_1297)snowGolem, snowGolemMatch.method_11717(0, 2, 0).method_11683());
            }
        } else if (ironGolemMatch != null) {
            class_1439 ironGolem = (class_1439)class_1299.field_6147.method_5883(level);
            if (ironGolem != null) {
                ironGolem.method_6499(true);
                CarvedLunarisCactusFruitBlock.spawnGolemInWorld(level, ironGolemMatch, (class_1297)ironGolem, ironGolemMatch.method_11717(1, 2, 0).method_11683());
            }
        } else if (grimstoneGolemMatch != null) {
            GrimstoneGolem grimstoneGolem = (GrimstoneGolem)ESEntities.GRIMSTONE_GOLEM.get().method_5883(level);
            if (grimstoneGolem != null) {
                CarvedLunarisCactusFruitBlock.spawnGolemInWorld(level, grimstoneGolemMatch, (class_1297)grimstoneGolem, grimstoneGolemMatch.method_11717(0, 1, 0).method_11683());
            }
        } else if (aethersentGolemMatch != null && (aethersentGolem = (AethersentGolem)ESEntities.AETHERSENT_GOLEM.get().method_5883(level)) != null) {
            CarvedLunarisCactusFruitBlock.spawnGolemInWorld(level, aethersentGolemMatch, (class_1297)aethersentGolem, aethersentGolemMatch.method_11717(0, 1, 0).method_11683());
        }
    }

    private static void spawnGolemInWorld(class_1937 level, class_2700.class_2702 blockPatternMatch, class_1297 entity, class_2338 blockPos) {
        CarvedLunarisCactusFruitBlock.clearPatternBlocks(level, blockPatternMatch);
        entity.method_5808((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.05, (double)blockPos.method_10260() + 0.5, 0.0f, 0.0f);
        level.method_8649(entity);
        for (class_3222 serverPlayer : level.method_18467(class_3222.class, entity.method_5829().method_1014(5.0))) {
            class_174.field_1182.method_9124(serverPlayer, entity);
        }
        CarvedLunarisCactusFruitBlock.updatePatternBlocks(level, blockPatternMatch);
    }

    public static void clearPatternBlocks(class_1937 level, class_2700.class_2702 blockPatternMatch) {
        for (int i = 0; i < blockPatternMatch.method_35302(); ++i) {
            for (int j = 0; j < blockPatternMatch.method_35303(); ++j) {
                class_2694 blockInWorld = blockPatternMatch.method_11717(i, j, 0);
                level.method_8652(blockInWorld.method_11683(), class_2246.field_10124.method_9564(), 2);
                level.method_20290(2001, blockInWorld.method_11683(), class_2248.method_9507((class_2680)blockInWorld.method_11681()));
            }
        }
    }

    public static void updatePatternBlocks(class_1937 level, class_2700.class_2702 blockPatternMatch) {
        for (int i = 0; i < blockPatternMatch.method_35302(); ++i) {
            for (int j = 0; j < blockPatternMatch.method_35303(); ++j) {
                class_2694 blockInWorld = blockPatternMatch.method_11717(i, j, 0);
                level.method_8408(blockInWorld.method_11683(), class_2246.field_10124);
            }
        }
    }

    public class_2680 method_9605(class_1750 blockPlaceContext) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)blockPlaceContext.method_8042().method_10153());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    private class_2700 getOrCreateSnowGolemBase() {
        if (this.snowGolemBase == null) {
            this.snowGolemBase = class_2697.method_11701().method_11702(new String[]{" ", "#", "#"}).method_11700('#', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10491))).method_11704();
        }
        return this.snowGolemBase;
    }

    private class_2700 getOrCreateSnowGolemFull() {
        if (this.snowGolemFull == null) {
            this.snowGolemFull = class_2697.method_11701().method_11702(new String[]{"^", "#", "#"}).method_11700('^', class_2694.method_11678(LUNARIS_CACTUS_FRUIT_PREDICATE)).method_11700('#', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10491))).method_11704();
        }
        return this.snowGolemFull;
    }

    private class_2700 getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = class_2697.method_11701().method_11702(new String[]{"~ ~", "###", "~#~"}).method_11700('#', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10085))).method_11700('~', blockInWorld -> blockInWorld.method_11681().method_26215()).method_11704();
        }
        return this.ironGolemBase;
    }

    private class_2700 getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = class_2697.method_11701().method_11702(new String[]{"~^~", "###", "~#~"}).method_11700('^', class_2694.method_11678(LUNARIS_CACTUS_FRUIT_PREDICATE)).method_11700('#', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10085))).method_11700('~', blockInWorld -> blockInWorld.method_11681().method_26215()).method_11704();
        }
        return this.ironGolemFull;
    }

    private class_2700 getOrCreateGrimstoneGolemBase() {
        if (this.grimstoneGolemBase == null) {
            this.grimstoneGolemBase = class_2697.method_11701().method_11702(new String[]{" ", "#"}).method_11700('#', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)ESBlocks.GRIMSTONE_BRICKS.get()))).method_11704();
        }
        return this.grimstoneGolemBase;
    }

    private class_2700 getOrCreateGrimstoneGolemFull() {
        if (this.grimstoneGolemFull == null) {
            this.grimstoneGolemFull = class_2697.method_11701().method_11702(new String[]{"^", "#"}).method_11700('^', class_2694.method_11678(LUNARIS_CACTUS_FRUIT_PREDICATE)).method_11700('#', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)ESBlocks.GRIMSTONE_BRICKS.get()))).method_11704();
        }
        return this.grimstoneGolemFull;
    }

    private class_2700 getOrCreateAethersentGolemBase() {
        if (this.aethersentGolemBase == null) {
            this.aethersentGolemBase = class_2697.method_11701().method_11702(new String[]{" ", "#"}).method_11700('#', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)ESBlocks.AETHERSENT_BLOCK.get()))).method_11704();
        }
        return this.aethersentGolemBase;
    }

    private class_2700 getOrCreateAethersentGolemFull() {
        if (this.aethersentGolemFull == null) {
            this.aethersentGolemFull = class_2697.method_11701().method_11702(new String[]{"^", "#"}).method_11700('^', class_2694.method_11678(LUNARIS_CACTUS_FRUIT_PREDICATE)).method_11700('#', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)ESBlocks.AETHERSENT_BLOCK.get()))).method_11704();
        }
        return this.aethersentGolemFull;
    }
}

