/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class ContextButton
extends Button {
    public final ContextMenuItem item;
    private final boolean hasIcons;

    public ContextButton(Panel panel, ContextMenuItem item, boolean hasIcons) {
        super(panel, item.getTitle(), item.getIcon());
        this.hasIcons = hasIcons;
        this.item = item;
        this.setSize(panel.getGui().getTheme().getStringWidth((class_5348)item.getTitle()) + (hasIcons ? 14 : 4), 12);
    }

    @Override
    public void addMouseOverText(TooltipList list) {
        this.item.addMouseOverText(list);
    }

    @Override
    public WidgetType getWidgetType() {
        if (!this.item.isClickable()) {
            return WidgetType.NORMAL;
        }
        return this.item.isEnabled() ? super.getWidgetType() : WidgetType.DISABLED;
    }

    @Override
    public void drawIcon(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        this.item.drawIcon(graphics, theme, x, y, w, h);
    }

    @Override
    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        GuiHelper.setupDrawing();
        if (this.hasIcons) {
            this.drawIcon(graphics, theme, x + 1, y + 2, 8, 8);
            theme.drawString(graphics, this.getTitle(), x + 11, y + 2, theme.getContentColor(this.getWidgetType()), 2);
        } else {
            theme.drawString(graphics, this.getTitle(), x + 2, y + 2, theme.getContentColor(this.getWidgetType()), 2);
        }
    }

    @Override
    public void onClicked(MouseButton button) {
        if (this.item.isClickable()) {
            this.playClickSound();
        }
        if (this.item.getYesNoText().getString().isEmpty()) {
            this.item.onClicked(this, this.parent, button);
        } else {
            this.getGui().openYesNo(this.item.getYesNoText(), (class_2561)class_2561.method_43470((String)""), () -> this.item.onClicked(this, this.parent, button));
        }
    }
}

