/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.event;

import dev.architectury.event.fabric.EventHandlerImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public final class EventHandler {
    private static boolean initialized = false;

    private EventHandler() {
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (Platform.getEnvironment() == Env.CLIENT) {
            EventHandler.registerClient();
        }
        EventHandler.registerCommon();
        if (Platform.getEnvironment() == Env.SERVER) {
            EventHandler.registerServer();
        }
    }

    @ExpectPlatform
    @Environment(value=EnvType.CLIENT)
    @ExpectPlatform.Transformed
    private static void registerClient() {
        EventHandlerImpl.registerClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerCommon() {
        EventHandlerImpl.registerCommon();
    }

    @ExpectPlatform
    @Environment(value=EnvType.SERVER)
    @ExpectPlatform.Transformed
    private static void registerServer() {
        EventHandlerImpl.registerServer();
    }
}

