/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.artificers.spells;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.class_2960;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class ArtificersSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 7;
        spell.learn = new Spell.Learn();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.active.scroll = new Spell.Active.Scroll();
        return spell;
    }

    private static Spell.Delivery createDelivery(Spell.Delivery.Type type) {
        Spell.Delivery delivery = new Spell.Delivery();
        delivery.type = type;
        return delivery;
    }

    private static Spell.Impact createImpact(Spell.Impact.Action.Type type, float coeff, float knockback) {
        Spell.Impact impact = new Spell.Impact();
        impact.action = new Spell.Impact.Action();
        impact.action.type = type;
        if (type == Spell.Impact.Action.Type.DAMAGE) {
            impact.action.damage = new Spell.Impact.Action.Damage();
            impact.action.damage.knockback = knockback;
            impact.action.damage.spell_power_coefficient = coeff;
        }
        return impact;
    }

    private static Spell projectileBase(SpellSchool school, class_2960 projIdentifier, float velocity, float knockback) {
        Spell spell = ArtificersSpells.activeSpellBase();
        spell.school = school;
        Spell.Delivery delivery = ArtificersSpells.createDelivery(Spell.Delivery.Type.PROJECTILE);
        delivery.projectile = new Spell.Delivery.ShootProjectile();
        delivery.projectile.launch_properties.velocity = velocity;
        delivery.projectile.projectile = new Spell.ProjectileData();
        delivery.projectile.projectile.client_data = new Spell.ProjectileData.Client();
        Spell.ProjectileModel model = new Spell.ProjectileModel();
        model.model_id = String.valueOf(projIdentifier);
        delivery.projectile.projectile.client_data.model = model;
        spell.deliver = delivery;
        Spell.Impact[] impact = new Spell.Impact[]{ArtificersSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, 1.8f, knockback)};
        spell.impacts = List.of(impact[0]);
        return spell;
    }

    public static Spell.Impact createArcaneImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = ArtificersSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.ARCANE;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_arcane_impact_burst", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_ARCANE_RELEASE.id());
        return impact;
    }

    public static Spell.Impact createLightningImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = ArtificersSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.LIGHTNING;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.WHITE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.BURST).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_LIGHTNING_RELEASE.id());
        return impact;
    }

    private static Spell.Impact createFrostImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = ArtificersSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.FROST;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_frost_impact_burst", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        Spell.TargetCondition targetCondition = new Spell.TargetCondition();
        targetCondition.entity_type = "#minecraft:freeze_immune_entity_types";
        Spell.Impact.TargetModifier targetModifier = new Spell.Impact.TargetModifier();
        targetModifier.conditions = List.of(targetCondition);
        targetModifier.modifier = new Spell.Impact.Modifier();
        targetModifier.modifier.power_multiplier = -0.3f;
        Spell.Impact.TargetModifier targetModifier2 = new Spell.Impact.TargetModifier();
        targetCondition.entity_type = "#minecraft:freeze_hurts_extra_types";
        targetModifier2.conditions = List.of(targetCondition);
        targetModifier2.modifier = new Spell.Impact.Modifier();
        targetModifier2.modifier.power_multiplier = 0.3f;
        impact.target_modifiers = List.of(targetModifier, targetModifier2);
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_FROST_IMPACT.id());
        return impact;
    }

    private static Spell.Impact createFireImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = ArtificersSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.FIRE;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame_spark.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f), new ParticleBatch("minecraft:smoke", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        Spell.TargetCondition targetCondition = new Spell.TargetCondition();
        targetCondition.entity_type = "#minecraft:freeze_immune_entity_types";
        Spell.Impact.TargetModifier targetModifier = new Spell.Impact.TargetModifier();
        targetModifier.conditions = List.of(targetCondition);
        targetModifier.modifier = new Spell.Impact.Modifier();
        targetModifier.modifier.critical_chance_bonus = 0.3f;
        impact.target_modifiers = List.of(targetModifier);
        impact.particles = hitParticles;
        impact.sound = sound = new Sound("minecraft:entity.player.hurt_on_fire");
        return impact;
    }

    private static ParticleBatch arcaneCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.ARCANE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.ASCEND).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static ParticleBatch fireCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static ParticleBatch frostCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.FROST, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.ASCEND).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static Spell.Active.Cast createCast(int channelticks, float duration, String sound, String animation, @Nullable SpellSchool school) {
        Spell.Active.Cast cast = new Spell.Active.Cast();
        cast = new Spell.Active.Cast();
        cast.animation = animation;
        cast.sound = new Sound(sound);
        cast.channel_ticks = channelticks;
        cast.duration = duration;
        if (school != null) {
            if (school.equals(SpellSchools.FIRE)) {
                cast.particles = new ParticleBatch[]{ArtificersSpells.fireCastingParticles()};
            }
            if (school.equals(SpellSchools.FROST)) {
                cast.particles = new ParticleBatch[]{ArtificersSpells.frostCastingParticles()};
            }
            if (school.equals(SpellSchools.ARCANE)) {
                cast.particles = new ParticleBatch[]{ArtificersSpells.arcaneCastingParticles()};
            }
        }
        return cast;
    }

    private static void configureCooldown(Spell spell, float duration, boolean proportional, @Nullable String id) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        if (spell.cost.cooldown == null) {
            spell.cost.cooldown = new Spell.Cost.Cooldown();
        }
        if (id != null) {
            spell.cost.item = new Spell.Cost.Item();
            spell.cost.item.id = id;
            spell.cost.item.amount = 1;
        }
        if (proportional) {
            spell.cost.cooldown.proportional = true;
        }
        spell.cost.cooldown.duration = duration;
    }

    public record Entry(class_2960 id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

