/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.artificers;

import com.cleannrooster.artificers.Artificers;
import com.cleannrooster.artificers.config.TweaksConfig;
import com.cleannrooster.artificers.items.BombItem;
import com.cleannrooster.artificers.items.MineItem;
import com.cleannrooster.artificers.items.Mortar;
import com.cleannrooster.artificers.items.RepeaterCrossbow;
import com.cleannrooster.artificers.items.Rifle;
import com.cleannrooster.artificers.items.SalvagingBundle;
import com.cleannrooster.artificers.items.TinkersBundle;
import com.cleannrooster.artificers.items.TrapItem;
import com.github.theredbrain.bundleapi.BundleAPI;
import com.github.theredbrain.bundleapi.component.type.CustomBundleContentsComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabric_extras.ranged_weapon.api.AttributeModifierIDs;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1322;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.Tiers;
import net.spell_engine.api.item.weapon.SpellSwordItem;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellSchools;

public class Items {
    public static class_1792 TRAP;
    public static class_1792 BOMB;
    public static class_1792 MINE;
    public static class_1792 BLUEPRINT;
    public static class_1792 DETONATOR;
    public static class_1792 MORTAR;
    public static class_1792 FULLMETAL;
    public static final RangedEntry iron_rifle;
    public static final RangedEntry gold_rifle;
    public static final RangedEntry diamond_rifle;
    public static final RangedEntry netherite_rifle;
    public static RangedEntry ruby_rifle;
    public static final Weapon.Entry stone_pike;
    public static final Weapon.Entry iron_pike;
    public static final Weapon.Entry golden_pike;
    public static final Weapon.Entry diamond_pike;
    public static final Weapon.Entry netherite_pike;
    public static final ArrayList<Weapon.Entry> entries;
    public static final ArrayList<RangedEntry> rangedEntries;
    public static class_1792 BUNDLE_PLENTY;
    public static class_1792 BUNDLE_PLENTY_ARROWS;
    public static class_1792 BUNDLE_PLENTY_RUNES;
    public static class_1792 SCRAPPING_BUNDLE;
    private static final int durabilityTier0 = 384;
    private static final int durabilityTier1 = 465;
    private static final int durabilityTier2;
    private static final int durabilityTier3;
    private static final float pullTime_shortBow = -0.19999999f;
    private static final float pullTime_longBow = 0.5f;
    private static final float pullTime_rapidCrossbow = 0.0f;
    private static final float pullTime_heavyCrossbow = 0.75f;
    private static final float pullTime_repeatrossbow = 2.0f;
    public static RangedEntry repeating_crossbow;
    public static RangedEntry netherite_repeating_crossbow;
    public static class_1761 ARTIFICERS;
    public static class_5321<class_1761> KEY;
    private static final String BETTER_NETHER = "betternether";

    private static RangedEntry rifle(String name, int durability, Supplier<class_1856> repairIngredientSupplier, RangedConfig defaults, int magazineSize) {
        RangedEntry entry = new RangedEntry(class_2960.method_60655((String)"artificers", (String)name), Rifle::new, defaults, repairIngredientSupplier, durability, magazineSize).weaponType(Equipment.WeaponType.HEAVY_CROSSBOW);
        rangedEntries.add(entry);
        return entry;
    }

    public static class_1792.class_1793 addDefaultAttributes(class_1792.class_1793 settings, RangedConfig config) {
        return settings.method_57348(Items.createAttributeModifiers(settings, config));
    }

    private static class_9285 createAttributeModifiers(class_1792.class_1793 settings, RangedConfig config) {
        class_1322 DAMAGE = new class_1322(AttributeModifierIDs.WEAPON_DAMAGE_ID, (double)config.damage(), class_1322.class_1323.field_6328);
        class_1322 PULL_TIME = new class_1322(AttributeModifierIDs.WEAPON_PULL_TIME_ID, (double)config.pull_time_bonus(), class_1322.class_1323.field_6328);
        class_9285.class_9286 builder = class_9285.method_57480().method_57487(EntityAttributes_RangedWeapon.DAMAGE.entry, DAMAGE, class_9274.field_49219).method_57487(EntityAttributes_RangedWeapon.PULL_TIME.entry, PULL_TIME, class_9274.field_49219);
        return builder.method_57486();
    }

    private static Weapon.Entry rifleEntry(String requiredMod, String name, Weapon.CustomMaterial material, Weapon.Factory item, WeaponConfig defaults, Equipment.WeaponType type) {
        Weapon.Entry entry = new Weapon.Entry("artificers", name, material, item, defaults, type);
        if (entry.isRequiredModInstalled()) {
            entries.add(entry);
        }
        return entry;
    }

    private static Supplier<class_1856> ingredient(String idString) {
        return Items.ingredient(idString, class_1802.field_8477);
    }

    private static Supplier<class_1856> ingredient(String idString, class_1792 fallback) {
        class_2960 id = class_2960.method_60654((String)idString);
        return () -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_1792 ingredient = item != null ? item : fallback;
            return class_1856.method_8091((class_1935[])new class_1935[]{ingredient});
        };
    }

    private static Weapon.Entry entry(String requiredMod, String name, Weapon.CustomMaterial material, Weapon.Factory item, WeaponConfig defaults, Equipment.WeaponType type) {
        Weapon.Entry entry = new Weapon.Entry("artificers", name, material, item, defaults, type);
        if (entry.isRequiredModInstalled()) {
            entries.add(entry);
        }
        return entry;
    }

    private static Weapon.Entry pike(String requiredMod, String name, Weapon.CustomMaterial material, float damage) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        return Items.entry(requiredMod, name, material, SpellSwordItem::new, new WeaponConfig(damage, -3.2f), Equipment.WeaponType.SPEAR);
    }

    private static RangedEntry crossbow(String name, int durability, Supplier<class_1856> repairIngredientSupplier, RangedConfig defaults, int magazineSize) {
        RangedEntry entry = new RangedEntry(class_2960.method_60655((String)"artificers", (String)name), RepeaterCrossbow::new, defaults, repairIngredientSupplier, durability, magazineSize).weaponType(Equipment.WeaponType.RAPID_CROSSBOW);
        rangedEntries.add(entry);
        return entry;
    }

    private static class_1792 registerItem(String name, class_1792 item) {
        return (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)"artificers", (String)name), (Object)item);
    }

    private static void addItemToGroup(class_1792 item) {
        ItemGroupEvents.modifyEntriesEvent(KEY).register(content -> content.method_45421((class_1935)item));
    }

    private static Supplier<class_1856> ingredient(String idString, boolean requirement, class_1792 fallback) {
        class_2960 id = class_2960.method_60654((String)idString);
        if (requirement) {
            return () -> class_1856.method_8091((class_1935[])new class_1935[]{fallback});
        }
        return () -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_1792 ingredient = item != null ? item : fallback;
            return class_1856.method_8091((class_1935[])new class_1935[]{ingredient});
        };
    }

    public static void registerWeapons(Map<String, WeaponConfig> config) {
        Supplier<class_1856> repair;
        if (((TweaksConfig)Artificers.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            repair = Items.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), class_1802.field_22020);
            Items.pike("ruby_pike", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, repair), 10.4f).loot(Equipment.LootProperties.of((int)5));
        }
        if (((TweaksConfig)Artificers.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded("betterend")) {
            repair = Items.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded("betterend"), class_1802.field_22020);
            Items.pike("aeternium_pike", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, repair), 10.4f).loot(Equipment.LootProperties.of((int)5));
        }
        Weapon.register(config, entries, KEY);
    }

    public static void registerRanged(Map<String, RangedConfig> rangedConfig) {
        if (((TweaksConfig)Artificers.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            Supplier<class_1856> rubyRepair = Items.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), class_1802.field_22020);
            Items.crossbow("ruby_repeating_crossbow", durabilityTier3, rubyRepair, new RangedConfig(5.0f, 2.0f, 1.0f), 10).weaponType(Equipment.WeaponType.RAPID_CROSSBOW).loot(Equipment.LootProperties.of((int)4));
            ruby_rifle = Items.rifle("ruby_rifle", durabilityTier3, rubyRepair, new RangedConfig(20.0f, 0.5f, 1.0f), 1).loot(Equipment.LootProperties.of((int)4));
        }
        TRAP = Items.registerItem("trap", new TrapItem(new class_1792.class_1793().method_7889(64).method_57348(new class_9285(List.of(new class_9285.class_9287(SpellSchools.ARCANE.attributeEntry, new class_1322(class_2960.method_60655((String)"artificers", (String)"trap"), 3.0, class_1322.class_1323.field_6328), class_9274.field_49217), new class_9285.class_9287(EntityAttributes_RangedWeapon.DAMAGE.entry, new class_1322(AttributeModifierIDs.WEAPON_DAMAGE_ID, 6.0, class_1322.class_1323.field_6328), class_9274.field_49217)), true))));
        BOMB = Items.registerItem("bomb", new BombItem(new class_1792.class_1793().method_7889(64).method_57348(new class_9285(List.of(new class_9285.class_9287(SpellSchools.FROST.attributeEntry, new class_1322(class_2960.method_60655((String)"artificers", (String)"bomb"), 3.0, class_1322.class_1323.field_6328), class_9274.field_49217), new class_9285.class_9287(EntityAttributes_RangedWeapon.DAMAGE.entry, new class_1322(AttributeModifierIDs.WEAPON_DAMAGE_ID, 6.0, class_1322.class_1323.field_6328), class_9274.field_49217)), true))));
        MINE = Items.registerItem("mine", new MineItem(new class_1792.class_1793().method_7889(64).method_57348(new class_9285(List.of(new class_9285.class_9287(SpellSchools.FIRE.attributeEntry, new class_1322(class_2960.method_60655((String)"artificers", (String)"mine"), 6.0, class_1322.class_1323.field_6328), class_9274.field_49217), new class_9285.class_9287(EntityAttributes_RangedWeapon.DAMAGE.entry, new class_1322(AttributeModifierIDs.WEAPON_DAMAGE_ID, 12.0, class_1322.class_1323.field_6328), class_9274.field_49217)), true))));
        BLUEPRINT = Items.registerItem("blueprint", new class_1792(new class_1792.class_1793().method_7889(1)));
        DETONATOR = Items.registerItem("remote_detonator", new class_1792(new class_1792.class_1793().method_7889(1).method_57348(new class_9285(List.of(new class_9285.class_9287(SpellSchools.FIRE.attributeEntry, new class_1322(class_2960.method_60655((String)"artificers", (String)"mine"), 6.0, class_1322.class_1323.field_6328), class_9274.field_49217), new class_9285.class_9287(EntityAttributes_RangedWeapon.DAMAGE.entry, new class_1322(AttributeModifierIDs.WEAPON_DAMAGE_ID, 12.0, class_1322.class_1323.field_6328), class_9274.field_49217)), true))));
        FULLMETAL = Items.registerItem("flaming_metal_jacket", new class_1792(new class_1792.class_1793().method_7889(64)));
        MORTAR = Items.registerItem("mortar", new Mortar(new class_1792.class_1793().method_7889(64).method_57348(new class_9285(List.of(new class_9285.class_9287(EntityAttributes_RangedWeapon.DAMAGE.entry, new class_1322(AttributeModifierIDs.WEAPON_DAMAGE_ID, 8.0, class_1322.class_1323.field_6328), class_9274.field_49217)), true))));
        int netheriteTier = Tiers.unsafe((String)"netherite");
        ARTIFICERS = FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)Items.repeating_crossbow.item)).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.artificers.general")).method_47324();
        class_2378.method_39197((class_2378)class_7923.field_44687, KEY, (Object)ARTIFICERS);
        for (RangedEntry entry : rangedEntries) {
            RangedConfig config = rangedConfig.get(entry.id.toString());
            if (config == null) {
                config = entry.defaults;
                rangedConfig.put(entry.id.toString(), config);
            }
            class_1792.class_1793 settings = new class_1792.class_1793();
            int tier = entry.lootProperties.tier();
            if (tier >= netheriteTier) {
                settings.method_24359();
            }
            class_1792 item = entry.create(settings);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id, (Object)item);
        }
        ItemGroupEvents.modifyEntriesEvent(KEY).register(content -> {
            for (RangedEntry entry : rangedEntries) {
                content.method_45421((class_1935)entry.item);
            }
        });
        Items.addItemToGroup(TRAP);
        Items.addItemToGroup(BOMB);
        Items.addItemToGroup(MINE);
        Items.addItemToGroup(BLUEPRINT);
        Items.addItemToGroup(DETONATOR);
        Items.addItemToGroup(FULLMETAL);
        Items.addItemToGroup(MORTAR);
        Items.addItemToGroup(BUNDLE_PLENTY);
        Items.addItemToGroup(BUNDLE_PLENTY_ARROWS);
        Items.addItemToGroup(BUNDLE_PLENTY_RUNES);
        Items.addItemToGroup(SCRAPPING_BUNDLE);
    }

    private static Weapon.Entry pike(String name, Weapon.CustomMaterial material, float damage) {
        return Items.pike(null, name, material, damage);
    }

    static {
        ruby_rifle = null;
        entries = new ArrayList();
        rangedEntries = new ArrayList();
        BUNDLE_PLENTY = Items.registerItem("bundle_of_plentiful_explosives", (class_1792)new TinkersBundle((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)class_2960.method_60655((String)"artificers", (String)"explosives")), new class_1792.class_1793().method_7889(1).method_57349(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.builder().size_multiplier(1).build())));
        BUNDLE_PLENTY_ARROWS = Items.registerItem("bundle_of_plentiful_arrows", (class_1792)new TinkersBundle((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)class_2960.method_60655((String)"artificers", (String)"ammo")), new class_1792.class_1793().method_7889(1).method_57349(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.builder().size_multiplier(1).build())));
        BUNDLE_PLENTY_RUNES = Items.registerItem("bundle_of_plentiful_runes", (class_1792)new TinkersBundle((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)class_2960.method_60655((String)"runes", (String)"runes")), new class_1792.class_1793().method_7889(1).method_57349(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.builder().size_multiplier(1).build())));
        SCRAPPING_BUNDLE = Items.registerItem("bundle_of_salvaging", (class_1792)new SalvagingBundle(new class_1792.class_1793().method_7889(1).method_57349(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.builder().size_multiplier(1).build())));
        durabilityTier2 = class_1834.field_8930.method_8025();
        durabilityTier3 = class_1834.field_22033.method_8025();
        repeating_crossbow = Items.crossbow("repeating_crossbow", durabilityTier2, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477}), new RangedConfig(5.0f, 2.0f, 1.0f), 6).weaponType(Equipment.WeaponType.RAPID_CROSSBOW).loot(Equipment.LootProperties.of((int)2));
        netherite_repeating_crossbow = Items.crossbow("netherite_repeating_crossbow", durabilityTier3, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), new RangedConfig(5.0f, 2.0f, 1.0f), 8).weaponType(Equipment.WeaponType.RAPID_CROSSBOW).loot(Equipment.LootProperties.of((int)3));
        KEY = class_5321.method_29179((class_5321)class_7923.field_44687.method_30517(), (class_2960)class_2960.method_60655((String)"artificers", (String)"generic"));
        stone_pike = Items.pike("stone_pike", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8927, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_20412})), 5.5f).loot(Equipment.LootProperties.of((int)0));
        iron_pike = Items.pike("iron_pike", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8923, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620})), 6.7f).loot(Equipment.LootProperties.of((int)1));
        golden_pike = Items.pike("golden_pike", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8929, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695})), 4.2f);
        diamond_pike = Items.pike("diamond_pike", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8930, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477})), 7.4f).loot(Equipment.LootProperties.of((int)2));
        netherite_pike = Items.pike("netherite_pike", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020})), 9.2f).loot(Equipment.LootProperties.of((int)3));
        iron_rifle = Items.rifle("iron_rifle", 465, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620}), new RangedConfig(15.0f, 0.5f, 1.0f), 1).loot(Equipment.LootProperties.of((int)1));
        diamond_rifle = Items.rifle("diamond_rifle", durabilityTier2, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477}), new RangedConfig(16.5f, 0.5f, 1.0f), 1).loot(Equipment.LootProperties.of((int)2));
        netherite_rifle = Items.rifle("netherite_rifle", durabilityTier3, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), new RangedConfig(18.0f, 0.5f, 1.0f), 1).loot(Equipment.LootProperties.of((int)3));
        gold_rifle = Items.rifle("golden_rifle", 384, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695}), new RangedConfig(13.5f, 0.5f, 1.0f), 1);
    }

    public static final class RangedEntry {
        private final class_2960 id;
        private final RangedFactory factory;
        private final RangedConfig defaults;
        private final Supplier<class_1856> repairIngredientSupplier;
        private final int durability;
        public class_1792 item;
        public final int magazineSize;
        public Equipment.LootProperties lootProperties = Equipment.LootProperties.EMPTY;
        public Equipment.WeaponType weaponType;

        public RangedEntry(class_2960 id, RangedFactory factory, RangedConfig defaults, Supplier<class_1856> repairIngredientSupplier, int durability, int magazineSize) {
            this.id = id;
            this.factory = factory;
            this.defaults = defaults;
            this.repairIngredientSupplier = repairIngredientSupplier;
            this.durability = durability;
            this.magazineSize = magazineSize;
        }

        public int magazineSize() {
            return this.magazineSize;
        }

        public class_2960 id() {
            return this.id;
        }

        public RangedFactory factory() {
            return this.factory;
        }

        public RangedConfig defaults() {
            return this.defaults;
        }

        public Supplier<class_1856> repairIngredientSupplier() {
            return this.repairIngredientSupplier;
        }

        public int durability() {
            return this.durability;
        }

        public class_1792 create(class_1792.class_1793 settings) {
            this.item = this.factory.create(settings.method_7895(this.durability), this.defaults, this.repairIngredientSupplier, this.magazineSize);
            return this.item;
        }

        public class_1792 item() {
            return this.item;
        }

        public RangedEntry weaponType(Equipment.WeaponType weaponType) {
            this.weaponType = weaponType;
            return this;
        }

        public RangedEntry loot(Equipment.LootProperties lootProperties) {
            this.lootProperties = lootProperties;
            return this;
        }
    }

    public static interface RangedFactory {
        public class_1792 create(class_1792.class_1793 var1, RangedConfig var2, Supplier<class_1856> var3, int var4);
    }
}

