/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightquest.common.entity.entities.GhastlingEntity;
import dev.xylonity.knightquest.common.entity.entities.ai.NearestAttackableTargetGoal;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestEntities;
import dev.xylonity.knightquest.registry.KnightQuestParticles;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4140;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GremlinEntity
extends class_1588
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Boolean> IS_PASSIVE = class_2945.method_12791(GremlinEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHOULD_TAKE_COIN = class_2945.method_12791(GremlinEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> GOLD_VARIATION = class_2945.method_12791(GremlinEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> PHASE = class_2945.method_12791(GremlinEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> ATTACK = class_2945.method_12791(GremlinEntity.class, (class_2941)class_2943.field_13323);
    private int tickCounterShield = 0;
    private int tickCounter = 0;
    private boolean isHalfHealth;

    public GremlinEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        if (!this.method_37908().method_8608()) {
            boolean attack1 = this.method_59922().method_43056();
            this.field_6011.method_12778(ATTACK, (Object)attack1);
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 pLevel, class_1266 pDifficulty, class_3730 pSpawnType, @Nullable class_1315 pSpawnGroupData) {
        class_1324 maxHealth = this.method_5996(class_5134.field_23716);
        if (maxHealth != null) {
            maxHealth.method_6192(KQConfigValues.GREMLIN_MAX_HEALTH.get().doubleValue());
            this.method_6033(KQConfigValues.GREMLIN_MAX_HEALTH.get().floatValue());
        }
        return super.method_5943(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 pBuilder) {
        super.method_5693(pBuilder);
        pBuilder.method_56912(IS_PASSIVE, (Object)false);
        pBuilder.method_56912(SHOULD_TAKE_COIN, (Object)false);
        pBuilder.method_56912(GOLD_VARIATION, (Object)0);
        pBuilder.method_56912(PHASE, (Object)1);
        pBuilder.method_56912(ATTACK, (Object)false);
    }

    public boolean getIsPassive() {
        return (Boolean)this.field_6011.method_12789(IS_PASSIVE);
    }

    public boolean getShouldTakeCoin() {
        return (Boolean)this.field_6011.method_12789(SHOULD_TAKE_COIN);
    }

    public int getGoldVariation() {
        return (Integer)this.field_6011.method_12789(GOLD_VARIATION);
    }

    public int getPhase() {
        return (Integer)this.field_6011.method_12789(PHASE);
    }

    public boolean getAttack() {
        return (Boolean)this.field_6011.method_12789(ATTACK);
    }

    public void setIsPassive(boolean isPassive) {
        this.field_6011.method_12778(IS_PASSIVE, (Object)isPassive);
    }

    public void setShouldTakeCoin(boolean shouldTakeCoin) {
        this.field_6011.method_12778(SHOULD_TAKE_COIN, (Object)shouldTakeCoin);
    }

    public void setGoldVariation(int goldVariation) {
        this.field_6011.method_12778(GOLD_VARIATION, (Object)goldVariation);
    }

    public void setPhase(int phase) {
        this.field_6011.method_12778(PHASE, (Object)phase);
    }

    public void setAttack(boolean attack) {
        this.field_6011.method_12778(ATTACK, (Object)attack);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 35.0).method_26868(class_5134.field_23721, 5.5).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23719, (double)0.63f).method_26868(class_5134.field_23717, 35.0);
    }

    private void updateAttributes() {
        Objects.requireNonNull(this.method_5996(class_5134.field_23721)).method_6192(this.method_45325(class_5134.field_23721) * (double)KQConfigValues.MULTIPLIER_GREMLIN_ATTACK_DAMAGE.get().floatValue());
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(this.method_45325(class_5134.field_23719) * (double)KQConfigValues.MULTIPLIER_GREMLIN_MOVEMENT_SPEED.get().floatValue());
        Objects.requireNonNull(this.method_5996(class_5134.field_23723)).method_6192(this.method_45325(class_5134.field_23723) * (double)KQConfigValues.MULTIPLIER_GREMLIN_ATTACK_SPEED.get().floatValue());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 0.5, true));
        this.field_6201.method_6277(2, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 0.5, (Predicate)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8861}), false));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.5));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, new NearestAttackableTargetGoal<class_1657>(this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "attackcontroller", 0, this::attackPredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "deadcontroller", 0, this::deadPredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "coincontroller", 0, this::coinPredicate));
    }

    private PlayState coinPredicate(AnimationState<?> event) {
        if (this.getIsPassive() && this.getShouldTakeCoin()) {
            event.getController().forceAnimationReset();
            String goldVariation = this.getGoldVariation() == 0 ? "gold" : "gold2";
            event.getController().setAnimation(RawAnimation.begin().then(goldVariation, Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState deadPredicate(AnimationState<?> event) {
        if (this.method_29504()) {
            event.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.field_6252 && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            this.field_6252 = false;
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void method_5773() {
        super.method_5773();
        if ((double)this.method_6032() < (double)this.method_6063() * 0.5) {
            if (!this.isHalfHealth) {
                this.method_37908().method_8406((class_2394)KnightQuestParticles.GREMLIN_PARTICLE.get(), this.method_23317(), this.method_23318() - 0.48, this.method_23321(), 2.0, 0.0, 0.0);
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15193, class_3419.field_15251, 1.0f, 1.0f);
                this.isHalfHealth = true;
                if (this.getAttack()) {
                    this.spawnShield();
                } else {
                    this.updateAttributes();
                }
                this.setPhase(2);
            }
            if (this.getAttack()) {
                ++this.tickCounterShield;
                if (this.tickCounterShield % 22 == 0 && this.tickCounterShield / 25 <= 1) {
                    this.spawnShield();
                }
            }
        }
        if (this.getIsPassive()) {
            ++this.tickCounter;
            if (this.tickCounter == 1) {
                this.setShouldTakeCoin(true);
            } else if (this.tickCounter == 3) {
                this.setShouldTakeCoin(false);
            } else if (this.tickCounter == 80) {
                this.setIsPassive(false);
                this.setShouldTakeCoin(false);
                this.tickCounter = 0;
            }
        }
    }

    private void spawnShield() {
        GhastlingEntity entity = (GhastlingEntity)KnightQuestEntities.SHIELD.get().method_5883(this.method_37908());
        if (entity != null) {
            entity.method_5725(this.method_23312(), 1.0f, 0.0f);
            this.method_37908().method_8649((class_1297)entity);
        }
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 pPlayer, @NotNull class_1268 pHand) {
        if (KQConfigValues.CAN_TAKE_GOLD_GREMLIN.get().booleanValue()) {
            class_1799 itemstack = pPlayer.method_5998(pHand);
            class_1792 desiredItem = class_1802.field_8695;
            class_1792 item = itemstack.method_7909();
            if (item.equals(desiredItem)) {
                pPlayer.method_6030().method_7934(1);
                this.method_5980(null);
                this.method_18868().method_18875(class_4140.field_22355);
                this.method_18868().method_18875(class_4140.field_18444);
                this.method_6015(null);
                this.method_29505(null);
                this.setGoldVariation(this.method_59922().method_43051(0, 2));
                this.setIsPassive(true);
            }
        }
        return super.method_5992(pPlayer, pHand);
    }

    public boolean method_5643(@NotNull class_1282 pSource, float pAmount) {
        if (this.tickCounter != 0) {
            return false;
        }
        return super.method_5643(pSource, pAmount);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    protected class_3414 method_5737() {
        return class_3417.field_28293;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14964;
    }

    protected class_3414 method_6011(@NotNull class_1282 pDamageSource) {
        return class_3417.field_15072;
    }

    protected void method_5712(@NotNull class_2338 pPos, @NotNull class_2680 pState) {
        this.method_5783(class_3417.field_14772, 0.15f, 1.0f);
    }
}

