/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.ai.navigator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.xylonity.knightquest.common.ai.navigator.BonusPathFinder;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1409;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import net.minecraft.class_9316;
import org.jetbrains.annotations.NotNull;

public class GroundNavigator
extends class_1409 {
    private static final float THETA = 1.0E-8f;
    private final Cache<class_2338, Boolean> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(5L, TimeUnit.SECONDS).build();

    public GroundNavigator(class_1308 entity, class_1937 world) {
        super(entity, world);
    }

    @NotNull
    protected class_13 method_6336(int maxVisitedNodes) {
        this.field_6678 = new class_14();
        this.field_6678.method_15(true);
        return new BonusPathFinder(this.field_6678, maxVisitedNodes);
    }

    protected void method_6339() {
        int lastNodeIndex;
        if (this.field_6681 == null || this.field_6681.method_46()) {
            return;
        }
        class_243 entityPos = this.method_6347();
        int nextNodeIndex = this.field_6681.method_39();
        double entityYFloor = Math.floor(entityPos.field_1351);
        int pathLength = this.field_6681.method_38();
        for (lastNodeIndex = nextNodeIndex; lastNodeIndex < pathLength && (double)this.field_6681.method_40((int)lastNodeIndex).field_39 == entityYFloor; ++lastNodeIndex) {
        }
        class_243 base = entityPos.method_1023((double)(this.field_6684.method_17681() * 0.5f), 0.0, (double)(this.field_6684.method_17681() * 0.5f));
        if (this.attemptShortcut(this.field_6681, entityPos, lastNodeIndex, base) && (this.hasReached(this.field_6681, 0.6f) || this.isAtElevationChange(this.field_6681) && this.hasReached(this.field_6681, this.field_6684.method_17681() * 0.5f))) {
            this.field_6681.method_44();
        }
        this.method_6346(entityPos);
    }

    private boolean hasReached(class_11 path, float threshold) {
        class_243 pathPos = path.method_49((class_1297)this.field_6684);
        return Math.abs(this.field_6684.method_23317() - pathPos.field_1352) < (double)threshold && Math.abs(this.field_6684.method_23321() - pathPos.field_1350) < (double)threshold && Math.abs(this.field_6684.method_23318() - pathPos.field_1351) < 1.0;
    }

    private boolean isAtElevationChange(class_11 path) {
        int currIndex = path.method_39();
        int endIndex = Math.min(path.method_38(), currIndex + class_3532.method_15386((float)(this.field_6684.method_17681() * 0.5f)) + 1);
        int currY = path.method_40((int)currIndex).field_39;
        for (int i = currIndex + 1; i < endIndex; ++i) {
            if (path.method_40((int)i).field_39 == currY) continue;
            return true;
        }
        return false;
    }

    private boolean attemptShortcut(class_11 path, class_243 entityPos, int pathLength, class_243 base) {
        int nextNodeIndex = path.method_39();
        for (int i = pathLength - 1; i > nextNodeIndex; --i) {
            class_243 vec = path.method_47((class_1297)this.field_6684, i).method_1020(entityPos);
            if (!this.catchF(vec, base)) continue;
            path.method_42(i);
            return false;
        }
        return true;
    }

    private boolean catchF(class_243 vec, class_243 base) {
        int stepZ;
        float tNextZ;
        float tDeltaZ;
        int stepY;
        float tNextY;
        float tDeltaY;
        int stepX;
        float tNextX;
        float tDeltaX;
        float maxT = (float)vec.method_1033();
        if (maxT < 1.0E-8f) {
            return true;
        }
        float dx = (float)vec.field_1352 / maxT;
        float dy = (float)vec.field_1351 / maxT;
        float dz = (float)vec.field_1350 / maxT;
        if (Math.abs(dx) < 1.0E-8f) {
            tDeltaX = Float.POSITIVE_INFINITY;
            tNextX = Float.POSITIVE_INFINITY;
            stepX = 0;
        } else {
            stepX = dx > 0.0f ? 1 : -1;
            float voxelBoundaryX = stepX > 0 ? (float)(class_3532.method_15357((double)base.field_1352) + 1) : (float)class_3532.method_15357((double)base.field_1352);
            tDeltaX = 1.0f / Math.abs(dx);
            tNextX = (float)(((double)voxelBoundaryX - base.field_1352) / (double)dx);
        }
        int currentX = class_3532.method_15357((double)base.field_1352);
        if (Math.abs(dy) < 1.0E-8f) {
            tDeltaY = Float.POSITIVE_INFINITY;
            tNextY = Float.POSITIVE_INFINITY;
            stepY = 0;
        } else {
            stepY = dy > 0.0f ? 1 : -1;
            float voxelBoundaryY = stepY > 0 ? (float)(class_3532.method_15357((double)base.field_1351) + 1) : (float)class_3532.method_15357((double)base.field_1351);
            tDeltaY = 1.0f / Math.abs(dy);
            tNextY = (float)(((double)voxelBoundaryY - base.field_1351) / (double)dy);
        }
        int currentY = class_3532.method_15357((double)base.field_1351);
        if (Math.abs(dz) < 1.0E-8f) {
            tDeltaZ = Float.POSITIVE_INFINITY;
            tNextZ = Float.POSITIVE_INFINITY;
            stepZ = 0;
        } else {
            stepZ = dz > 0.0f ? 1 : -1;
            float voxelBoundaryZ = stepZ > 0 ? (float)(class_3532.method_15357((double)base.field_1350) + 1) : (float)class_3532.method_15357((double)base.field_1350);
            tDeltaZ = 1.0f / Math.abs(dz);
            tNextZ = (float)(((double)voxelBoundaryZ - base.field_1350) / (double)dz);
        }
        int currentZ = class_3532.method_15357((double)base.field_1350);
        class_2338.class_2339 pos = new class_2338.class_2339();
        float t = 0.0f;
        while (t <= maxT) {
            if (tNextX < tNextY) {
                if (tNextX < tNextZ) {
                    currentX += stepX;
                    t = tNextX;
                    tNextX += tDeltaX;
                } else {
                    currentZ += stepZ;
                    t = tNextZ;
                    tNextZ += tDeltaZ;
                }
            } else if (tNextY < tNextZ) {
                currentY += stepY;
                t = tNextY;
                tNextY += tDeltaY;
            } else {
                currentZ += stepZ;
                t = tNextZ;
                tNextZ += tDeltaZ;
            }
            pos.method_10103(currentX, currentY, currentZ);
            class_2338 immutablePos = pos.method_10062();
            Boolean isPathfindable = (Boolean)this.cache.getIfPresent((Object)immutablePos);
            if (isPathfindable == null) {
                class_2680 blockState = this.field_6677.method_8320((class_2338)pos);
                isPathfindable = blockState.method_26216((class_1922)this.field_6677, (class_2338)pos) || blockState.method_26215();
                this.cache.put((Object)immutablePos, (Object)isPathfindable);
            }
            if (!isPathfindable.booleanValue()) {
                return false;
            }
            class_7 pathNodeType = this.field_6678.method_17(new class_9316((class_1941)this.field_6677, this.field_6684), currentX, currentY, currentZ);
            float malus = this.field_6684.method_5944(pathNodeType);
            if (!(malus < 0.0f) && !(malus >= 8.0f) && pathNodeType != class_7.field_3 && pathNodeType != class_7.field_9 && pathNodeType != class_7.field_17) continue;
            return false;
        }
        return true;
    }
}

