/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.JsonObject;
import dev.architectury.platform.Platform;
import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.config.ConfigExtensions;
import io.github.jamalam360.jamlib.config.MatchesRegex;
import io.github.jamalam360.jamlib.config.RequiresRestart;
import io.github.jamalam360.jamlib.config.WithinRange;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;

public class ConfigManager<T> {
    @ApiStatus.Internal
    public static final Map<Key, ConfigManager<?>> MANAGERS = new HashMap();
    private static final Jankson JANKSON = Jankson.builder().build();
    private static final JsonGrammar JSON_GRAMMER = JsonGrammar.builder().bareRootObject(false).bareSpecialNumerics(false).printCommas(true).printWhitespace(true).printUnquotedKeys(true).withComments(true).build();
    private final Path configPath;
    private final String modId;
    private final String configName;
    private final Class<T> configClass;
    private T config;

    public ConfigManager(String modId, Class<T> configClass) {
        this(modId, modId, configClass);
    }

    public ConfigManager(String modId, String configName, Class<T> configClass) {
        MANAGERS.put(new Key(modId, configName), this);
        this.configPath = modId.equals(configName) ? Platform.getConfigFolder().resolve(configName + ".json5") : Platform.getConfigFolder().resolve(modId).resolve(configName + ".json5");
        this.configName = configName;
        this.modId = modId;
        this.configClass = configClass;
        this.validateConfigClass();
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            this.config = this.createDefaultConfig();
            this.save();
        }
        this.reloadFromDisk();
        this.save();
    }

    public T get() {
        return this.config;
    }

    public String getConfigName() {
        return this.configName;
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }

    public String getModId() {
        return this.modId;
    }

    public void save() {
        JsonElement json = JANKSON.toJson(this.config);
        this.transformJsonBeforeSave(json);
        String stringifiedJson = json.toJson(JSON_GRAMMER);
        try {
            if (!Files.exists(this.configPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            }
            Files.writeString(this.configPath, (CharSequence)stringifiedJson, new OpenOption[0]);
            JamLib.LOGGER.info("Updated config file at {}", (Object)this.configPath);
        }
        catch (IOException e) {
            JamLib.LOGGER.error("Failed to write config file at {}", (Object)this.configPath, (Object)e);
        }
        T t = this.config;
        if (t instanceof ConfigExtensions) {
            ConfigExtensions ext = (ConfigExtensions)t;
            ext.afterSave();
        }
    }

    public void reloadFromDisk() {
        try {
            JsonObject json = JANKSON.load(Files.readAllLines(this.configPath).stream().reduce((a, b) -> a + "\n" + b).orElse(""));
            this.config = JANKSON.fromJsonCarefully(json, this.configClass);
        }
        catch (Exception e) {
            JamLib.LOGGER.error("Failed to read config file at {}", (Object)this.configPath, (Object)e);
            JamLib.LOGGER.error("Resetting to defaults; a backup will be written to {}.broken", (Object)this.configPath);
            try {
                Files.move(this.configPath, this.configPath.resolveSibling(String.valueOf(this.configPath.getFileName()) + ".broken"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e2) {
                JamLib.LOGGER.error("Failed to write backup config file at {}.broken", (Object)this.configPath, (Object)e2);
            }
            this.config = this.createDefaultConfig();
        }
    }

    private void validateConfigClass() {
        T defaultConfig = this.createDefaultConfig();
        try {
            for (Field field : this.configClass.getFields()) {
                if (field.get(defaultConfig) != null) continue;
                throw new RuntimeException("Config field " + field.getName() + " is null by default. Config fields cannot be null by default.");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            JamLib.LOGGER.error("Failed to validate config class {}", (Object)this.configClass.getName(), (Object)e);
        }
    }

    private T createDefaultConfig() {
        try {
            return this.configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            JamLib.LOGGER.error("Failed to create default config for {}", (Object)this.configClass.getName(), (Object)e);
            return null;
        }
    }

    private void transformJsonBeforeSave(JsonElement e) {
        if (!(e instanceof JsonObject)) {
            throw new IllegalArgumentException("Config must be a JSON object");
        }
        JsonObject root = (JsonObject)e;
        T defaultConfig = this.createDefaultConfig();
        if (defaultConfig != null) {
            this.attachDefaultComments(this.configClass, defaultConfig, root);
        }
    }

    private void attachDefaultComments(Class<?> clazz, T defaults, JsonObject obj) {
        for (String key : obj.keySet()) {
            JsonElement e = obj.get((Object)key);
            if (e instanceof JsonObject) {
                this.attachDefaultComments(clazz, defaults, (JsonObject)e);
                continue;
            }
            try {
                Annotation annotation;
                Field field = clazz.getField(key);
                String currentComment = obj.getComment(key);
                StringBuilder comment = new StringBuilder();
                Object defaultValue = field.get(defaults);
                if (defaultValue != null) {
                    if (defaultValue instanceof String) {
                        String s = (String)defaultValue;
                        defaultValue = "\\\"" + s + "\\\"";
                    }
                    comment.append("- default: ").append(defaultValue);
                }
                if (field.isAnnotationPresent(RequiresRestart.class)) {
                    if (!comment.isEmpty()) {
                        comment.append("\n");
                    }
                    comment.append("- requires game restart");
                }
                if (field.isAnnotationPresent(MatchesRegex.class)) {
                    annotation = field.getAnnotation(MatchesRegex.class);
                    if (!comment.isEmpty()) {
                        comment.append("\n");
                    }
                    comment.append("- must match regex: ").append(annotation.value());
                }
                if (field.isAnnotationPresent(WithinRange.class)) {
                    annotation = field.getAnnotation(WithinRange.class);
                    if (!comment.isEmpty()) {
                        comment.append("\n");
                    }
                    comment.append("- must be between ").append(annotation.min()).append(" and ").append(annotation.max());
                }
                if (Enum.class.isAssignableFrom(field.getType())) {
                    if (!comment.isEmpty()) {
                        comment.append("\n");
                    }
                    comment.append("- must be one of: ").append(Arrays.stream(field.getType().getEnumConstants()).map(Object::toString).reduce((a, b) -> a + ", " + b).orElse(""));
                }
                String newComment = (currentComment == null ? "" : currentComment) + (currentComment == null ? "" : "\n") + String.valueOf(comment);
                obj.setComment(key, newComment);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {}
        }
    }

    public record Key(String modId, String configName) {
    }
}

