/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.entity.AzEntityModelRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class AzEntityRendererConfig<T extends class_1297>
extends AzRendererConfig<T> {
    private final Function<T, Float> deathMaxRotationProvider;
    private final Function<T, Float> shadowRadius;

    private AzEntityRendererConfig(Supplier<AzAnimator<T>> animatorProvider, Function<T, Float> deathMaxRotationProvider, Function<T, Float> shadowRadius, Function<T, class_1921> renderTypeFunction, Function<T, class_2960> modelLocationProvider, List<AzRenderLayer<T>> renderLayers, Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry, Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> renderEntry, Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> postRenderEntry, Function<T, class_2960> textureLocationProvider, Function<T, Float> alphaFunction, Function<T, Float> scaleHeight, Function<T, Float> scaleWidth, BiFunction<AzRendererPipeline<T>, AzLayerRenderer<T>, AzModelRenderer<T>> modelRendererProvider, Function<AzRendererPipeline<T>, AzRendererPipelineContext<T>> pipelineContextFunction, Function<AzBone, class_2960> boneTextureOverrideProvider, Function<AzBone, class_1921> boneRenderTypeOverrideProvider) {
        super(animatorProvider, modelLocationProvider, modelRendererProvider, pipelineContextFunction, renderTypeFunction, renderLayers, preRenderEntry, renderEntry, postRenderEntry, textureLocationProvider, alphaFunction, scaleHeight, scaleWidth, boneTextureOverrideProvider, boneRenderTypeOverrideProvider);
        this.deathMaxRotationProvider = deathMaxRotationProvider;
        this.shadowRadius = shadowRadius;
    }

    public float getDeathMaxRotation(T entity) {
        return this.deathMaxRotationProvider.apply(entity).floatValue();
    }

    public float shadowRadius(T entity) {
        return this.shadowRadius.apply(entity).floatValue();
    }

    public static <T extends class_1297> Builder<T> builder(class_2960 modelLocation, class_2960 textureLocation) {
        return new Builder<class_1297>($ -> modelLocation, $ -> textureLocation);
    }

    public static <T extends class_1297> Builder<T> builder(Function<T, class_2960> modelLocationProvider, Function<T, class_2960> textureLocationProvider) {
        return new Builder<T>(modelLocationProvider, textureLocationProvider);
    }

    public static class Builder<T extends class_1297>
    extends AzRendererConfig.Builder<T> {
        private Function<T, Float> deathMaxRotationProvider;
        protected Function<T, Float> shadowRadius;

        public Builder(Function<T, class_2960> modelLocationProvider, Function<T, class_2960> textureLocationProvider) {
            super(modelLocationProvider, textureLocationProvider);
            this.modelRendererProvider = (entityRendererPipeline, layer) -> new AzEntityModelRenderer((AzEntityRendererPipeline)entityRendererPipeline, layer);
            this.pipelineContextFunction = AzEntityRendererPipelineContext::new;
            this.renderTypeProvider = $ -> class_1921.method_23576((class_2960)((class_2960)textureLocationProvider.apply($)));
            this.deathMaxRotationProvider = $ -> Float.valueOf(90.0f);
            this.shadowRadius = $ -> Float.valueOf(0.0f);
        }

        @Override
        public Builder<T> setBoneRenderTypeOverrideProvider(Function<AzBone, class_1921> boneRenderTypeOverrideProvider) {
            return (Builder)super.setBoneRenderTypeOverrideProvider(boneRenderTypeOverrideProvider);
        }

        @Override
        public Builder<T> setBoneTextureOverrideProvider(Function<AzBone, class_2960> boneTextureOverrideProvider) {
            return (Builder)super.setBoneTextureOverrideProvider(boneTextureOverrideProvider);
        }

        @Override
        public Builder<T> setModelRenderer(BiFunction<AzRendererPipeline<T>, AzLayerRenderer<T>, AzModelRenderer<T>> modelRendererProvider) {
            return (Builder)super.setModelRenderer(modelRendererProvider);
        }

        @Override
        public Builder<T> setPipelineContext(Function<AzRendererPipeline<T>, AzRendererPipelineContext<T>> azRendererPipelineAzRendererPipelineContextFunction) {
            return (Builder)super.setPipelineContext(azRendererPipelineAzRendererPipelineContextFunction);
        }

        @Override
        public Builder<T> addRenderLayer(AzRenderLayer<T> renderLayer) {
            return (Builder)super.addRenderLayer(renderLayer);
        }

        public Builder<T> setRenderType(class_1921 renderType) {
            this.renderTypeProvider = $ -> renderType;
            return this;
        }

        public Builder<T> setRenderType(Function<T, class_1921> renderTypeProvider) {
            this.renderTypeProvider = renderTypeProvider;
            return this;
        }

        @Override
        public Builder<T> setPrerenderEntry(Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry) {
            return (Builder)super.setPrerenderEntry(preRenderEntry);
        }

        @Override
        public Builder<T> setRenderEntry(Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> renderEntry) {
            return (Builder)super.setRenderEntry(renderEntry);
        }

        @Override
        public Builder<T> setPostRenderEntry(Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry) {
            return (Builder)super.setPostRenderEntry(preRenderEntry);
        }

        @Override
        public Builder<T> setAnimatorProvider(Supplier<@Nullable AzAnimator<T>> animatorProvider) {
            return (Builder)super.setAnimatorProvider(animatorProvider);
        }

        public Builder<T> setDeathMaxRotation(float angle) {
            this.deathMaxRotationProvider = $ -> Float.valueOf(angle);
            return this;
        }

        @Override
        public Builder<T> setAlpha(Function<T, Float> alphaFunction) {
            return (Builder)super.setAlpha(alphaFunction);
        }

        @Override
        public Builder<T> setAlpha(float alpha) {
            return (Builder)super.setAlpha(alpha);
        }

        @Override
        public Builder<T> setScale(Function<T, Float> scaleFunction) {
            return (Builder)super.setScale(scaleFunction);
        }

        @Override
        public Builder<T> setScale(Function<T, Float> scaleHeightFunction, Function<T, Float> scaleWidthFunction) {
            return (Builder)super.setScale(scaleHeightFunction, scaleWidthFunction);
        }

        @Override
        public Builder<T> setScale(float scale) {
            return (Builder)super.setScale(scale);
        }

        @Override
        public Builder<T> setScale(float scaleWidth, float scaleHeight) {
            return (Builder)super.setScale(scaleWidth, scaleHeight);
        }

        public Builder<T> setDeathMaxRotation(Function<T, Float> deathMaxRotationProvider) {
            this.deathMaxRotationProvider = deathMaxRotationProvider;
            return this;
        }

        public Builder<T> setShadowRadius(Function<T, Float> shadowRadiusFunction) {
            this.shadowRadius = shadowRadiusFunction;
            return this;
        }

        public Builder<T> setShadowRadius(float shadowRadius) {
            this.shadowRadius = $ -> Float.valueOf(shadowRadius);
            return this;
        }

        @Override
        public AzEntityRendererConfig<T> build() {
            AzRendererConfig baseConfig = super.build();
            return new AzEntityRendererConfig<class_1297>(baseConfig::createAnimator, this.deathMaxRotationProvider, this.shadowRadius, this.renderTypeProvider, baseConfig::modelLocation, baseConfig.renderLayers(), baseConfig::preRenderEntry, baseConfig::renderEntry, baseConfig::postRenderEntry, baseConfig::textureLocation, baseConfig::alpha, baseConfig::scaleHeight, baseConfig::scaleWidth, baseConfig::modelRendererProvider, baseConfig::pipelineContext, baseConfig::boneTextureOverrideProvider, baseConfig::boneRenderTypeOverrideProvider);
        }
    }
}

