/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.cache.AzIdentityRegistry;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class AzArmorRendererRegistry {
    private static final Map<ArmorKey, AzArmorRenderer> ITEM_TO_RENDERER = new HashMap<ArmorKey, AzArmorRenderer>();
    private static final Map<ArmorKey, Supplier<AzArmorRenderer>> ITEM_TO_RENDERER_SUPPLIER = new HashMap<ArmorKey, Supplier<AzArmorRenderer>>();

    public static void register(class_1792 item, Supplier<AzArmorRenderer> armorRendererSupplier) {
        AzArmorRendererRegistry.register(item, -1, armorRendererSupplier);
    }

    public static void register(class_1792 item, int customModelData, Supplier<AzArmorRenderer> armorRendererSupplier) {
        ITEM_TO_RENDERER_SUPPLIER.put(new ArmorKey(item, customModelData), armorRendererSupplier);
        AzIdentityRegistry.register(item, new class_1792[0]);
    }

    public static void register(Supplier<AzArmorRenderer> armorRendererSupplier, class_1792 item, class_1792 ... items) {
        AzArmorRendererRegistry.register(item, armorRendererSupplier);
        for (class_1792 otherItem : items) {
            AzArmorRendererRegistry.register(otherItem, armorRendererSupplier);
        }
    }

    public static void register(int customModelData, Supplier<AzArmorRenderer> armorRendererSupplier, class_1792 item, class_1792 ... items) {
        AzArmorRendererRegistry.register(item, customModelData, armorRendererSupplier);
        for (class_1792 otherItem : items) {
            AzArmorRendererRegistry.register(otherItem, customModelData, armorRendererSupplier);
        }
    }

    @Nullable
    public static AzArmorRenderer getOrNull(class_1792 item, int customModelData) {
        ArmorKey specificKey = new ArmorKey(item, customModelData);
        return ITEM_TO_RENDERER.computeIfAbsent(specificKey, key -> {
            Supplier<AzArmorRenderer> rendererSupplier = ITEM_TO_RENDERER_SUPPLIER.get(specificKey);
            if (rendererSupplier != null) {
                return rendererSupplier.get();
            }
            ArmorKey genericKey = new ArmorKey(item, -1);
            rendererSupplier = ITEM_TO_RENDERER_SUPPLIER.get(genericKey);
            return rendererSupplier != null ? rendererSupplier.get() : null;
        });
    }

    @Nullable
    public static AzArmorRenderer getOrNull(class_1799 stack) {
        int customModelData = AzArmorRendererRegistry.getCustomModelDataId(stack);
        return AzArmorRendererRegistry.getOrNull(stack.method_7909(), customModelData);
    }

    public static int getCustomModelDataId(class_1799 itemStack) {
        int customModelDataId = 0;
        if (itemStack.method_57353().method_57829(class_9334.field_49637) != null) {
            customModelDataId = ((class_9280)itemStack.method_57353().method_57829(class_9334.field_49637)).comp_2382();
        }
        return customModelDataId;
    }

    private record ArmorKey(class_1792 item, int customModelData) {
    }
}

