/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.client.renderer;

import java.util.List;
import mod.azure.azurelib.common.api.client.model.GeoModel;
import mod.azure.azurelib.common.api.client.renderer.layer.GeoRenderLayer;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.cache.object.BakedGeoModel;
import mod.azure.azurelib.common.internal.common.cache.object.GeoBone;
import mod.azure.azurelib.common.internal.common.cache.object.GeoCube;
import mod.azure.azurelib.common.internal.common.cache.object.GeoQuad;
import mod.azure.azurelib.common.internal.common.cache.object.GeoVertex;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.object.Color;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public interface GeoRenderer<T extends GeoAnimatable> {
    public GeoModel<T> getGeoModel();

    public T getAnimatable();

    default public class_2960 getTextureLocation(T animatable) {
        return this.getGeoModel().getTextureResource(animatable);
    }

    default public List<GeoRenderLayer<T>> getRenderLayers() {
        return List.of();
    }

    default public class_1921 getRenderType(T animatable, class_2960 texture, @Nullable class_4597 bufferSource, float partialTick) {
        return this.getGeoModel().getRenderType(animatable, texture);
    }

    default public Color getRenderColor(T animatable, float partialTick, int packedLight) {
        return Color.WHITE;
    }

    default public int getPackedOverlay(T animatable, float u, float partialTick) {
        return class_4608.field_21444;
    }

    default public long getInstanceId(T animatable) {
        return animatable.hashCode();
    }

    default public float getMotionAnimThreshold(T animatable) {
        return 0.015f;
    }

    default public void defaultRender(class_4587 poseStack, T animatable, class_4597 bufferSource, @Nullable class_1921 renderType, @Nullable class_4588 buffer, float yaw, float partialTick, int packedLight) {
        poseStack.method_22903();
        int renderColor = this.getRenderColor(animatable, partialTick, packedLight).argbInt();
        int packedOverlay = this.getPackedOverlay(animatable, 0.0f, partialTick);
        BakedGeoModel model = this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource(animatable));
        if (renderType == null) {
            renderType = this.getRenderType(animatable, this.getTextureLocation(animatable), bufferSource, partialTick);
        }
        if (buffer == null) {
            buffer = bufferSource.getBuffer(renderType);
        }
        this.preRender(poseStack, animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, renderColor);
        if (this.firePreRenderEvent(poseStack, model, bufferSource, partialTick, packedLight)) {
            this.preApplyRenderLayers(poseStack, animatable, model, renderType, bufferSource, buffer, packedLight, packedLight, packedOverlay);
            this.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, renderColor);
            this.applyRenderLayers(poseStack, animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            this.postRender(poseStack, animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, renderColor);
            this.firePostRenderEvent(poseStack, model, bufferSource, partialTick, packedLight);
        }
        poseStack.method_22909();
        this.renderFinal(poseStack, animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor);
        this.doPostRenderCleanup();
    }

    default public void reRender(BakedGeoModel model, class_4587 poseStack, class_4597 bufferSource, T animatable, class_1921 renderType, class_4588 buffer, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.method_22903();
        this.preRender(poseStack, animatable, model, bufferSource, buffer, true, partialTick, packedLight, packedOverlay, colour);
        this.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, true, partialTick, packedLight, packedOverlay, colour);
        this.postRender(poseStack, animatable, model, bufferSource, buffer, true, partialTick, packedLight, packedOverlay, colour);
        poseStack.method_22909();
    }

    default public void actuallyRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        this.updateAnimatedTextureFrame(animatable);
        for (GeoBone group : model.getTopLevelBones()) {
            this.renderRecursively(poseStack, animatable, group, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        }
    }

    default public void preApplyRenderLayers(class_4587 poseStack, T animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        for (GeoRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.preRender(poseStack, animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
    }

    default public void applyRenderLayersForBone(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        for (GeoRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.renderForBone(poseStack, animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
    }

    default public void applyRenderLayers(class_4587 poseStack, T animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        for (GeoRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.render(poseStack, animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
    }

    default public void preRender(class_4587 poseStack, T animatable, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
    }

    default public void postRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
    }

    default public void renderFinal(class_4587 poseStack, T animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay, int colour) {
    }

    default public void doPostRenderCleanup() {
    }

    default public void renderRecursively(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.method_22903();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, colour);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, this.getAnimatable(), bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        poseStack.method_22909();
    }

    default public void renderCubesOfBone(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, int colour) {
        if (bone.isHidden()) {
            return;
        }
        for (GeoCube cube : bone.getCubes()) {
            poseStack.method_22903();
            this.renderCube(poseStack, cube, buffer, packedLight, packedOverlay, colour);
            poseStack.method_22909();
        }
    }

    default public void renderChildBones(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (GeoBone childBone : bone.getChildBones()) {
            this.renderRecursively(poseStack, animatable, childBone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        }
    }

    default public void renderCube(class_4587 poseStack, GeoCube cube, class_4588 buffer, int packedLight, int packedOverlay, int colour) {
        RenderUtils.translateToPivotPoint(poseStack, cube);
        RenderUtils.rotateMatrixAroundCube(poseStack, cube);
        RenderUtils.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.method_23760().method_23762();
        Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtils.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(quad, poseState, normal, buffer, packedLight, packedOverlay, colour);
        }
    }

    default public void createVerticesOfQuad(GeoQuad quad, Matrix4f poseState, Vector3f normal, class_4588 buffer, int packedLight, int packedOverlay, int colour) {
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            buffer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), colour, vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    public void fireCompileRenderLayersEvent();

    public boolean firePreRenderEvent(class_4587 var1, BakedGeoModel var2, class_4597 var3, float var4, int var5);

    public void firePostRenderEvent(class_4587 var1, BakedGeoModel var2, class_4597 var3, float var4, int var5);

    default public void scaleModelForRender(float widthScale, float heightScale, class_4587 poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        if (!(isReRender || widthScale == 1.0f && heightScale == 1.0f)) {
            poseStack.method_22905(widthScale, heightScale, widthScale);
        }
    }

    public void updateAnimatedTextureFrame(T var1);
}

