/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawnbalanceutility.util;

import com.mactso.spawnbalanceutility.config.MyConfigs;
import com.mactso.spawnbalanceutility.manager.StructureCreatureManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_6007;
import net.minecraft.class_6008;
import net.minecraft.class_6012;
import net.minecraft.class_7061;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnStructData {
    private static Field fieldStructConfig = null;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final class_6012<class_5483.class_1964> SBU_FIX_EMPTY_MOB_LIST = class_6012.method_34989((class_6008[])new class_5483.class_1964[0]);
    static int structureLineNumber = 0;
    static Set<String> structuresProcessed = new HashSet<String>();
    static int reportlinenumber = 0;
    static int structureEventNumber = 0;

    public static void initReports() {
        File fs;
        File fd = new File("config/spawnbalanceutility");
        if (!fd.exists()) {
            fd.mkdir();
        }
        if ((fs = new File("config/spawnbalanceutility/StructMobWeight.rpt")).exists()) {
            fs.delete();
        }
    }

    public static void doStructureActions(MinecraftServer server) {
        class_5455.class_6890 dynreg = server.method_30611();
        class_2378 csfreg = dynreg.method_30530(class_7924.field_41246);
        SpawnStructData.initReports();
        if (MyConfigs.isBalanceStructureSpawnValues()) {
            SpawnStructData.balanceStructureSpawnValues((class_2378<class_3195>)csfreg);
        }
        if (MyConfigs.isFixSpawnValues()) {
            SpawnStructData.fixStructureSpawnValues((class_2378<class_3195>)csfreg);
        }
        if (MyConfigs.isGenerateReport()) {
            SpawnStructData.generateStructureSpawnValuesReport((class_2378<class_3195>)csfreg);
        }
    }

    private static void balanceStructureSpawnValues(class_2378<class_3195> csfreg) {
        ArrayList<class_5483.class_1964> newSpawnEntriesList = new ArrayList<class_5483.class_1964>();
        for (Map.Entry csf : csfreg.method_29722()) {
            class_5321 csfKey = (class_5321)csf.getKey();
            String csfIdentifier = csfKey.method_29177().toString();
            List<StructureCreatureManager.StructureCreatureItem> creaturesInStructure = StructureCreatureManager.structureCreaturesMap.get(csfIdentifier);
            HashMap<class_1311, class_7061> newMap = new HashMap<class_1311, class_7061>();
            if (creaturesInStructure == null) continue;
            for (class_1311 mc : class_1311.values()) {
                String vCl = mc.method_6133();
                newSpawnEntriesList.clear();
                for (int i = 0; i < creaturesInStructure.size(); ++i) {
                    Optional opt;
                    StructureCreatureManager.StructureCreatureItem sci = creaturesInStructure.get(i);
                    if (!sci.getClassification().toLowerCase().equals(vCl) || !(opt = class_7923.field_41177.method_17966(class_2960.method_60654((String)sci.getModAndMob()))).isPresent()) continue;
                    class_5483.class_1964 newS = new class_5483.class_1964((class_1299)opt.get(), class_6007.method_34977((int)sci.getSpawnWeight()), sci.getMinCount(), sci.getMaxCount());
                    newSpawnEntriesList.add(newS);
                }
                newMap.put(mc, new class_7061(class_7061.class_7062.field_37200, class_6012.method_34988(newSpawnEntriesList)));
            }
            if (newMap.isEmpty()) continue;
            class_3195 workStruct = (class_3195)csf.getValue();
            try {
                class_3195.class_7302 cfg = (class_3195.class_7302)fieldStructConfig.get(workStruct);
                fieldStructConfig.set(workStruct, new class_3195.class_7302(cfg.comp_686(), newMap, cfg.comp_688(), cfg.comp_689()));
            }
            catch (Exception e) {
                if (MyConfigs.getDebugLevel() > 0) {
                    e.printStackTrace();
                    continue;
                }
                LOGGER.error("Failed to balance " + csfIdentifier + " spawnentries map.  Set debugValue to 1 to see stacktrace.");
            }
        }
    }

    private static void fixStructureSpawnValues(class_2378<class_3195> csfreg) {
        ArrayList<class_5483.class_1964> newSpawnersList = new ArrayList<class_5483.class_1964>();
        for (Map.Entry csf : csfreg.method_29722()) {
            class_5321 csfKey = (class_5321)csf.getKey();
            String csfIdentifier = csfKey.method_29177().toString();
            String csfName = csfKey.toString();
            HashMap<class_1311, class_7061> newMap = new HashMap<class_1311, class_7061>();
            class_3195 workStruct = (class_3195)csf.getValue();
            Map mobs = workStruct.method_41615();
            if (mobs == null) continue;
            for (class_1311 mc : class_1311.values()) {
                class_7061 old = (class_7061)mobs.get(mc);
                if (old == null) continue;
                class_6012 oldwrl = old.comp_515();
                newSpawnersList.clear();
                for (class_5483.class_1964 s : oldwrl.method_34994()) {
                    int newSpawnWeight = s.method_34979().method_34976();
                    if (newSpawnWeight < MyConfigs.getMinSpawnWeight()) {
                        newSpawnWeight = newSpawnWeight > 1 && newSpawnWeight * 10 < MyConfigs.getMaxSpawnWeight() ? (newSpawnWeight *= 10) : MyConfigs.getMinSpawnWeight();
                    }
                    if (newSpawnWeight > MyConfigs.getMaxSpawnWeight()) {
                        newSpawnWeight = MyConfigs.getMaxSpawnWeight();
                    }
                    class_5483.class_1964 newS = new class_5483.class_1964(s.field_9389, class_6007.method_34977((int)newSpawnWeight), s.field_9388, s.field_9387);
                    newSpawnersList.add(newS);
                }
                newMap.put(mc, new class_7061(class_7061.class_7062.field_37200, class_6012.method_34988(newSpawnersList)));
            }
            try {
                class_3195.class_7302 cfg = (class_3195.class_7302)fieldStructConfig.get(workStruct);
                fieldStructConfig.set(workStruct, new class_3195.class_7302(cfg.comp_686(), newMap, cfg.comp_688(), cfg.comp_689()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to fix " + csfName + " spawnentries map.  Set debugValue to 1 to see stacktrace.");
            }
        }
    }

    private static void generateStructureSpawnValuesReport(class_2378<class_3195> csfreg) {
        PrintStream p = null;
        try {
            p = new PrintStream(new FileOutputStream("config/spawnbalanceutility/StructMobWeight.rpt", false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (p == null) {
            p = System.out;
        }
        p.println("* This is the StructMobWeight report file that is output every time the server starts.");
        p.println("* ");
        p.println("* Spawn Balance Utility (SBU) will use this file ONLY if it is renamed to StructMobWeight.csv.");
        p.println("* Lines starting with '*' are comments and ignored");
        p.println("* It allows you to add and remove mobs and adjust their spawnweights for Structures");
        p.println("* like shipwrecks, nether fortresses, water monuments, etc.");
        p.println("* ");
        for (Map.Entry csf : csfreg.method_29722()) {
            class_5321 csfKey = (class_5321)csf.getKey();
            String csfIdentifier = csfKey.method_29177().toString();
            class_3195 workStruct = (class_3195)csf.getValue();
            class_3195.class_7302 cfg = null;
            try {
                cfg = (class_3195.class_7302)fieldStructConfig.get(workStruct);
            }
            catch (Exception e) {
                if (MyConfigs.getDebugLevel() > 0) {
                    e.printStackTrace();
                }
                LOGGER.error("Failed to load " + csfIdentifier + " Config/SpawnGroup map.  Set debugValue to 1 to see stacktrace.");
            }
            if (cfg == null) {
                LOGGER.error("error:" + csfIdentifier + " Config/SpawnGroup map is null.");
                continue;
            }
            p.println(++structureLineNumber + ", " + csfIdentifier + ", HEADING, header:ignore, 0, 0, 0");
            for (class_1311 spawnGroup : class_1311.values()) {
                class_7061 mobs = (class_7061)cfg.comp_687().get(spawnGroup);
                if (mobs == null) continue;
                for (class_5483.class_1964 s : mobs.comp_515().method_34994()) {
                    String modName = ((class_5321)s.field_9389.method_40124().method_40230().get()).method_29177().method_12836();
                    if (MyConfigs.isSuppressMinecraftMobReporting() && modName.equals("minecraft")) continue;
                    String mobIdentifier = ((class_5321)s.field_9389.method_40124().method_40230().get()).method_29177().toString();
                    p.println(++structureLineNumber + ", " + csfIdentifier + ", " + String.valueOf(spawnGroup) + ", " + mobIdentifier + ", " + s.method_34979().method_34976() + ", " + s.field_9388 + ", " + s.field_9387);
                }
            }
        }
        if (p != System.out) {
            p.close();
        }
    }

    static {
        SpawnStructData.initReports();
        try {
            MappingResolver mapping = FabricLoader.getInstance().getMappingResolver();
            String fieldName = mapping.mapFieldName("intermediary", "net.minecraft.class_3195", "field_38429", "Lnet/minecraft/class_3195$class_7302;");
            fieldStructConfig = class_3195.class.getDeclaredField(fieldName);
            fieldStructConfig.setAccessible(true);
        }
        catch (Exception e) {
            LOGGER.error("XXX Unexpected Reflection Failure trying set Structure.Config record accessible");
        }
    }
}

