/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawnbalanceutility.util;

import com.mactso.spawnbalanceutility.config.MyConfigs;
import com.mactso.spawnbalanceutility.manager.BiomeCreatureManager;
import com.mactso.spawnbalanceutility.manager.MobMassAdditionManager;
import com.mactso.spawnbalanceutility.utility.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_6007;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnBiomeData {
    private static final Logger LOGGER = LogManager.getLogger();
    static int biomelineNumber = 0;
    static int reportlinenumber = 0;
    static int biomeEventNumber = 0;
    static Set<String> biomesProcessed = new HashSet<String>();
    static Set<String> structuresProcessed = new HashSet<String>();

    public static void initReports() {
        File fma;
        File fb;
        File fd = new File("config/spawnbalanceutility");
        if (!fd.exists()) {
            fd.mkdir();
        }
        if ((fb = new File("config/spawnbalanceutility/BiomeMobWeight.rpt")).exists()) {
            fb.delete();
        }
        if (!(fma = new File("config/spawnbalanceutility/MassAdditionMobs.rpt")).exists()) {
            SpawnBiomeData.generateMassAdditionMobsStubReport();
        }
    }

    public static void doBiomeActions(MinecraftServer server) {
        SpawnBiomeData.initReports();
        if (MyConfigs.isBalanceBiomeSpawnValues()) {
            SpawnBiomeData.balanceBiomeSpawnValues(server);
        }
        if (MyConfigs.isFixSpawnValues()) {
            SpawnBiomeData.fixBiomeSpawnValues(server);
        }
        if (MyConfigs.isGenerateReport()) {
            SpawnBiomeData.generateBiomeSpawnValuesReport(server);
        }
    }

    public static void balanceBiomeSpawnValues(MinecraftServer server) {
        class_5455.class_6890 dynreg = server.method_30611();
        class_2378 biomeRegistry = dynreg.method_30530(class_7924.field_41236);
        Field fieldSpawners = null;
        try {
            MappingResolver mapping = FabricLoader.getInstance().getMappingResolver();
            String fieldName = mapping.mapFieldName("intermediary", "net.minecraft.class_5483", "field_26405", "Ljava/util/Map;");
            fieldSpawners = class_5483.class.getDeclaredField(fieldName);
            fieldSpawners.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("XXX Unexpected Reflection Failure set SpawnSettings.spawners accessible");
        }
        String vCl = "";
        ArrayList<class_5483.class_1964> newBalancedList = new ArrayList<class_5483.class_1964>();
        for (class_1959 b : biomeRegistry) {
            class_5321 bk = (class_5321)biomeRegistry.method_29113((Object)b).get();
            Optional oRE = biomeRegistry.method_40264(bk);
            if (!oRE.isPresent()) continue;
            String bn = biomeRegistry.method_10221((Object)b).toString();
            List<BiomeCreatureManager.BiomeCreatureItem> modBiomeMobSpawners = BiomeCreatureManager.biomeCreaturesMap.get(bn);
            if (modBiomeMobSpawners == null) {
                LOGGER.warn("No spawn values found for biome: " + bn + " when balance flag is true.");
                modBiomeMobSpawners = new ArrayList<BiomeCreatureManager.BiomeCreatureItem>();
                continue;
            }
            class_5483 msi = b.method_30966();
            HashMap<class_1311, class_6012> newMap = new HashMap<class_1311, class_6012>();
            for (class_1311 v : class_1311.values()) {
                newBalancedList.clear();
                vCl = v.method_6133();
                for (BiomeCreatureManager.BiomeCreatureItem biomeCreatureItem : modBiomeMobSpawners) {
                    if (!biomeCreatureItem.getClassification().toLowerCase().equals(vCl)) continue;
                    Optional opt = class_7923.field_41177.method_17966(class_2960.method_60654((String)biomeCreatureItem.getModAndMob()));
                    if (opt.isPresent()) {
                        class_5483.class_1964 newSpawner = new class_5483.class_1964((class_1299)opt.get(), class_6007.method_34977((int)biomeCreatureItem.getSpawnWeight()), biomeCreatureItem.getMinCount(), biomeCreatureItem.getMaxCount());
                        newBalancedList.add(newSpawner);
                        continue;
                    }
                    LOGGER.error(reportlinenumber + "SpawnBalanceUtility ERROR: Mob " + biomeCreatureItem.getModAndMob() + " not in Entity Type Registry");
                }
                newMap.put(v, class_6012.method_34988(newBalancedList));
            }
            try {
                fieldSpawners.set(msi, newMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void fixBiomeSpawnValues(MinecraftServer server) {
        LOGGER.warn(" SpawnBalanceUtility: Fixing biome extreme spawn values. ");
        class_5455.class_6890 dynreg = server.method_30611();
        class_2378 biomeRegistry = dynreg.method_30530(class_7924.field_41236);
        Field fieldSpawners = null;
        try {
            MappingResolver mapping = FabricLoader.getInstance().getMappingResolver();
            String fieldName = mapping.mapFieldName("intermediary", "net.minecraft.class_5483", "field_26405", "Ljava/util/Map;");
            fieldSpawners = class_5483.class.getDeclaredField(fieldName);
            fieldSpawners.setAccessible(true);
        }
        catch (Exception e) {
            LOGGER.error("XXX Unexpected Reflection Failure lateBalanceBiomeSpawnValues");
            return;
        }
        ArrayList<class_5483.class_1964> newFixedList = new ArrayList<class_5483.class_1964>();
        for (class_1959 b : biomeRegistry) {
            class_5321 bk = (class_5321)biomeRegistry.method_29113((Object)b).get();
            Optional oRE = biomeRegistry.method_40264(bk);
            if (!oRE.isPresent()) continue;
            String bcName = biomeRegistry.method_29113((Object)b).toString();
            boolean zombifiedPiglinSpawner = false;
            boolean ghastSpawner = false;
            class_5483 msi = b.method_30966();
            Object map = null;
            HashMap<class_1311, class_6012> newMap = new HashMap<class_1311, class_6012>();
            for (class_1311 mc : class_1311.values()) {
                newFixedList.clear();
                Utility.debugMsg(1, "biome:" + String.valueOf(class_1959.field_24677.simple()) + ", " + b.toString());
                class_6012 originalSpawnerEntryList = b.method_30966().method_31004(mc);
                for (class_5483.class_1964 s : originalSpawnerEntryList.method_34994()) {
                    int newSpawnWeight = s.method_34979().method_34976();
                    if (newSpawnWeight > MyConfigs.getMaxSpawnWeight()) {
                        newSpawnWeight = MyConfigs.getMaxSpawnWeight();
                    }
                    if (newSpawnWeight < MyConfigs.getMinSpawnWeight()) {
                        newSpawnWeight = MyConfigs.getMinSpawnWeight();
                    }
                    String key = s.field_9389.toString();
                    class_5483.class_1964 newS = new class_5483.class_1964(s.field_9389, class_6007.method_34977((int)newSpawnWeight), s.field_9388, s.field_9387);
                    newFixedList.add(newS);
                    if (Utility.getMyBC((class_6880<class_1959>)((class_6880)oRE.get())) != Utility.NETHER) continue;
                    if (s.field_9389 == class_1299.field_6050) {
                        zombifiedPiglinSpawner = true;
                    }
                    if (s.field_9389 != class_1299.field_6107) continue;
                    ghastSpawner = true;
                }
                List<MobMassAdditionManager.MassAdditionMobItem> massAddMobs = MobMassAdditionManager.getFilteredList(mc, bcName);
                for (MobMassAdditionManager.MassAdditionMobItem ma : massAddMobs) {
                    Optional oe = class_1299.method_5898((String)ma.getModAndMob());
                    if (!oe.isPresent()) continue;
                    class_1299 et = (class_1299)oe.get();
                    boolean mobFound = false;
                    for (class_5483.class_1964 s : newFixedList) {
                        if (s.field_9389 != et) continue;
                        mobFound = true;
                        break;
                    }
                    if (mobFound) continue;
                    class_5483.class_1964 newS = new class_5483.class_1964(et, class_6007.method_34977((int)ma.getSpawnWeight()), ma.getMinCount(), ma.getMaxCount());
                    newFixedList.add(newS);
                }
                if (Utility.getMyBC((class_6880<class_1959>)((class_6880)oRE.get())) == Utility.NETHER && mc == class_1311.field_6302) {
                    class_5483.class_1964 newS;
                    if (!zombifiedPiglinSpawner && MyConfigs.isFixEmptyNether()) {
                        newS = new class_5483.class_1964(class_1299.field_6050, class_6007.method_34977((int)MyConfigs.getMinSpawnWeight()), 1, 4);
                        newFixedList.add(newS);
                    }
                    if (!ghastSpawner && MyConfigs.isFixEmptyNether()) {
                        newS = new class_5483.class_1964(class_1299.field_6107, class_6007.method_34977((int)((int)((float)MyConfigs.getMinSpawnWeight() * 0.75f))), 4, 4);
                        newFixedList.add(newS);
                    }
                }
                newMap.put(mc, class_6012.method_34988(newFixedList));
            }
            try {
                fieldSpawners.set(msi, newMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void generateMassAdditionMobsStubReport() {
        PrintStream p = null;
        try {
            p = new PrintStream(new FileOutputStream("config/spawnbalanceutility/MassAdditionMobs.rpt", false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (p == null) {
            p = System.out;
        }
        p.println("* This is an example Mass Addition File that lets you add mobs to every biome.");
        p.println("* Lines that start with a '*' are comments and are not used.");
        p.println("* If you rename this file to MassAdditionMobs.csv, Spawn Balance Utility will use it.");
        p.println("*");
        p.println("* Parameter explainations and values.");
        p.println("* Parm Dimension  : A, O, N, E for All, Overworld, Nether, The End");
        p.println("* Parm Class      : MONSTER, CREATURE, AMBIENT, UNDERWATER, etc.");
        p.println("* Parm Resource   : modname:mobname");
        p.println("* Parm Weight     : a number 1 or higher.  1 is superrare, 5 is rare, 20 is uncommon, 80 is common.");
        p.println("* Parm MinGroup   : a number 1 and less than MaxGroup");
        p.println("* Parm MaxGroup   : a number higher than MinGroup and usually 5 or less.");
        p.println("* Format is. Line, Dim,   Class, mod:mob,           spawnWeight, Mingroup, MaxGroup");
        p.println("*");
        p.println("* 1,   A, MONSTER, minecraft:phantom, 10           ,1         ,4");
        p.println("* will add phantoms too all biomes with a spawnweight of 10 and 1-4 group size.");
        p.println("*");
        if (p != System.out) {
            p.close();
        }
    }

    public static void generateBiomeSpawnValuesReport(MinecraftServer server) {
        class_5455.class_6890 dynreg = server.method_30611();
        class_2378 biomeRegistry = dynreg.method_30530(class_7924.field_41236);
        PrintStream p = null;
        try {
            p = new PrintStream(new FileOutputStream("config/spawnbalanceutility/BiomeMobWeight.rpt", false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (p == null) {
            p = System.out;
        }
        p.println("* This is the BiomeMobWeight report file that is output every time the server starts.");
        p.println("* ");
        p.println("* Spawn Balance Utility (SBU) will use this file ONLY if it is renamed to BiomeMobWeight.csv.");
        p.println("* If you remove all lines for a Biome, the default values will be used");
        p.println("* So for an 'empty' biome, leave one line with a CREATURE or the AMBIENT line with bats.");
        p.println("* Lines starting with '*' are comments and ignored");
        p.println("* When this file is read, SBU writes summary information to the log file.");
        p.println("* ");
        for (class_1959 b : biomeRegistry) {
            class_5321 bk = (class_5321)biomeRegistry.method_29113((Object)b).get();
            Optional oRE = biomeRegistry.method_40264(bk);
            if (!oRE.isPresent()) continue;
            String categoryName = Utility.getMyBC((class_6880<class_1959>)((class_6880)oRE.get()));
            class_2960 bi = bk.method_29177();
            String biomeIdAsString = bi.toString();
            class_5483 msi = b.method_30966();
            for (class_1311 v : class_1311.values()) {
                for (class_5483.class_1964 s : msi.method_31004(v).method_34994()) {
                    String creatureName = s.field_9389.method_35050();
                    String creatureIdAsString = ((class_5321)s.field_9389.method_40124().method_40230().get()).method_29177().toString();
                    String modname = ((class_5321)s.field_9389.method_40124().method_40230().get()).method_29177().method_12836();
                    if (MyConfigs.isSuppressMinecraftMobReporting() && modname.equals("minecraft") || !MyConfigs.isIncludedMod(modname)) continue;
                    p.println(++biomelineNumber + ", " + categoryName + ", " + biomeIdAsString + ", " + String.valueOf(v) + ", " + creatureIdAsString + ", " + String.valueOf(s.method_34979()) + ", " + s.field_9388 + ", " + s.field_9387);
                }
            }
        }
        if (p != System.out) {
            p.close();
        }
    }

    static {
        SpawnBiomeData.initReports();
    }
}

