/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawnbalanceutility.manager;

import com.mactso.spawnbalanceutility.config.MyConfigs;
import com.mactso.spawnbalanceutility.utility.Utility;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import net.minecraft.class_1311;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobMassAdditionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static Hashtable<String, MassAdditionMobItem> massAdditionMobsHashtable = new Hashtable();
    static int lastgoodline = 0;
    public static String CATEGORY_ALL = "A";
    public static String CATEGORY_OVERWORLD = "O";
    public static String CATEGORY_NETHER = "N";
    public static String CATEGORY_THEEND = "E";

    public static List<MassAdditionMobItem> getFilteredList(class_1311 v, String category) {
        ArrayList<MassAdditionMobItem> ma = new ArrayList<MassAdditionMobItem>();
        for (MassAdditionMobItem m : massAdditionMobsHashtable.values()) {
            if (!v.method_6133().equalsIgnoreCase(m.getClassification())) continue;
            if (m.getCategory().equals(CATEGORY_ALL)) {
                ma.add(m);
                continue;
            }
            if (category == Utility.NETHER) {
                if (!m.getCategory().equals(CATEGORY_NETHER)) continue;
                ma.add(m);
                continue;
            }
            if (category == Utility.THEEND) {
                if (!m.getCategory().equals(CATEGORY_THEEND)) continue;
                ma.add(m);
                continue;
            }
            if (category == Utility.NONE || !m.getCategory().equals(CATEGORY_OVERWORLD)) continue;
            ma.add(m);
        }
        return ma;
    }

    public static void massAdditionMobsInit() {
        int spawnWeight = 0;
        int minCount = 0;
        int maxCount = 0;
        int linecount = 0;
        String errorField = "first";
        if (massAdditionMobsHashtable.size() > 0) {
            return;
        }
        try (InputStreamReader input = new InputStreamReader(new FileInputStream("config/spawnbalanceutility/MassAdditionMobs.csv"));){
            String line;
            BufferedReader br = new BufferedReader(input);
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, ",");
                ++linecount;
                try {
                    int lineNumber;
                    errorField = "linenumber";
                    lastgoodline = lineNumber = Integer.parseInt(st.nextToken().trim());
                    errorField = "category";
                    String category = st.nextToken().trim();
                    errorField = "classification";
                    String classification = st.nextToken().trim();
                    errorField = "modAndMob";
                    String modAndMob = st.nextToken().trim();
                    errorField = "spawnWeight";
                    spawnWeight = Integer.parseInt(st.nextToken().trim());
                    errorField = "minCount";
                    minCount = Integer.parseInt(st.nextToken().trim());
                    errorField = "maxCount";
                    maxCount = Integer.parseInt(st.nextToken().trim());
                    if (minCount < 1) {
                        minCount = 1;
                    }
                    if (maxCount > 12) {
                        maxCount = 12;
                    }
                    if (minCount > maxCount) {
                        minCount = maxCount;
                    }
                    String key = modAndMob;
                    if (!MobMassAdditionManager.validClassification(classification)) {
                        System.out.println("SpawnBalanceUtility invalid classification " + classification + " on " + linecount + "th line of MassAdditionMobs.csv.");
                        continue;
                    }
                    if (spawnWeight <= 0) continue;
                    MassAdditionMobItem bci = new MassAdditionMobItem(lineNumber, category, classification, modAndMob, spawnWeight, minCount, maxCount);
                    massAdditionMobsHashtable.put(key, bci);
                }
                catch (Exception e) {
                    if (!line.isEmpty()) {
                        LOGGER.error("SpawnBalanceUtility Error reading field " + errorField + " on " + linecount + "th line of MassAdditionMobs.csv.");
                        continue;
                    }
                    if (MyConfigs.getDebugLevel() <= 0) continue;
                    LOGGER.warn("SpawnBalanceUtility Warning blank line at " + linecount + "th line of MassAdditionMobs.csv.");
                }
            }
            input.close();
        }
        catch (Exception e) {
            System.out.println("MassAdditionMobs.csv not found in subdirectory SpawnBalanceUtility");
        }
    }

    public static boolean validClassification(String classification) {
        for (class_1311 e : class_1311.values()) {
            if (!classification.equalsIgnoreCase(e.method_6133())) continue;
            return true;
        }
        return false;
    }

    public static class MassAdditionMobItem {
        int lineNumber;
        String category;
        String classification;
        String modAndMob;
        int spawnWeight;
        int minCount;
        int maxCount;

        public MassAdditionMobItem(int lineNumber, String category, String classification, String modAndMob, int spawnWeight, int min, int max) {
            this.lineNumber = lineNumber;
            this.category = category;
            this.classification = classification;
            this.modAndMob = modAndMob;
            this.spawnWeight = spawnWeight;
            this.minCount = min;
            this.maxCount = max;
        }

        public String getCategory() {
            return this.category;
        }

        public String getClassification() {
            return this.classification;
        }

        public String getModAndMob() {
            return this.modAndMob;
        }

        public int getSpawnWeight() {
            return this.spawnWeight;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }
    }
}

