/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawnbalanceutility.config;

import com.mactso.spawnbalanceutility.config.ModConfigProvider;
import com.mactso.spawnbalanceutility.config.SimpleConfig;
import com.mactso.spawnbalanceutility.manager.BiomeCreatureManager;
import com.mactso.spawnbalanceutility.manager.MobMassAdditionManager;
import com.mactso.spawnbalanceutility.manager.StructureCreatureManager;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MyConfigs {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int NO_DEFAULT_SPAWN_WEIGHT_FOUND = -999;
    public static SimpleConfig CONFIG;
    private static ModConfigProvider configs;
    private static final String defaultIncludedReportModsSet = "*;";
    private static final String defaultSpawnWeightList = "minecraft:enderman,5;minecraft:witch,5;";
    public static int debugLevel;
    private static boolean generateReport;
    private static boolean suppressMinecraftMobReporting;
    private static boolean fixEmptyNether;
    private static boolean balanceBiomeSpawnValues;
    private static boolean fixSpawnValues;
    private static boolean balanceStructureSpawnValues;
    public static int minSpawnWeight;
    public static int maxSpawnWeight;
    public static HashSet<String> includedReportModsSet;
    public static HashSet<String> spawnWeightList;

    public static void registerConfigs() {
        configs = new ModConfigProvider();
        MyConfigs.createConfigs();
        CONFIG = SimpleConfig.of("spawnbalanceutilityconfig").provider(configs).request();
        MyConfigs.assignConfigs();
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void setDebugLevel(int debugLevel) {
        MyConfigs.debugLevel = debugLevel;
    }

    public static boolean isGenerateReport() {
        return generateReport;
    }

    public static boolean isSuppressMinecraftMobReporting() {
        return suppressMinecraftMobReporting;
    }

    public static boolean isFixEmptyNether() {
        return fixEmptyNether;
    }

    public static boolean isBalanceBiomeSpawnValues() {
        return balanceBiomeSpawnValues;
    }

    public static boolean isFixSpawnValues() {
        return fixSpawnValues;
    }

    public static boolean isBalanceStructureSpawnValues() {
        return balanceStructureSpawnValues;
    }

    public static int getMinSpawnWeight() {
        return minSpawnWeight;
    }

    public static int getMaxSpawnWeight() {
        return maxSpawnWeight;
    }

    public static boolean isIncludedMod(String modName) {
        if (includedReportModsSet.contains("*")) {
            return true;
        }
        if (includedReportModsSet.isEmpty()) {
            return true;
        }
        return includedReportModsSet.contains(modName);
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"key.debugLevel", (Object)0), "int");
        configs.addKeyValuePair(new Pair((Object)"key.generateReport", (Object)"true"), "String");
        configs.addKeyValuePair(new Pair((Object)"key.suppressMinecraftMobReporting", (Object)"false"), "String");
        configs.addKeyValuePair(new Pair((Object)"key.fixEmptyNether", (Object)"true"), "String");
        configs.addKeyValuePair(new Pair((Object)"key.balanceBiomeSpawnValues", (Object)"true"), "String");
        configs.addKeyValuePair(new Pair((Object)"key.fixSpawnValues", (Object)"true"), "String");
        configs.addKeyValuePair(new Pair((Object)"key.balanceStructureSpawnValues", (Object)"true"), "String");
        configs.addKeyValuePair(new Pair((Object)"key.includedReportModsSet", (Object)defaultIncludedReportModsSet), "String");
        configs.addKeyValuePair(new Pair((Object)"key.minSpawnWeight", (Object)5), "int");
        configs.addKeyValuePair(new Pair((Object)"key.maxSpawnWeight", (Object)80), "int");
    }

    private static void assignConfigs() {
        debugLevel = CONFIG.getOrDefault("key.debugLevel", 0);
        generateReport = "true".equals(CONFIG.getOrDefault("key.generateReport", "true"));
        suppressMinecraftMobReporting = "true".equals(CONFIG.getOrDefault("key.suppressMinecraftMobReporting", "true"));
        fixEmptyNether = "true".equals(CONFIG.getOrDefault("key.fixEmptyNether", "true"));
        balanceBiomeSpawnValues = "true".equals(CONFIG.getOrDefault("key.balanceBiomeSpawnValues", "true"));
        fixSpawnValues = "true".equals(CONFIG.getOrDefault("key.fixSpawnValues", "true"));
        balanceStructureSpawnValues = "true".equals(CONFIG.getOrDefault("key.balanceStructureSpawnValues", "true"));
        includedReportModsSet = MyConfigs.getIncludedModStringSet(MyConfigs.extract(CONFIG.getOrDefault("key.includedReportModsSet", defaultIncludedReportModsSet)));
        minSpawnWeight = CONFIG.getOrDefault("key.minSpawnWeight", 5);
        maxSpawnWeight = CONFIG.getOrDefault("key.maxSpawnWeight", 80);
        BiomeCreatureManager.biomeCreatureInit();
        StructureCreatureManager.structureCreatureInit();
        MobMassAdditionManager.massAdditionMobsInit();
        LOGGER.info("All " + configs.getConfigsList().size() + " have been set properly");
    }

    public static HashSet<String> getIncludedModStringSet(String[] values) {
        HashSet<String> set = new HashSet<String>();
        for (String s : values) {
            String s2 = s.trim().toLowerCase();
            if (s2.isEmpty()) continue;
            set.add(s2);
        }
        return set;
    }

    public static String[] extract(String s) {
        String[] ret = s.split(";");
        return ret;
    }
}

