/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.teamremastered.endrem.platform.Services;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigOptions {
    static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String configPath = Services.CONFIG_HELPER.configDirectoryPath() + "/" + Services.CONFIG_HELPER.configFolderName() + "/";
    private static final String configName = "endrem.json";
    private static ConfigOptions ENDREM_CONFIG;
    public boolean USE_EYE_OF_ENDER = false;
    public boolean THROW_EYE_OF_ENDER = false;
    public boolean FRAME_HAS_RANDOM_EYE = false;
    public int EYE_BREAK_PROBABILITY = 10;
    public boolean IS_CRYPTIC_EYE_OBTAINABLE = true;
    public boolean IS_EVIL_EYE_OBTAINABLE = true;
    public boolean CAN_REMOVE_EYE = true;

    private ConfigOptions() {
    }

    public static void create() throws IOException {
        File configFile;
        File configFolder = new File(configPath);
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if (!(configFile = new File(configPath + configName)).exists()) {
            try (FileWriter fw = new FileWriter(configFile.getPath());){
                gson.toJson((Object)new ConfigOptions(), (Appendable)fw);
            }
        }
        ENDREM_CONFIG = ConfigOptions.load();
    }

    public static ConfigOptions load() throws FileNotFoundException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(configPath + configName));
        return (ConfigOptions)gson.fromJson((Reader)bufferedReader, ConfigOptions.class);
    }

    public static ConfigOptions getERConfig() {
        return ENDREM_CONFIG;
    }
}

