/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.load;

import com.bawnorton.configurable.api.ConfigurableApi;
import com.bawnorton.configurable.generated.GeneratedConfig;
import com.bawnorton.configurable.generated.GeneratedConfigLoader;
import com.bawnorton.configurable.generated.GeneratedConfigScreenFactory;
import com.bawnorton.configurable.libs.gson.FieldNamingStrategy;
import com.bawnorton.configurable.ref.gson.ItemTypeAdapter;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_310;
import net.minecraft.class_437;

public final class ConfigurableWrapper {
    private final ConfigurableApi apiImpl;
    private GeneratedConfigLoader<GeneratedConfig> loader;
    private GeneratedConfigScreenFactory screenFactory;
    private GeneratedConfig lastLoadedConfig;

    public ConfigurableWrapper(ConfigurableApi apiImpl) {
        this.apiImpl = apiImpl;
    }

    public void setLoader(Class<? extends GeneratedConfigLoader<GeneratedConfig>> loaderClass) {
        if (this.loader != null) {
            throw new IllegalStateException("loader already set");
        }
        try {
            Constructor<? extends GeneratedConfigLoader<GeneratedConfig>> loaderCtor = loaderClass.getConstructor(new Class[0]);
            this.loader = loaderCtor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setScreenFactory(Class<? extends GeneratedConfigScreenFactory> screenFactoryClass) {
        if (this.screenFactory != null) {
            throw new IllegalStateException("screen factory already set");
        }
        try {
            Constructor<? extends GeneratedConfigScreenFactory> screenFactoryCtor = screenFactoryClass.getConstructor(new Class[0]);
            this.screenFactory = screenFactoryCtor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean serverEnforces() {
        return this.apiImpl.serverEnforces();
    }

    public FieldNamingStrategy getFieldNamingStrategy() {
        return this.apiImpl.defaultFieldNamingStrategy();
    }

    public Map<Class<?>, Object> getTypeAdapters() {
        HashMap typeAdapters = new HashMap(this.apiImpl.getTypeAdapters());
        typeAdapters.put(class_1792.class, new ItemTypeAdapter());
        return typeAdapters;
    }

    public GeneratedConfig getConfig() {
        if (this.lastLoadedConfig == null) {
            this.loadConfig();
            this.saveConfig();
        }
        return this.lastLoadedConfig;
    }

    public boolean hasLoader() {
        return this.loader != null;
    }

    public boolean hasScreenFactory() {
        return this.screenFactory != null;
    }

    public boolean isClientOnly() {
        return this.apiImpl.clientOnly();
    }

    public void loadConfig() {
        this.lastLoadedConfig = this.loader.loadConfig(this.apiImpl::beforeLoad);
        this.lastLoadedConfig = this.apiImpl.afterLoad(this.lastLoadedConfig);
    }

    public void saveConfig() {
        this.lastLoadedConfig = this.apiImpl.beforeSave(this.lastLoadedConfig);
        this.loader.saveConfig(this.lastLoadedConfig);
    }

    public void deserializeConfig(String serialized) {
        this.lastLoadedConfig = this.loader.deserializeConfig(serialized);
    }

    public String serializeConfig(GeneratedConfig config) {
        return this.loader.serializeConfig(config);
    }

    public class_437 createScreen(class_310 client, class_437 parent) {
        if (this.screenFactory == null) {
            return parent;
        }
        return this.screenFactory.createScreen(client, parent);
    }

    public void refreshConfigScreen() {
        if (this.screenFactory == null) {
            return;
        }
        this.screenFactory.refresh();
    }
}

