/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.helper;

import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;

public class AnnotationHelper {
    public static Optional<AnnotationMirror> getSubAnnotation(AnnotationMirror parent, String name) {
        if (parent == null) {
            return Optional.empty();
        }
        return parent.getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().contentEquals(name)).findFirst().map(entry -> (AnnotationMirror)entry.getValue());
    }

    public static boolean isDefaultValue(AnnotationMirror annotation, String methodName) {
        if (annotation == null) {
            return true;
        }
        ExecutableElement methodElement = null;
        for (ExecutableElement executableElement : annotation.getElementValues().keySet()) {
            if (!executableElement.getSimpleName().contentEquals(methodName)) continue;
            methodElement = executableElement;
            break;
        }
        if (methodElement == null) {
            return true;
        }
        AnnotationValue defaultValue = methodElement.getDefaultValue();
        AnnotationValue annotationValue = annotation.getElementValues().get(methodElement);
        return Objects.equals(annotationValue, defaultValue);
    }
}

