/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable;

import com.bawnorton.configurable.libs.gson.FieldNamingPolicy;
import com.bawnorton.configurable.libs.gson.FieldNamingStrategy;
import com.bawnorton.configurable.libs.gson.Gson;
import com.bawnorton.configurable.libs.gson.GsonBuilder;
import com.bawnorton.configurable.load.ConfigurableApiImplLoader;
import com.bawnorton.configurable.load.ConfigurableSettings;
import com.bawnorton.configurable.load.ConfigurableWrapper;
import com.bawnorton.configurable.networking.Networking;
import com.bawnorton.configurable.platform.Platform;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurableMain {
    public static final String MOD_ID = "configurable";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"configurable");
    private static final Map<String, Map<String, ConfigurableWrapper>> WRAPPERS = new HashMap<String, Map<String, ConfigurableWrapper>>();
    private static final Gson GSON = new GsonBuilder().setFieldNamingStrategy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void init() {
        ConfigurableApiImplLoader.load();
        Networking.init();
        ArrayList settingsList = new ArrayList();
        Platform.forEachJar(path -> {
            Path configurable = path.resolve(MOD_ID);
            if (!Files.exists(configurable, new LinkOption[0]) || !Files.isDirectory(configurable, new LinkOption[0])) {
                return;
            }
            ArrayList sourceSetSettings = new ArrayList();
            try (Stream<Path> stream = Files.list(configurable);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(sourceSetSettings::add);
            }
            catch (IOException e) {
                LOGGER.error("Could not find configurable settings", (Throwable)e);
            }
            for (Path sourceSetSetting : sourceSetSettings) {
                ConfigurableSettings settings;
                try {
                    settings = GSON.fromJson((Reader)Files.newBufferedReader(sourceSetSetting), ConfigurableSettings.class);
                }
                catch (IOException e) {
                    LOGGER.error("Could not load configurable settings", (Throwable)e);
                    return;
                }
                settingsList.add(settings);
            }
        });
        for (ConfigurableSettings settings : settingsList) {
            Map<String, ConfigurableWrapper> wrappers;
            String configName = settings.name();
            String sourceSet = settings.sourceSet();
            if (WRAPPERS.containsKey(configName) && (wrappers = WRAPPERS.get(configName)).containsKey(sourceSet)) {
                throw new IllegalStateException("Conflicting config name \"%s\" for source set \"%s\"".formatted(configName, sourceSet));
            }
            try {
                ConfigurableWrapper wrapper = new ConfigurableWrapper(ConfigurableApiImplLoader.getImpl(configName));
                if (wrapper.isClientOnly() && Platform.isServer()) {
                    return;
                }
                WRAPPERS.computeIfAbsent(configName, k -> new HashMap()).put(sourceSet, wrapper);
                ConfigurableMain.addToWrapped(settings::fullyQualifiedLoader, wrapper::setLoader, configName);
                if (!settings.hasScreenFactory() || Platform.isServer()) continue;
                ConfigurableMain.addToWrapped(settings::fullyQualifiedScreenFactory, wrapper::setScreenFactory, configName);
            }
            catch (IllegalStateException e) {
                LOGGER.error("Could not create configurable wrapper for \"%s\"".formatted(configName), (Throwable)e);
            }
        }
        WRAPPERS.values().forEach(sourceSetWrappers -> sourceSetWrappers.values().forEach(wrapper -> {
            wrapper.loadConfig();
            wrapper.saveConfig();
        }));
    }

    private static <T> void addToWrapped(Supplier<String> nameGetter, Consumer<Class<T>> applicator, String configName) {
        try {
            applicator.accept(Class.forName(nameGetter.get()));
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOGGER.error("Could not find config class for \"%s\"".formatted(configName), e);
        }
    }

    public static Map<Class<?>, Object> getTypeAdapters(String configName, String sourceSet) {
        return WRAPPERS.get(configName).get(sourceSet).getTypeAdapters();
    }

    public static FieldNamingStrategy getFieldNamingStrategy(String configName, String sourceSet) {
        return WRAPPERS.get(configName).get(sourceSet).getFieldNamingStrategy();
    }

    public static Map<String, Map<String, ConfigurableWrapper>> getAllWrappers() {
        return WRAPPERS;
    }

    public static Map<String, ConfigurableWrapper> getWrappers(String configName) {
        return WRAPPERS.get(configName);
    }
}

