/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.Kitchen;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProcessor;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.crafting.CraftingOperation;
import net.minecraft.class_1657;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class CraftingContext {
    private final List<KitchenItemProvider> itemProviders;
    private final List<KitchenItemProcessor> itemProcessors;
    private final Map<IntList, Integer> cachedProviderIndexByIngredient = new HashMap<IntList, Integer>();
    private final Map<CraftingOperation.IngredientTokenKey, CacheHint> cacheHintsByIngredient = new HashMap<CraftingOperation.IngredientTokenKey, CacheHint>();

    public CraftingContext(Kitchen kitchen, @Nullable class_1657 player) {
        this.itemProviders = kitchen.getItemProviders(player);
        this.itemProcessors = kitchen.getItemProcessors();
    }

    public CraftingOperation createOperation(class_8786<class_1860<?>> recipe) {
        return new CraftingOperation(this, recipe);
    }

    public List<KitchenItemProvider> getItemProviders() {
        return this.itemProviders;
    }

    public List<KitchenItemProcessor> getItemProcessors() {
        return this.itemProcessors;
    }

    public int getCachedItemProviderIndexFor(class_1856 ingredient) {
        return this.cachedProviderIndexByIngredient.getOrDefault(ingredient.method_8100(), -1);
    }

    public CacheHint getCacheHintFor(CraftingOperation.IngredientTokenKey ingredientTokenKey) {
        return this.cacheHintsByIngredient.getOrDefault(ingredientTokenKey, CacheHint.NONE);
    }

    public void cache(CraftingOperation.IngredientTokenKey ingredientTokenKey, int itemProviderIndex, CacheHint cacheHint) {
        this.cacheHintsByIngredient.put(ingredientTokenKey, cacheHint);
        this.cachedProviderIndexByIngredient.put(ingredientTokenKey.stackingIds(), itemProviderIndex);
    }
}

