/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableBlockEntity;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7225;

public class SinkBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider,
TransferableBlockEntity<Integer> {
    private static final int SYNC_INTERVAL = 10;
    private final FluidTank sinkTank = new FluidTank(16000){

        public class_3611 getFluid() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return class_3612.field_15910;
            }
            return super.getFluid();
        }

        public int getAmount() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getAmount();
        }

        public int getCapacity() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getCapacity();
        }

        public int drain(class_3611 fluid, int maxDrain, boolean simulate) {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater && fluid == class_3612.field_15910) {
                return maxDrain;
            }
            if (fluid.method_15780(class_3612.field_15906) || !fluid.method_15780(fluid)) {
                return 0;
            }
            SinkBlockEntity.this.method_5431();
            return super.drain(fluid, maxDrain, simulate);
        }

        public int fill(class_3611 fluid, int maxFill, boolean simulate) {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return maxFill;
            }
            SinkBlockEntity.this.method_5431();
            return super.fill(fluid, maxFill, simulate);
        }
    };
    private final SinkItemProvider itemProvider = new SinkItemProvider(this);
    private int ticksSinceSync;
    private boolean isDirty;
    private class_1767 color = class_1767.field_7952;

    public SinkBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.sink.get(), pos, state);
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        tag.method_10566("FluidTank", (class_2520)this.sinkTank.serialize());
        tag.method_10567("Color", (byte)this.color.method_7789());
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        this.sinkTank.deserialize(tag.method_10562("FluidTank"));
        this.color = class_1767.method_7791((int)tag.method_10571("Color"));
    }

    public void writeUpdateTag(class_2487 tag) {
        this.method_11007(tag, (class_7225.class_7874)this.field_11863.method_30349());
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(KitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, SinkBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        ++this.ticksSinceSync;
        if (this.ticksSinceSync >= 10) {
            this.ticksSinceSync = 0;
            if (this.isDirty) {
                this.sync();
                this.isDirty = false;
            }
        }
    }

    public void method_5431() {
        super.method_5431();
        this.isDirty = true;
    }

    public FluidTank getFluidTank() {
        return this.sinkTank;
    }

    @Override
    public Integer snapshotDataForTransfer() {
        return this.sinkTank.getAmount();
    }

    @Override
    public void restoreFromTransferSnapshot(Integer data) {
        this.sinkTank.setFluid((class_3611)class_3612.field_15910, data.intValue());
    }

    private record SinkItemProvider(SinkBlockEntity sink) implements KitchenItemProvider
    {
        @Override
        public IngredientToken findIngredient(class_1856 ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (class_1799 itemStack : ingredient.method_8105()) {
                IngredientToken found = this.findIngredient(itemStack, ingredientTokens, cacheHint);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        @Override
        public IngredientToken findIngredient(class_1799 itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            if (!itemStack.method_31573(ModItemTags.WATER)) {
                return null;
            }
            int milkUnitsUsed = ingredientTokens.size();
            int milkUnitsAvailable = this.sink.getFluidTank().getAmount() / 1000 - milkUnitsUsed;
            if (milkUnitsAvailable > 1) {
                return new SinkIngredientToken(this.sink, itemStack);
            }
            return null;
        }

        @Override
        public CacheHint getCacheHint(IngredientToken ingredientToken) {
            return CacheHint.NONE;
        }
    }

    private record SinkIngredientToken(SinkBlockEntity milkJar, class_1799 itemStack) implements IngredientToken
    {
        @Override
        public class_1799 peek() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, true);
            return drained >= 1000 ? this.itemStack : class_1799.field_8037;
        }

        @Override
        public class_1799 consume() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, false);
            return drained >= 1000 ? this.itemStack : class_1799.field_8037;
        }

        @Override
        public class_1799 restore(class_1799 itemStack) {
            this.milkJar.getFluidTank().fill(Compat.getMilkFluid(), 1000, false);
            return class_1799.field_8037;
        }
    }
}

