/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_7225;

public class MilkJarBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider {
    protected static final int MILK_CAPACITY = 32000;
    private final MilkJarItemProvider itemProvider = new MilkJarItemProvider(this);
    protected final FluidTank milkTank = new FluidTank(32000){

        public boolean canFill(class_3611 fluid) {
            return fluid.method_15780(Compat.getMilkFluid()) && super.canFill(fluid);
        }

        public void setChanged() {
            MilkJarBlockEntity.this.method_5431();
            MilkJarBlockEntity.this.sync();
        }
    };

    public MilkJarBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends MilkJarBlockEntity>)((class_2591)ModBlockEntities.milkJar.get()), pos, state);
    }

    protected MilkJarBlockEntity(class_2591<? extends MilkJarBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        tag.method_10566("FluidTank", (class_2520)this.milkTank.serialize());
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        this.milkTank.deserialize(tag.method_10562("FluidTank"));
    }

    public void writeUpdateTag(class_2487 tag) {
        this.method_11007(tag, (class_7225.class_7874)this.field_11863.method_30349());
    }

    public FluidTank getFluidTank() {
        return this.milkTank;
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(KitchenItemProvider.class, (Object)this.itemProvider)});
    }

    private record MilkJarItemProvider(MilkJarBlockEntity milkJar) implements KitchenItemProvider
    {
        @Override
        public IngredientToken findIngredient(class_1856 ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (class_1799 itemStack : ingredient.method_8105()) {
                IngredientToken found = this.findIngredient(itemStack, ingredientTokens, cacheHint);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        @Override
        public IngredientToken findIngredient(class_1799 itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            if (!itemStack.method_31573(ModItemTags.MILK)) {
                return null;
            }
            int milkUnitsUsed = ingredientTokens.size();
            int milkUnitsAvailable = this.milkJar.getFluidTank().getAmount() / 1000 - milkUnitsUsed;
            if (milkUnitsAvailable > 1) {
                return new MilkJarIngredientToken(this.milkJar, itemStack);
            }
            return null;
        }

        @Override
        public CacheHint getCacheHint(IngredientToken ingredientToken) {
            return CacheHint.NONE;
        }
    }

    private record MilkJarIngredientToken(MilkJarBlockEntity milkJar, class_1799 itemStack) implements IngredientToken
    {
        @Override
        public class_1799 peek() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, true);
            return drained >= 1000 ? this.itemStack : class_1799.field_8037;
        }

        @Override
        public class_1799 consume() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, false);
            return drained >= 1000 ? this.itemStack : class_1799.field_8037;
        }

        @Override
        public class_1799 restore(class_1799 itemStack) {
            this.milkJar.getFluidTank().fill(Compat.getMilkFluid(), 1000, false);
            return class_1799.field_8037;
        }
    }
}

