/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public abstract class BaseKitchenBlock
extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 FLIPPED = class_2746.method_11825((String)"flipped");
    public static final class_2746 HAS_COLOR = class_2746.method_11825((String)"has_color");
    public static final class_2754<class_1767> COLOR = class_2754.method_11850((String)"color", class_1767.class);
    private static final class_265 BOUNDING_BOX_X = class_2248.method_9541((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0);
    private static final class_265 BOUNDING_BOX_Z = class_2248.method_9541((double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0, (double)15.5);

    protected BaseKitchenBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (((class_2350)state.method_11654((class_2769)FACING)).method_10166() == class_2350.class_2351.field_11048) {
            return BOUNDING_BOX_X;
        }
        return BOUNDING_BOX_Z;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9605(class_1750 context) {
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
        return state.method_28498((class_2769)HAS_COLOR) ? (class_2680)state.method_11657((class_2769)HAS_COLOR, (Comparable)Boolean.valueOf(false)) : state;
    }

    public void method_9568(class_1799 itemStack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.cookingforblockheads.multiblock_kitchen").method_27692(class_124.field_1054));
        this.appendHoverDescriptionText(itemStack, context, tooltip, flag);
    }

    protected void appendHoverDescriptionText(class_1799 itemStack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
    }

    public boolean shouldBePlacedFlipped(class_1750 context, class_2350 facing) {
        class_2338 pos = context.method_8037();
        class_1657 placer = context.method_8036();
        if (placer == null) {
            return Math.random() < 0.5;
        }
        double dir = 0.0;
        if (facing.method_10166() == class_2350.class_2351.field_11051) {
            dir = (double)((float)pos.method_10263() + 0.5f) - placer.method_23317();
            dir *= -1.0;
        } else if (facing.method_10166() == class_2350.class_2351.field_11048) {
            dir = (double)((float)pos.method_10260() + 0.5f) - placer.method_23321();
        }
        boolean flipped = facing.method_10171() == class_2350.class_2352.field_11056 ? dir < 0.0 : dir > 0.0;
        return flipped;
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof BalmContainerProvider) {
            BalmContainerProvider containerProvider = (BalmContainerProvider)blockEntity;
            if (!state.method_27852(newState.method_26204())) {
                containerProvider.dropItems(level, pos);
            }
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    public boolean tryRecolorBlock(class_2680 state, class_1799 heldItem, class_1937 level, class_2338 pos, class_1657 player, class_3965 rayTraceResult) {
        if (heldItem.method_7909() == class_1802.field_8324 && this.removeColor(state, (class_1936)level, pos, rayTraceResult.method_17780())) {
            if (!player.method_31549().field_7477) {
                heldItem.method_7934(1);
            }
            return true;
        }
        class_1767 color = Balm.getHooks().getColor(heldItem);
        if (color != null) {
            if (this.recolorBlock(state, (class_1936)level, pos, rayTraceResult.method_17780(), color) && !player.method_31549().field_7477) {
                heldItem.method_7934(1);
            }
            return true;
        }
        return false;
    }

    protected class_2680 getDyedStateOf(class_2680 state, @Nullable class_1767 color) {
        if (state.method_28498(COLOR) && state.method_28498((class_2769)HAS_COLOR)) {
            if (color != null) {
                return (class_2680)((class_2680)state.method_11657(COLOR, (Comparable)color)).method_11657((class_2769)HAS_COLOR, (Comparable)Boolean.valueOf(true));
            }
            return (class_2680)state.method_11657((class_2769)HAS_COLOR, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    private boolean removeColor(class_2680 state, class_1936 world, class_2338 pos, class_2350 facing) {
        class_2680 removedColorState = this.getDyedStateOf(state, null);
        if (!removedColorState.equals(state)) {
            class_2586 blockEntity = world.method_8321(pos);
            Object transferData = null;
            if (blockEntity instanceof TransferableBlockEntity) {
                TransferableBlockEntity transferableBlockEntity = (TransferableBlockEntity)blockEntity;
                transferData = transferableBlockEntity.snapshotDataForTransfer();
            }
            world.method_8652(pos, removedColorState, 3);
            class_2586 newBlockEntity = world.method_8321(pos);
            if (transferData != null && newBlockEntity instanceof TransferableBlockEntity) {
                TransferableBlockEntity transferableBlockEntity = (TransferableBlockEntity)newBlockEntity;
                transferableBlockEntity.restoreFromTransferSnapshot(transferData);
            }
            return true;
        }
        return false;
    }

    protected boolean recolorBlock(class_2680 state, class_1936 world, class_2338 pos, class_2350 facing, class_1767 color) {
        class_2680 recoloredState = this.getDyedStateOf(state, color);
        if (!recoloredState.equals(state)) {
            class_2586 blockEntity = world.method_8321(pos);
            Object transferData = null;
            if (blockEntity instanceof TransferableBlockEntity) {
                TransferableBlockEntity transferableBlockEntity = (TransferableBlockEntity)blockEntity;
                transferData = transferableBlockEntity.snapshotDataForTransfer();
            }
            world.method_8652(pos, recoloredState, 3);
            class_2586 newBlockEntity = world.method_8321(pos);
            if (transferData != null && newBlockEntity instanceof TransferableBlockEntity) {
                TransferableBlockEntity transferableBlockEntity = (TransferableBlockEntity)newBlockEntity;
                transferableBlockEntity.restoreFromTransferSnapshot(transferData);
            }
            return true;
        }
        return false;
    }

    public boolean method_9592(class_2680 state, class_1937 level, class_2338 pos, int id, int param) {
        class_2586 tileEntity = level.method_8321(pos);
        if (tileEntity != null) {
            return tileEntity.method_11004(id, param);
        }
        return false;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (itemStack.method_57826(class_9334.field_49631) && (blockEntity = level.method_8321(pos)) instanceof IMutableNameable) {
            ((IMutableNameable)blockEntity).setCustomName(itemStack.method_7964());
        }
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }
}

