/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.networkstats;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.connectivity.logging.PacketLogging;
import com.connectivity.networkstats.INamedPacket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5251;

public class NetworkStatGatherer {
    private static volatile Map<String, ConcurrentHashMap<String, PacketData>> connectionPacketData = new ConcurrentHashMap<String, ConcurrentHashMap<String, PacketData>>();
    private static final int recordingDuration = ((CommonConfiguration)Connectivity.config.getCommonConfig()).packetHistoryMinutes;
    private static List<Map<String, ConcurrentHashMap<String, PacketData>>> minuteData = new ArrayList<Map<String, ConcurrentHashMap<String, PacketData>>>(recordingDuration);
    static int index = 0;

    public static void add(String remoteAddress, class_2596 packet, int packetSize) {
        String packetName = packet.getClass().getSimpleName();
        if (packet instanceof INamedPacket && !((INamedPacket)packet).getName().isEmpty()) {
            packetName = ((INamedPacket)packet).getName();
        }
        PacketData data = connectionPacketData.computeIfAbsent(remoteAddress, remote -> new ConcurrentHashMap()).computeIfAbsent(packetName, name -> new PacketData((String)name));
        if (data.maxPacketBytes < packetSize) {
            data.largestPacket = packet;
        }
        data.add(packetSize);
    }

    public static void saveData() {
        if (++index >= recordingDuration) {
            index = 0;
        }
        minuteData.set(index, connectionPacketData);
        connectionPacketData = new ConcurrentHashMap<String, ConcurrentHashMap<String, PacketData>>();
    }

    public static PlayerPacketDataEntry getDataForPlayer(class_3222 playerEntity, int minutes) {
        String id = playerEntity.field_13987.method_48107().toString();
        HashMap<String, PacketData> gatherMap = new HashMap<String, PacketData>();
        int timeMinutes = minutes;
        for (int i = 0; i < minutes; ++i) {
            int preIndex = Math.abs((index - i) % recordingDuration);
            Map<String, ConcurrentHashMap<String, PacketData>> data2 = minuteData.get(preIndex);
            if (data2 != null && data2.containsKey(id)) {
                NetworkStatGatherer.condenseDataToMap(data2.get(id).values(), gatherMap);
            }
            if (data2 != null) continue;
            --timeMinutes;
        }
        ArrayList<PacketData> dataList = new ArrayList<PacketData>(gatherMap.values());
        dataList.sort(Comparator.comparingLong(data -> data.totalPacketBytes).reversed());
        NetworkStatGatherer.calculateThroughput(dataList, timeMinutes);
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData entry : dataList) {
            totalBytes += entry.totalPacketBytes;
            totalRate += entry.rate;
        }
        return new PlayerPacketDataEntry(dataList, totalBytes, totalRate, playerEntity);
    }

    public static List<PacketData> getDataByPacket(int minutes) {
        HashMap<String, PacketData> gatherMap = new HashMap<String, PacketData>();
        int timeMinutes = minutes;
        for (int i = 0; i < minutes; ++i) {
            int preIndex = Math.abs((index - i) % recordingDuration);
            Map<String, ConcurrentHashMap<String, PacketData>> data2 = minuteData.get(preIndex);
            if (data2 != null) {
                for (Map.Entry<String, ConcurrentHashMap<String, PacketData>> entry : data2.entrySet()) {
                    NetworkStatGatherer.condenseDataToMap(entry.getValue().values(), gatherMap);
                }
                continue;
            }
            --timeMinutes;
        }
        ArrayList<PacketData> result = new ArrayList<PacketData>(gatherMap.values());
        result.sort(Comparator.comparingLong(data -> data.totalPacketBytes).reversed());
        NetworkStatGatherer.calculateThroughput(result, timeMinutes);
        return result;
    }

    private static void calculateThroughput(Collection<PacketData> data, int minutes) {
        if (minutes <= 0) {
            return;
        }
        for (PacketData packetData : data) {
            packetData.rate = (double)((float)packetData.totalPacketBytes / ((float)minutes * 60.0f)) / 1000.0;
        }
    }

    private static void condenseDataToMap(Collection<PacketData> insertData, Map<String, PacketData> dataMap) {
        if (insertData == null) {
            return;
        }
        for (PacketData data : insertData) {
            if (dataMap.containsKey(data.packetName)) {
                PacketData existing = dataMap.get(data.packetName);
                existing.totalPacketBytes += data.totalPacketBytes;
                existing.packetCount += data.packetCount;
                if (existing.maxPacketBytes < data.maxPacketBytes && data.largestPacket != null) {
                    existing.largestPacket = data.largestPacket;
                }
                existing.maxPacketBytes = Math.max(existing.maxPacketBytes, data.maxPacketBytes);
                continue;
            }
            PacketData newData = new PacketData(data.packetName);
            newData.totalPacketBytes = data.totalPacketBytes;
            newData.maxPacketBytes = data.maxPacketBytes;
            newData.packetCount = data.packetCount;
            newData.largestPacket = data.largestPacket;
            dataMap.put(data.packetName, newData);
        }
    }

    public static void reportAllPlayerSummary(class_2168 source, int minutes, int startIndex) {
        DecimalFormat percent = new DecimalFormat("########.##");
        class_2583 GREEN_BOLD = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1060));
        class_2583 BLUE = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1078));
        class_2583 RED = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1061));
        ArrayList<PlayerPacketDataEntry> playerData = new ArrayList<PlayerPacketDataEntry>();
        for (class_3222 player : source.method_9225().method_8503().method_3760().method_14571()) {
            playerData.add(NetworkStatGatherer.getDataForPlayer(player, minutes));
        }
        playerData.sort(Comparator.comparingLong(data -> data.totalBytes).reversed());
        source.method_45068((class_2561)class_2561.method_43470((String)("Network players summary of last " + minutes + " minutes.")));
        long byteSum = 0L;
        for (PlayerPacketDataEntry packetData : playerData) {
            byteSum += packetData.totalBytes;
        }
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < playerData.size(); ++i) {
            PlayerPacketDataEntry playerPacketDataEntry = (PlayerPacketDataEntry)playerData.get(i);
            source.method_45068((class_2561)class_2561.method_43470((String)(percent.format((double)playerPacketDataEntry.totalBytes / (double)byteSum * 100.0) + "% ")).method_10852((class_2561)class_2561.method_43470((String)(playerPacketDataEntry.playerEntity.method_5477().getString() + " "))).method_10862(GREEN_BOLD).method_10852((class_2561)class_2561.method_43470((String)("r: " + percent.format(playerPacketDataEntry.totalRate) + "kb/s ")).method_10862(BLUE)).method_10852((class_2561)class_2561.method_43470((String)("total sent: " + percent.format((double)playerPacketDataEntry.totalBytes / 1000.0) + "kb")).method_10862(RED)));
        }
        if (i + 1 < playerData.size()) {
            source.method_45068((class_2561)class_2561.method_43470((String)"next --->").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/connectivity packetsAllPlayers %d %d", minutes, i)))));
        }
    }

    public static void reportStatsSummary(class_2168 source, int minutes, int startIndex) {
        List<PacketData> data = NetworkStatGatherer.getDataByPacket(minutes);
        DecimalFormat percent = new DecimalFormat("########.##");
        class_2583 GREEN_BOLD = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1060));
        class_2583 BLUE = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1078));
        class_2583 YELLOW = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1054));
        class_2583 RED = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1061));
        class_2583 GOLD = class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_27703(class_5251.method_27718((class_124)class_124.field_1065));
        source.method_45068((class_2561)class_2561.method_43470((String)("Network packet summary of last " + minutes + " minutes.")));
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData packetData : data) {
            totalBytes += packetData.totalPacketBytes;
            totalRate += packetData.rate;
        }
        source.method_45068((class_2561)class_2561.method_43470((String)("Total kb:" + percent.format((double)totalBytes / 1000.0) + " total rate:" + percent.format(totalRate))).method_10862(GOLD));
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < data.size(); ++i) {
            PacketData packetData;
            packetData = data.get(i);
            source.method_45068((class_2561)class_2561.method_43470((String)(percent.format((double)packetData.totalPacketBytes / (double)totalBytes * 100.0) + "% ")).method_10852((class_2561)class_2561.method_43470((String)(packetData.packetName + " "))).method_10862(GREEN_BOLD).method_10852((class_2561)class_2561.method_43470((String)("r: " + percent.format(packetData.rate) + "kb/s ")).method_10862(BLUE)).method_10852((class_2561)class_2561.method_43470((String)("count:" + packetData.packetCount + " ")).method_10862(YELLOW)).method_10852((class_2561)class_2561.method_43470((String)("maxSize: " + percent.format((double)packetData.maxPacketBytes / 1000.0) + "kb")).method_10862(RED)));
        }
        if (i + 1 < data.size()) {
            source.method_45068((class_2561)class_2561.method_43470((String)"next --->").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/connectivity packetsSummary %d %d", minutes, i)))));
        }
    }

    public static void reportPlayerSummary(class_2168 source, class_3222 playerEntity, int minutes, int startIndex) {
        if (playerEntity == null) {
            source.method_45068((class_2561)class_2561.method_43470((String)"Player not found"));
            return;
        }
        PlayerPacketDataEntry playerPacketData = NetworkStatGatherer.getDataForPlayer(playerEntity, minutes);
        List<PacketData> data = playerPacketData.packetData;
        DecimalFormat percent = new DecimalFormat("########.##");
        class_2583 GREEN_BOLD = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1060));
        class_2583 BLUE = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1078));
        class_2583 YELLOW = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1054));
        class_2583 RED = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1061));
        class_2583 GOLD = class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_27703(class_5251.method_27718((class_124)class_124.field_1065));
        source.method_45068((class_2561)class_2561.method_43470((String)("Network packet summary for " + playerEntity.method_5477().getString() + " of last " + minutes + " minutes.")));
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData packetData : data) {
            totalBytes += packetData.totalPacketBytes;
            totalRate += packetData.rate;
        }
        source.method_45068((class_2561)class_2561.method_43470((String)("Total kb:" + percent.format((double)totalBytes / 1000.0) + " total rate:" + percent.format(totalRate))).method_10862(GOLD));
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < data.size(); ++i) {
            PacketData packetData;
            packetData = data.get(i);
            source.method_45068((class_2561)class_2561.method_43470((String)(percent.format((double)packetData.totalPacketBytes / (double)totalBytes * 100.0) + "% ")).method_10852((class_2561)class_2561.method_43470((String)(packetData.packetName + " "))).method_10862(GREEN_BOLD).method_10852((class_2561)class_2561.method_43470((String)("r: " + percent.format(packetData.rate) + "kb/s ")).method_10862(BLUE)).method_10852((class_2561)class_2561.method_43470((String)("count:" + packetData.packetCount + " ")).method_10862(YELLOW)).method_10852((class_2561)class_2561.method_43470((String)("maxSize: " + percent.format((double)packetData.maxPacketBytes / 1000.0) + "kb")).method_10862(RED)));
        }
        if (i + 1 < data.size()) {
            source.method_45068((class_2561)class_2561.method_43470((String)"next --->").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/connectivity packetsPlayer %s %d %d", playerEntity.method_5477().getString(), minutes, i)))));
        }
    }

    public static void reportClientStatsSummary(class_1657 playerEntity, int minutes, int startIndex) {
        if (playerEntity == null) {
            return;
        }
        List<PacketData> data = NetworkStatGatherer.getDataByPacket(minutes);
        DecimalFormat percent = new DecimalFormat("########.##");
        class_2583 GREEN_BOLD = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1060));
        class_2583 BLUE = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1078));
        class_2583 YELLOW = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1054));
        class_2583 RED = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1061));
        class_2583 GOLD = class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_27703(class_5251.method_27718((class_124)class_124.field_1065));
        playerEntity.method_7353((class_2561)class_2561.method_43470((String)("Network outgoing packet summary of last " + minutes + " minutes.")), false);
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData packetData : data) {
            totalBytes += packetData.totalPacketBytes;
            totalRate += packetData.rate;
        }
        playerEntity.method_7353((class_2561)class_2561.method_43470((String)("Total kb:" + percent.format((double)totalBytes / 1000.0) + " total rate:" + percent.format(totalRate))).method_10862(GOLD), false);
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < data.size(); ++i) {
            PacketData packetData;
            packetData = data.get(i);
            playerEntity.method_7353((class_2561)class_2561.method_43470((String)(percent.format((double)packetData.totalPacketBytes / (double)totalBytes * 100.0) + "% ")).method_10852((class_2561)class_2561.method_43470((String)(packetData.packetName + " "))).method_10862(GREEN_BOLD).method_10852((class_2561)class_2561.method_43470((String)("r: " + percent.format(packetData.rate) + "kb/s ")).method_10862(BLUE)).method_10852((class_2561)class_2561.method_43470((String)("count:" + packetData.packetCount + " ")).method_10862(YELLOW)).method_10852((class_2561)class_2561.method_43470((String)("maxSize: " + percent.format((double)packetData.maxPacketBytes / 1000.0) + "kb")).method_10862(RED)), false);
        }
        if (i + 1 < data.size()) {
            playerEntity.method_7353((class_2561)class_2561.method_43470((String)"next --->").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/connectivity packetsClient %d %d", minutes, i)))), false);
        }
    }

    public static void printPacketsFittingName(class_2168 source, String name) {
        if (name == null || name.isEmpty()) {
            source.method_45068((class_2561)class_2561.method_43470((String)"Invalid name"));
            return;
        }
        List<PacketData> packetData = NetworkStatGatherer.getDataByPacket(((CommonConfiguration)Connectivity.config.getCommonConfig()).packetHistoryMinutes);
        DecimalFormat percent = new DecimalFormat("########.##");
        class_2583 GREEN_BOLD = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1060));
        class_2583 BLUE = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1078));
        class_2583 YELLOW = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1054));
        class_2583 RED = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27718((class_124)class_124.field_1061));
        source.method_45068((class_2561)class_2561.method_43470((String)("Printing biggest packets fitting " + name + " to latest.log")));
        for (PacketData data : packetData) {
            if (data.largestPacket == null || !data.packetName.toLowerCase().contains(name.toLowerCase())) continue;
            source.method_45068((class_2561)class_2561.method_43470((String)("Printed: " + data.packetName + " ")).method_10862(GREEN_BOLD).method_10852((class_2561)class_2561.method_43470((String)("r: " + percent.format(data.rate) + "kb/s ")).method_10862(BLUE)).method_10852((class_2561)class_2561.method_43470((String)("count:" + data.packetCount + " ")).method_10862(YELLOW)).method_10852((class_2561)class_2561.method_43470((String)("maxSize: " + percent.format((double)data.maxPacketBytes / 1000.0) + "kb")).method_10862(RED)));
            PacketLogging.logPacket(data.largestPacket, "Print triggered by command");
        }
    }

    static {
        for (int i = 0; i < recordingDuration; ++i) {
            minuteData.add(null);
        }
    }

    private static class PacketData {
        public final String packetName;
        public int maxPacketBytes = 0;
        public long totalPacketBytes = 0L;
        public int packetCount = 0;
        public Object largestPacket = null;
        public double rate = 0.0;

        private PacketData(String packetName) {
            this.packetName = packetName;
        }

        void add(int packetSize) {
            if (this.maxPacketBytes < packetSize) {
                this.maxPacketBytes = packetSize;
            }
            ++this.packetCount;
            this.totalPacketBytes += (long)packetSize;
        }
    }

    private static class PlayerPacketDataEntry {
        final List<PacketData> packetData;
        final long totalBytes;
        final double totalRate;
        final class_3222 playerEntity;

        private PlayerPacketDataEntry(List<PacketData> packetData, long totalBytes, double totalRate, class_3222 playerEntity) {
            this.packetData = packetData;
            this.totalBytes = totalBytes;
            this.totalRate = totalRate;
            this.playerEntity = playerEntity;
        }
    }
}

