/*
 * Decompiled with CFR 0.152.
 */
package more_rpg_loot.entity.mob;

import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import java.util.List;
import more_rpg_loot.client.particle.Particles;
import more_rpg_loot.effects.Effects;
import more_rpg_loot.entity.goals.frostmonarch.CallServantsGoal;
import more_rpg_loot.entity.goals.frostmonarch.ConditionalGoal;
import more_rpg_loot.entity.goals.frostmonarch.ScreechGoal;
import more_rpg_loot.entity.goals.frostmonarch.StayStillWhenServantsAliveGoal;
import more_rpg_loot.entity.mob.FrostMonarchServantEntity;
import more_rpg_loot.sounds.ModSounds;
import more_rpg_loot.util.HelperMethods;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1613;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.more_rpg_classes.effect.MRPGCEffects;
import org.jetbrains.annotations.Nullable;

public class FrostMonarchEntity
extends class_1613 {
    private static final class_2940<Integer> INVUL_TIMER;
    private static final class_2940<Boolean> SCREECHING;
    private static final int DEFAULT_INVUL_TIMER = 220;
    private final class_3213 bossBar;
    public int callServantsCooldown = 0;
    public int callServantsMax = 4;
    public int screechCooldown = 0;
    public int hailStormCooldown = 0;
    private float particleAnimationProgress = 0.0f;
    private boolean callingServants;
    private int callAnimationTicks;

    public FrostMonarchEntity(class_1299<? extends FrostMonarchEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_14, 8.0f);
        this.bossBar = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5795).method_5406(true);
        this.method_6033(this.method_6063());
        this.field_6194 += 50;
    }

    public class_1799 getWeaponForDifficulty() {
        class_1267 difficulty = this.method_37908().method_8407();
        return switch (difficulty) {
            default -> throw new MatchException(null, null);
            case class_1267.field_5801, class_1267.field_5805 -> new class_1799((class_1935)class_1802.field_8406);
            case class_1267.field_5802 -> new class_1799((class_1935)class_1802.field_8062);
            case class_1267.field_5807 -> new class_1799((class_1935)class_1802.field_8475);
        };
    }

    public Float getHealingForDifficulty() {
        class_1267 difficulty = this.method_37908().method_8407();
        return switch (difficulty) {
            default -> throw new MatchException(null, null);
            case class_1267.field_5801, class_1267.field_5805 -> Float.valueOf(0.1f);
            case class_1267.field_5802 -> Float.valueOf(0.2f);
            case class_1267.field_5807 -> Float.valueOf(0.3f);
        };
    }

    public static class_5132.class_5133 createFrostmonarchAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23719, 0.2605).method_26868(class_5134.field_23716, 300.0).method_26868(class_5134.field_23718, 1.0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Invul", this.getInvulnerableTimer());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setInvulTimer(nbt.method_10550("Invul"));
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new CallServantsGoal(this));
        this.field_6201.method_6277(1, (class_1352)new StayStillWhenServantsAliveGoal(this));
        this.field_6201.method_6277(2, (class_1352)new ScreechGoal(this));
        this.field_6201.method_6277(3, (class_1352)new ConditionalGoal(this, (class_1352)new class_1366((class_1314)this, 1.2, false)));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 12.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new ConditionalGoal(this, (class_1352)new class_1400((class_1308)this, class_1657.class, true)));
        this.field_6185.method_6277(3, (class_1352)new ConditionalGoal(this, (class_1352)new class_1400((class_1308)this, class_1439.class, true)));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(INVUL_TIMER, (Object)0);
        builder.method_56912(SCREECHING, (Object)false);
    }

    public boolean isScreeching() {
        return (Boolean)this.field_6011.method_12789(SCREECHING);
    }

    public void setScreeching(boolean value) {
        this.field_6011.method_12778(SCREECHING, (Object)value);
    }

    public boolean hasServants() {
        List servants = this.method_37908().method_18467(FrostMonarchServantEntity.class, this.method_5829().method_1014(32.0));
        return servants.stream().anyMatch(class_1309::method_5805);
    }

    public boolean canHeal() {
        return this.method_6063() != this.method_6032() && !this.method_5809() && this.hasServants() && this.getInvulnerableTimer() == 0;
    }

    public void method_6007() {
        if (this.getInvulnerableTimer() > 0 || this.canHeal()) {
            this.method_36456(this.field_6283);
            this.method_5847(this.field_6283);
            this.field_5982 = this.field_6283;
            this.field_6259 = this.field_6283;
            this.method_18799(class_243.field_1353);
        }
        if (this.getInvulnerableTimer() > 0) {
            class_5819 random = this.method_37908().field_9229;
            int particlesPerTick = 70;
            float radius = 3.0f;
            for (int i = 0; i < particlesPerTick; ++i) {
                double angle = random.method_43058() * 2.0 * Math.PI;
                double distance = (double)radius * (0.5 + random.method_43058() * 0.5);
                double px = this.method_23317() + Math.cos(angle) * distance;
                double py = this.method_23318() + random.method_43058() * 3.0;
                double pz = this.method_23321() + Math.sin(angle) * distance;
                double vx = -Math.sin(angle) * 0.5 + (random.method_43058() - 0.5) * 0.2;
                double vy = 0.2 + random.method_43058() * 0.2;
                double vz = Math.cos(angle) * 0.5 + (random.method_43058() - 0.5) * 0.2;
                this.method_37908().method_8406((class_2394)class_2398.field_28013, px, py, pz, vx, vy, vz);
                if (!(random.method_43057() < 0.2f)) continue;
                this.method_37908().method_8406((class_2394)class_2398.field_11230, px, py, pz, vx * 0.5, vy * 0.5, vz * 0.5);
            }
        } else {
            this.particleAnimationProgress += 0.05f;
            List list = this.method_37908().method_18467(FrostMonarchServantEntity.class, this.method_5829().method_1014(32.0));
            int servantsCount = list.size();
            if (this.method_37908().field_9236 && !this.method_5809()) {
                if (this.canHeal()) {
                    for (class_1309 target : list) {
                        class_243 from = new class_243(this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321());
                        class_243 to = new class_243(target.method_23317(), target.method_23318() + (double)(target.method_17682() / 2.0f), target.method_23321());
                        class_243 delta = to.method_1020(from);
                        int steps = 10 + servantsCount;
                        long time = this.field_6012;
                        for (int i = 0; i <= steps; ++i) {
                            double t = (double)i / (double)steps;
                            class_243 point = from.method_1019(delta.method_1021(t));
                            double wave = Math.sin((double)time * 0.3 + t * 10.0) * 0.1;
                            class_243 offset = delta.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029().method_1021(wave);
                            class_243 finalPos = point.method_1019(offset);
                            this.method_37908().method_8406((class_2394)class_2398.field_38002, finalPos.field_1352, finalPos.field_1351, finalPos.field_1350, 0.0, 0.0, 0.0);
                        }
                    }
                }
                class_5819 random = this.method_37908().field_9229;
                int particleCount = 8;
                float sphereRadius = 3.0f;
                float rotationSpeed = 2.5f;
                float progress = this.particleAnimationProgress;
                for (int i = 0; i < particleCount; ++i) {
                    double theta = Math.acos(2.0 * random.method_43058() - 1.0);
                    double phi = Math.PI * 2 * random.method_43058() + (double)(progress * rotationSpeed);
                    double xOffset = (double)sphereRadius * Math.sin(theta) * Math.cos(phi);
                    double yOffset = (double)sphereRadius * Math.cos(theta);
                    double zOffset = (double)sphereRadius * Math.sin(theta) * Math.sin(phi);
                    double vx = -xOffset * 0.05 + (random.method_43058() - 0.5) * 0.05;
                    double vy = -yOffset * 0.05 + (random.method_43058() - 0.5) * 0.05;
                    double vz = -zOffset * 0.05 + (random.method_43058() - 0.5) * 0.05;
                    this.method_37908().method_8406((class_2394)Particles.FREEZING_SNOWFLAKE, this.method_23317() + xOffset, this.method_23318() + 1.5 + yOffset, this.method_23321() + zOffset, vx, vy, vz);
                }
            }
        }
        super.method_6007();
    }

    protected void method_5958() {
        if (this.getInvulnerableTimer() > 0) {
            int i = this.getInvulnerableTimer() - 1;
            this.bossBar.method_5408(1.0f - (float)i / 220.0f);
            if (i <= 0) {
                class_1937 class_19372 = this.method_37908();
                if (!(class_19372 instanceof class_3218)) {
                    return;
                }
                class_3218 serverWorld = (class_3218)class_19372;
                this.method_5673(class_1304.field_6173, this.getWeaponForDifficulty());
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.FROSTMONARCH_DEEP_FREEZE.soundEvent(), class_3419.field_15251, 0.75f, 1.0f);
                int particleCount = 150;
                double speed = 2.5;
                for (int u = 0; u < particleCount; ++u) {
                    double angle = Math.PI * 2 * (double)u / (double)particleCount;
                    double xSpeed = Math.cos(angle) * speed;
                    double zSpeed = Math.sin(angle) * speed;
                    double ySpeed = 0.05 + this.method_37908().field_9229.method_43058() * 0.1;
                    serverWorld.method_14199((class_2394)Particles.FREEZING_SNOWFLAKE, this.method_19538().field_1352, this.method_19538().field_1351 + 1.0, this.method_19538().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    serverWorld.method_14199((class_2394)Particles.FREEZING_SNOWFLAKE, this.method_19538().field_1352, this.method_19538().field_1351 + 1.0, this.method_19538().field_1350, 0, xSpeed, ySpeed, zSpeed, 1.0);
                }
                double radius = 5.0;
                List livingEntities = this.method_37908().method_8390(class_1309.class, new class_238(this.method_19538().field_1352 - radius, this.method_19538().field_1351 - radius, this.method_19538().field_1350 - radius, this.method_19538().field_1352 + radius, this.method_19538().field_1351 + radius, this.method_19538().field_1350 + radius), livingEntity -> livingEntity.method_5805() && livingEntity.method_5707(this.method_19538()) <= radius * radius);
                class_6880 effectEntry = Effects.FREEZING.registryEntry;
                if (FabricLoader.getInstance().isModLoaded("more_rpg_classes")) {
                    effectEntry = MRPGCEffects.FROZEN_SOLID.registryEntry;
                }
                for (class_1309 livingEntity2 : livingEntities) {
                    livingEntity2.method_6092(new class_1293(effectEntry, 100, 0));
                }
            }
            this.setInvulTimer(i);
            if (this.field_6012 % 10 == 0) {
                this.method_6025(10.0f);
            }
        } else {
            List list = this.method_37908().method_18467(FrostMonarchServantEntity.class, this.method_5829().method_1014(32.0));
            int servantsCount = list.size();
            if (this.canHeal()) {
                this.method_6025((float)servantsCount * this.getHealingForDifficulty().floatValue());
                for (class_1297 entities : list) {
                    entities.method_5643(entities.method_48923().method_48831(), 0.2f);
                }
            }
            this.bossBar.method_5408(this.method_6032() / this.method_6063());
        }
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
        super.method_6099(world, source, causedByPlayer);
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
        this.method_5673(class_1304.field_6173, this.getWeaponForDifficulty());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    @Nullable
    public class_1315 initialize(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_1315 entityData2 = super.method_5943(world, difficulty, spawnReason, entityData);
        if (FabricLoader.getInstance().isModLoaded("thermoo")) {
            this.method_5996(ThermooAttributes.MIN_TEMPERATURE).method_6192(5.0);
            this.method_5996(ThermooAttributes.FROST_RESISTANCE).method_6192(10.0);
        }
        this.method_5996(class_5134.field_23721).method_6192(6.0);
        this.method_6997();
        return entityData2;
    }

    public boolean method_6121(class_1297 target) {
        boolean success = super.method_6121(target);
        if (success && target instanceof class_1309) {
            class_1309 entity = (class_1309)target;
            HelperMethods.stackFreezeStacks(entity, 20);
        }
        return success;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 attacker;
        if (this.getInvulnerableTimer() > 0 && !source.method_48789(class_8103.field_42242)) {
            return false;
        }
        if (this.canHeal() && !source.method_48789(class_8103.field_42242)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42246) && !this.method_5771()) {
            return false;
        }
        if (!this.method_37908().field_9236 && !source.method_48789(class_8103.field_42260) && !source.method_49708(class_8111.field_42330) && (attacker = source.method_5526()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)attacker;
            HelperMethods.applyStatusEffect(livingEntity, 0, 4, Effects.FREEZING.registryEntry, 1, true, true, true, 1);
        }
        return super.method_5643(source, amount);
    }

    public void startCallingServants() {
        this.callingServants = true;
        this.callAnimationTicks = 20;
    }

    public void method_5773() {
        super.method_5773();
        if (this.callAnimationTicks > 0) {
            --this.callAnimationTicks;
        } else {
            this.callingServants = false;
        }
        if (this.screechCooldown > 0) {
            --this.screechCooldown;
        }
        if (this.hailStormCooldown > 0) {
            --this.hailStormCooldown;
        }
        if (this.callServantsCooldown > 0) {
            --this.callServantsCooldown;
        }
    }

    public void onSummoned() {
        class_1937 class_19372;
        this.setInvulTimer(220);
        if (!this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_5250 message = class_2561.method_43471((String)"entity.loot_n_explore.frost_monarch.spawn_message");
            for (class_3222 player : serverWorld.method_18456()) {
                player.method_7353((class_2561)message, true);
            }
        }
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.FROSTMONARCH_SPAWNED_LAUGH.soundEvent(), class_3419.field_15251, 1.0f, 1.0f);
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.FROSTMONARCH_SPAWNED_STORM.soundEvent(), class_3419.field_15251, 1.0f, 1.0f);
        this.bossBar.method_5408(0.0f);
        this.method_6033(this.method_6063() / 3.0f);
    }

    public int getInvulnerableTimer() {
        return (Integer)this.field_6011.method_12789(INVUL_TIMER);
    }

    public void setInvulTimer(int ticks) {
        this.field_6011.method_12778(INVUL_TIMER, (Object)ticks);
    }

    protected class_3414 method_5994() {
        return ModSounds.FROSTMONARCH_DEATH.soundEvent();
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.FROSTMONARCH_HURT.soundEvent();
    }

    protected class_3414 method_6002() {
        return ModSounds.FROSTMONARCH_DEATH.soundEvent();
    }

    static {
        SCREECHING = class_2945.method_12791(FrostMonarchEntity.class, (class_2941)class_2943.field_13323);
        INVUL_TIMER = class_2945.method_12791(FrostMonarchEntity.class, (class_2941)class_2943.field_13327);
    }
}

