/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.common.book.Book;

public final class BookContentResourceDirectLoader
implements BookContentLoader {
    public static final BookContentResourceDirectLoader INSTANCE = new BookContentResourceDirectLoader();

    private BookContentResourceDirectLoader() {
    }

    @Override
    public void findFiles(Book book, String dir, List<class_2960> list) {
        String prefix = String.format("%s/%s/%s/%s", "patchouli_books", book.id.method_12832(), "en_us", dir);
        Set files = class_310.method_1551().method_1478().method_14488(prefix, p -> p.method_12832().endsWith(".json")).keySet();
        files.stream().distinct().filter(file -> file.method_12836().equals(book.id.method_12836())).map(file -> {
            Preconditions.checkArgument((boolean)file.method_12832().startsWith(prefix));
            Preconditions.checkArgument((boolean)file.method_12832().endsWith(".json"));
            String newPath = file.method_12832().substring(prefix.length(), file.method_12832().length() - ".json".length());
            if (newPath.startsWith("/")) {
                newPath = newPath.substring(1);
            }
            return class_2960.method_60655((String)file.method_12836(), (String)newPath);
        }).forEach(list::add);
    }

    @Override
    @Nullable
    public BookContentLoader.LoadResult loadJson(Book book, class_2960 file) {
        PatchouliAPI.LOGGER.debug("Loading {}", (Object)file);
        class_3300 manager = class_310.method_1551().method_1478();
        try {
            Optional resourceOpt = manager.method_14486(file);
            if (resourceOpt.isPresent()) {
                class_3298 resource = (class_3298)resourceOpt.get();
                return new BookContentLoader.LoadResult(BookContentLoader.streamToJson(resource.method_14482()), BookContentResourceDirectLoader.computeAddedByText(resource.method_14480(), book));
            }
            return null;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Nullable
    private static String computeAddedByText(String sourcePackId, Book book) {
        if (sourcePackId.startsWith("file/")) {
            sourcePackId = sourcePackId.substring(5);
        }
        if (sourcePackId.equals("mod_resources") || sourcePackId.equals("fabric")) {
            return null;
        }
        return sourcePackId;
    }
}

