/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.structureessentials.StructureEssentials;
import com.structureessentials.Timings;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7157;
import net.minecraft.class_7737;
import net.minecraft.class_7924;

public class Command {
    public static Map<class_6880<class_1959>, List<Object2DoubleMap.Entry<class_6880<class_1959>>>> biomeScoreCache = new HashMap<class_6880<class_1959>, List<Object2DoubleMap.Entry<class_6880<class_1959>>>>();

    public LiteralArgumentBuilder<class_2168> build(class_7157 buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"structureessentials").then(class_2170.method_9247((String)"getBiomeTags").then(class_2170.method_9244((String)"biome", (ArgumentType)class_7737.method_45637((class_7157)buildContext, (class_5321)class_7924.field_41236)).executes(context -> {
            class_5321 biome = ((class_6880.class_6883)class_7737.method_45636((CommandContext)context, (String)"biome", (class_5321)class_7924.field_41236).method_45647().left().get()).method_40237();
            List biomeTags = ((class_6880.class_6883)((class_2378)((class_2168)context.getSource()).method_30497().method_33310(class_7924.field_41236).get()).method_40264(biome).get()).method_40228().collect(Collectors.toList());
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Biome tags for: " + String.valueOf(biome.method_29177()))).method_27692(class_124.field_1065));
            for (class_6862 biomeTag : biomeTags) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("#" + String.valueOf(biomeTag.comp_327()))));
            }
            return 1;
        })))).then(class_2170.method_9247((String)"showGenerationTimes").executes(context -> {
            int count = 0;
            ArrayList<Map.Entry<class_2960, Long>> sortedFeatures = new ArrayList<Map.Entry<class_2960, Long>>(Timings.featureTimings.entrySet());
            sortedFeatures.sort(Comparator.comparingLong(e -> (Long)((Map.Entry)e).getValue()).reversed());
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Features timings:").method_27692(class_124.field_1065));
            StructureEssentials.LOGGER.warn("Placed Feature timings in ms:");
            for (Map.Entry entry : sortedFeatures) {
                if (++count < 5) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("#:" + count + " id: " + String.valueOf(entry.getKey()) + " time: " + (Long)entry.getValue() / 1000000L)).method_27692(class_124.field_1068));
                }
                StructureEssentials.LOGGER.warn("#:" + count + " id: " + String.valueOf(entry.getKey()) + " time: " + (Long)entry.getValue() / 100000L);
            }
            count = 0;
            ArrayList<Map.Entry<class_2960, Long>> sortedStructures = new ArrayList<Map.Entry<class_2960, Long>>(Timings.structureTimings.entrySet());
            sortedStructures.sort(Comparator.comparingLong(e -> (Long)((Map.Entry)e).getValue()).reversed());
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Structure timings:").method_27692(class_124.field_1065));
            StructureEssentials.LOGGER.warn("Structure timings in ms:");
            for (Map.Entry entry : sortedStructures) {
                if (++count < 5) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("#:" + count + " id: " + String.valueOf(entry.getKey()) + " time: " + (Long)entry.getValue() / 1000000L)).method_27692(class_124.field_1068));
                }
                StructureEssentials.LOGGER.warn("#:" + count + " id: " + String.valueOf(entry.getKey()) + " time: " + (Long)entry.getValue() / 100000L);
            }
            return 1;
        }))).then(class_2170.method_9247((String)"getBiomesForTag").then(class_2170.method_9244((String)"biome", (ArgumentType)class_7737.method_45637((class_7157)buildContext, (class_5321)class_7924.field_41236)).executes(context -> {
            class_6862 biomeTag = ((class_6885.class_6888)class_7737.method_45636((CommandContext)context, (String)"biome", (class_5321)class_7924.field_41236).method_45647().right().get()).method_40251();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Biomes for tag: " + String.valueOf(biomeTag.comp_327()))).method_27692(class_124.field_1065));
            for (class_6880 biomeHolder : ((class_2378)((class_2168)context.getSource()).method_30497().method_33310(class_7924.field_41236).get()).method_40295()) {
                if (!biomeHolder.method_40220(biomeTag)) continue;
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Biome: " + String.valueOf(((class_5321)biomeHolder.method_40230().get()).method_29177()))));
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"getStructuresNearby").requires(stack -> stack.method_9259(2))).executes(context -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            HashMap<class_3195, LongSet> structures = new HashMap<class_3195, LongSet>();
            class_1923 start = new class_1923(class_2338.method_49638((class_2374)((class_2168)context.getSource()).method_9222()));
            for (int x = -5; x < 5; ++x) {
                for (int z = -5; z < 5; ++z) {
                    for (Map.Entry entry : world.method_27056().method_41037(new class_2338(start.field_9181 + x << 4, 0, start.field_9180 + z << 4)).entrySet()) {
                        structures.computeIfAbsent((class_3195)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                    }
                }
            }
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Structures nearby: ").method_27692(class_124.field_1065));
            HashMap structurePositions = new HashMap();
            for (Map.Entry structureEntry : structures.entrySet()) {
                world.method_27056().method_41032((class_3195)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> structurePositions.put(structureStart.method_14969().method_22874(), ((class_2378)((class_2168)context.getSource()).method_30497().method_33310(class_7924.field_41246).get()).method_10221((Object)((class_3195)structureEntry.getKey())).toString()));
            }
            ArrayList sortedStructures = new ArrayList(structurePositions.entrySet());
            sortedStructures.sort(Comparator.comparingDouble(p -> ((class_2338)p.getKey()).method_10262((class_2382)class_2338.method_49638((class_2374)((class_2168)context.getSource()).method_9222()))));
            for (Map.Entry structureEntry : sortedStructures) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)((String)structureEntry.getValue())).method_10852((class_2561)class_2561.method_43470((String)(" " + String.valueOf(structureEntry.getKey()))).method_27692(class_124.field_1054).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/tp " + ((class_2338)structureEntry.getKey()).method_10263() + " " + ((class_2338)structureEntry.getKey()).method_10264() + " " + ((class_2338)structureEntry.getKey()).method_10260())))));
            }
            return 1;
        }))).then(class_2170.method_9247((String)"getSimilarForBiome").then(class_2170.method_9244((String)"biome", (ArgumentType)class_7737.method_45637((class_7157)buildContext, (class_5321)class_7924.field_41236)).executes(context -> {
            biomeScoreCache.clear();
            class_5321 biome = ((class_6880.class_6883)class_7737.method_45636((CommandContext)context, (String)"biome", (class_5321)class_7924.field_41236).method_45647().left().get()).method_40237();
            class_6880 holder = (class_6880)((class_2378)((class_2168)context.getSource()).method_30497().method_33310(class_7924.field_41236).get()).method_40264(biome).get();
            List<Object2DoubleMap.Entry<class_6880<class_1959>>> sortedBiomeHolders = Command.getSimilarBiomesFor((class_6880<class_1959>)holder, ((class_2168)context.getSource()).method_30497());
            List<Map.Entry<class_6862<class_1959>, Double>> sortedBiomeTagKeys = Command.getSimilarTagsFor((class_6880<class_1959>)holder, ((class_2168)context.getSource()).method_30497());
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Similar biome tags for: " + String.valueOf(biome.method_29177()))).method_27692(class_124.field_1065));
            for (int i = 0; i < sortedBiomeHolders.size() && i < 7; ++i) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Weight:" + sortedBiomeHolders.get(i).getValue() + " Biome: " + String.valueOf(((class_5321)((class_6880)sortedBiomeHolders.get(i).getKey()).method_40229().left().get()).method_29177()))));
            }
            int count = 0;
            for (Map.Entry<class_6862<class_1959>, Double> tag : sortedBiomeTagKeys) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Weight:" + Math.round(tag.getValue()) + " Tag: #" + String.valueOf(tag.getKey().comp_327()))));
                if (++count < 7) continue;
                break;
            }
            for (int i = 0; i < sortedBiomeHolders.size(); ++i) {
                StructureEssentials.LOGGER.info("Weight:" + sortedBiomeHolders.get(i).getValue() + " Biome: " + String.valueOf(((class_5321)((class_6880)sortedBiomeHolders.get(i).getKey()).method_40229().left().get()).method_29177()));
            }
            for (Map.Entry<class_6862<class_1959>, Double> tag : sortedBiomeTagKeys) {
                StructureEssentials.LOGGER.info("Weight:" + Math.round(tag.getValue()) + " Tag: #" + String.valueOf(tag.getKey().comp_327()));
            }
            return 1;
        })));
    }

    public static List<Object2DoubleMap.Entry<class_6880<class_1959>>> getSimilarBiomesFor(class_6880<class_1959> biomeHolder, class_5455 registryAccess) {
        float f;
        List<Object2DoubleMap.Entry<class_6880<class_1959>>> result = biomeScoreCache.get(biomeHolder);
        if (result != null) {
            return result;
        }
        HashSet<Object> similarBiomes = new HashSet<Object>();
        Set biomeTags = biomeHolder.method_40228().collect(Collectors.toSet());
        for (Object currentBiome : ((class_2378)registryAccess.method_33310(class_7924.field_41236).get()).method_40295()) {
            for (class_6862 tag : biomeTags) {
                if (!currentBiome.method_40220(tag)) continue;
                similarBiomes.add(currentBiome);
            }
        }
        Object2DoubleOpenHashMap countMap = new Object2DoubleOpenHashMap();
        for (class_6880 class_68802 : similarBiomes) {
            if (class_68802.equals(biomeHolder)) continue;
            int matching = 0;
            for (class_6862 similarBiomeTagKey : class_68802.method_40228().toList()) {
                if (!biomeTags.contains(similarBiomeTagKey)) continue;
                ++matching;
            }
            double matchPct = (double)matching / (double)biomeTags.size();
            matchPct = 0.7 + 0.3 * matchPct;
            countMap.put((Object)class_68802, matchPct);
        }
        float orgTemperature = Command.getAdjustedTemp(biomeHolder);
        float f2 = f = ((class_1959)biomeHolder.comp_349()).method_48163() ? ((class_1959)biomeHolder.comp_349()).field_26393.comp_846() : 0.0f;
        class_1959.class_1963 orgPrecipitation = !((class_1959)biomeHolder.comp_349()).method_48163() ? class_1959.class_1963.field_9384 : (orgTemperature >= 0.15f ? class_1959.class_1963.field_9382 : class_1959.class_1963.field_9383);
        String orgName = ((class_5321)biomeHolder.method_40230().get()).method_29177().method_12832().toString();
        Optional orgMusic = ((class_1959)biomeHolder.comp_349()).method_24377().method_27345();
        int orgSkyColor = ((class_1959)biomeHolder.comp_349()).method_24377().method_30810();
        HashSet<class_6880> orgFeatures = new HashSet<class_6880>();
        for (class_6885 featureSet : ((class_1959)biomeHolder.comp_349()).method_30970().method_30983()) {
            for (class_6880 feature : featureSet) {
                orgFeatures.add(feature);
            }
        }
        List orgFlowerFeatures = ((class_1959)biomeHolder.comp_349()).method_30970().method_30982();
        class_5483 orgMobSettings = ((class_1959)biomeHolder.comp_349()).method_30966();
        for (Object2DoubleMap.Entry ratedHolderEntry : countMap.object2DoubleEntrySet()) {
            class_1959.class_1963 precipitation;
            if (((class_6880)ratedHolderEntry.getKey()).equals(biomeHolder)) continue;
            class_6880 ratedBiomeHolder = (class_6880)ratedHolderEntry.getKey();
            double modifier = 1.0;
            float temp = Command.getAdjustedTemp((class_6880<class_1959>)ratedBiomeHolder);
            class_1959.class_1963 class_19632 = !((class_1959)ratedBiomeHolder.comp_349()).method_48163() ? class_1959.class_1963.field_9384 : (precipitation = temp >= 0.15f ? class_1959.class_1963.field_9382 : class_1959.class_1963.field_9383);
            if (orgPrecipitation != precipitation) {
                modifier *= 0.7;
            } else {
                float downFallDiff = Math.abs(f - (((class_1959)ratedBiomeHolder.comp_349()).method_48163() ? ((class_1959)biomeHolder.comp_349()).field_26393.comp_846() : 0.0f));
                modifier *= 1.0 - 0.1 * (double)downFallDiff;
                float tempDiff = Math.abs(orgTemperature - Command.getAdjustedTemp((class_6880<class_1959>)ratedBiomeHolder));
                modifier *= 1.0 - Math.min(0.1, (double)tempDiff * 0.1);
            }
            if (ratedBiomeHolder.toString().contains(orgName)) {
                modifier *= 1.2;
            }
            if (orgMusic.isPresent()) {
                modifier = ((class_1959)ratedBiomeHolder.comp_349()).method_24377().method_27345().isPresent() && ((class_5195)((class_1959)ratedBiomeHolder.comp_349()).method_24377().method_27345().get()).method_27279().equals((Object)((class_5195)orgMusic.get()).method_27279()) ? (modifier *= 1.2) : (modifier *= 0.9);
            }
            if (((class_1959)ratedBiomeHolder.comp_349()).method_24377().method_30810() != orgSkyColor) {
                modifier *= 0.9;
            }
            int matchingFeatures = 0;
            int totalFeatures = 0;
            for (class_6885 featureSet : ((class_1959)ratedBiomeHolder.comp_349()).method_30970().method_30983()) {
                for (class_6880 feature : featureSet) {
                    ++totalFeatures;
                    if (!orgFeatures.contains(feature)) continue;
                    ++matchingFeatures;
                }
            }
            int missingFeatures = orgFeatures.size() - matchingFeatures;
            int additionalFeatures = totalFeatures - missingFeatures;
            modifier *= 1.0 - Math.min(0.1, 0.1 * ((double)(missingFeatures * 3) / (double)Math.max(1, orgFeatures.size())));
            modifier *= 1.0 - 0.05 * ((double)additionalFeatures / (double)Math.max(10, orgFeatures.size()));
            if (!orgFlowerFeatures.isEmpty()) {
                int missingFlowerFeatures = 0;
                for (class_2975 feature : orgFlowerFeatures) {
                    boolean foundFlowerFeature = false;
                    for (class_2975 existing : ((class_1959)ratedBiomeHolder.comp_349()).method_30970().method_30982()) {
                        if (!existing.equals((Object)feature)) continue;
                        foundFlowerFeature = true;
                        break;
                    }
                    if (foundFlowerFeature) continue;
                    ++missingFlowerFeatures;
                }
                modifier *= 1.0 - 0.1 * ((double)missingFlowerFeatures / (double)orgFlowerFeatures.size());
            }
            if (!orgMobSettings.field_26406.keySet().isEmpty()) {
                int missingMobs = 0;
                for (class_1299 type : orgMobSettings.field_26406.keySet()) {
                    if (((class_1959)ratedBiomeHolder.comp_349()).method_30966().field_26406.keySet().contains(type)) continue;
                    ++missingMobs;
                }
                modifier *= 1.0 - 0.2 * ((double)missingMobs / (double)orgMobSettings.field_26406.keySet().size());
            }
            if ((double)Math.abs(orgMobSettings.method_31002() - ((class_1959)ratedBiomeHolder.comp_349()).method_30966().method_31002()) > 0.1) {
                modifier *= 0.9;
            }
            ratedHolderEntry.setValue(ratedHolderEntry.getDoubleValue() * modifier);
        }
        ArrayList<Object2DoubleMap.Entry<class_6880<class_1959>>> sortedBiomeHolders = new ArrayList<Object2DoubleMap.Entry<class_6880<class_1959>>>((Collection<Object2DoubleMap.Entry<class_6880<class_1959>>>)countMap.object2DoubleEntrySet());
        sortedBiomeHolders.sort(Comparator.comparingDouble(e -> ((Object2DoubleMap.Entry)e).getDoubleValue()).reversed());
        biomeScoreCache.put(biomeHolder, sortedBiomeHolders);
        return sortedBiomeHolders;
    }

    public static List<Map.Entry<class_6862<class_1959>, Double>> getSimilarTagsFor(class_6880<class_1959> biomeHolder, class_5455 registryAccess) {
        List biomeTags = biomeHolder.method_40228().collect(Collectors.toList());
        List<Object2DoubleMap.Entry<class_6880<class_1959>>> sortedBiomeHolders = Command.getSimilarBiomesFor(biomeHolder, registryAccess);
        HashMap<class_6862, Double> tagCountMap = new HashMap<class_6862, Double>();
        int biomeCount = sortedBiomeHolders.size();
        for (int i = 0; i < sortedBiomeHolders.size(); ++i) {
            double weight = ((double)biomeCount / 6.0 - (double)i) / ((double)biomeCount / 6.0);
            if ((double)i > (double)biomeCount / 6.0) {
                weight = -((double)i - (double)biomeCount * 0.16666666666666666) / ((double)biomeCount * 0.8333333333333334);
            }
            Map.Entry biomeHolderEntry = (Map.Entry)sortedBiomeHolders.get(i);
            for (class_6862 biomeHolderEntryTag : ((class_6880)biomeHolderEntry.getKey()).method_40228().toList()) {
                if (!biomeTags.contains(biomeHolderEntryTag)) continue;
                tagCountMap.put(biomeHolderEntryTag, tagCountMap.getOrDefault(biomeHolderEntryTag, 0.0) + 1.0 * weight);
            }
        }
        ArrayList<Map.Entry<class_6862<class_1959>, Double>> sortedBiomeTagKeys = new ArrayList<Map.Entry<class_6862<class_1959>, Double>>(tagCountMap.entrySet());
        sortedBiomeTagKeys.sort(Comparator.comparingDouble(e -> (Double)((Map.Entry)e).getValue()).reversed());
        return sortedBiomeTagKeys;
    }

    public static float getAdjustedTemp(class_6880<class_1959> holder) {
        class_1959 biome = (class_1959)holder.comp_349();
        float temp = biome.method_8712();
        if (temp == 0.5f || temp == 0.8f) {
            String biomeString = ((class_5321)holder.method_40230().get()).method_29177().toString();
            if (biomeString.contains("hot") || biomeString.contains("warm") || biomeString.contains("desert")) {
                return 0.95f;
            }
            if (biomeString.contains("snowy") || biomeString.contains("cold") || biomeString.contains("frozen") || biomeString.contains("ice")) {
                return 0.0f;
            }
            return temp;
        }
        return temp;
    }

    private static class CustomEntry
    implements Object2IntMap.Entry<class_6880<class_1959>> {
        final class_6880<class_1959> holder;
        final int value;

        private CustomEntry(class_6880<class_1959> holder, int value) {
            this.holder = holder;
            this.value = value;
        }

        public int getIntValue() {
            return this.value;
        }

        public int setValue(int value) {
            throw new RuntimeException("Not Allowed to set value");
        }

        public class_6880<class_1959> getKey() {
            return this.holder;
        }
    }
}

