/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.fluid;

import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;

public class FluidTank {
    private final int capacity;
    private final int maxFill;
    private final int maxDrain;
    private class_3611 fluid = class_3612.field_15906;
    private int amount;

    public FluidTank(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public FluidTank(int capacity, int maxTransfer) {
        this(maxTransfer, capacity, maxTransfer, 0);
    }

    public FluidTank(int capacity, int maxFill, int maxDrain) {
        this(maxDrain, capacity, maxFill, 0);
    }

    public FluidTank(int maxDrain, int capacity, int maxFill, int amount) {
        this.capacity = capacity;
        this.maxFill = maxFill;
        this.maxDrain = maxDrain;
        this.amount = Math.max(0, Math.min(capacity, amount));
    }

    public int fill(class_3611 fluid, int maxFill, boolean simulate) {
        if (!this.canFill(fluid)) {
            return 0;
        }
        if (this.fluid.method_15780(class_3612.field_15906)) {
            this.fluid = fluid;
        }
        int filled = Math.min(this.capacity - this.amount, Math.min(this.maxFill, maxFill));
        if (!simulate) {
            this.amount += filled;
            this.setChanged();
        }
        return filled;
    }

    public int drain(class_3611 fluid, int maxDrain, boolean simulate) {
        if (!this.canDrain(fluid)) {
            return 0;
        }
        int drained = Math.min(this.amount, Math.min(this.maxDrain, maxDrain));
        if (!simulate) {
            this.amount -= drained;
            this.setChanged();
        }
        return drained;
    }

    public class_3611 getFluid() {
        return this.amount >= 0 ? this.fluid : class_3612.field_15906;
    }

    public void setFluid(class_3611 fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
        this.setChanged();
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean canDrain(class_3611 fluid) {
        return (this.fluid.method_15780(fluid) || this.fluid.method_15780(class_3612.field_15906)) && this.maxDrain > 0;
    }

    public boolean canFill(class_3611 fluid) {
        return (this.fluid.method_15780(fluid) || this.fluid.method_15780(class_3612.field_15906)) && this.maxFill > 0;
    }

    public boolean isEmpty() {
        return this.amount <= 0 || this.fluid.method_15780(class_3612.field_15906);
    }

    public class_2487 serialize() {
        class_2487 tag = new class_2487();
        tag.method_10582("Fluid", class_7923.field_41173.method_10221((Object)this.fluid).toString());
        tag.method_10569("Amount", this.amount);
        return tag;
    }

    public void deserialize(class_2487 tag) {
        this.fluid = (class_3611)class_7923.field_41173.method_10223(class_2960.method_12829((String)tag.method_10558("Fluid")));
        this.amount = tag.method_10550("Amount");
    }

    public void setChanged() {
    }
}

