/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.GuiGraphicsUtils;
import io.wispforest.accessories.client.gui.AccessoriesExperimentalScreen;
import io.wispforest.accessories.client.gui.components.ArrowComponent;
import io.wispforest.accessories.menu.SlotTypeAccessible;
import io.wispforest.accessories.menu.variants.AccessoriesExperimentalMenu;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.SyncCosmeticToggle;
import io.wispforest.accessories.pond.owo.ComponentExtension;
import io.wispforest.accessories.pond.owo.MutableBoundingArea;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.NinePatchTexture;
import io.wispforest.owo.ui.util.ScissorStack;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class ComponentUtils {
    private static final class_2960 SLOT = class_2960.method_60656((String)"textures/gui/sprites/container/slot.png");
    private static final class_2960 DARK_SLOT = Accessories.of("textures/gui/theme/dark/slot.png");
    public static final Surface BACKGROUND_SLOT_RENDERING_SURFACE = (context, component) -> {
        ArrayList slotComponents = new ArrayList();
        ComponentUtils.recursiveSearch(component, AccessoriesExperimentalScreen.ExtendedSlotComponent.class, slotComponents::add);
        context.push();
        context.translate((float)component.x(), (float)component.y(), 0.0f);
        GuiGraphicsUtils.batched((class_332)context, ComponentUtils.getSlotTexture(), slotComponents, (bufferBuilder, poseStack, slotComponent) -> GuiGraphicsUtils.blit(bufferBuilder, poseStack, slotComponent.x() - component.x() - 1, slotComponent.y() - component.y() - 1, 18));
        context.pop();
    };
    public static final ScrollContainer.Scrollbar VANILLA = (context, x, y, width, height, trackX, trackY, trackWidth, trackHeight, lastInteractTime, direction, active) -> {
        NinePatchTexture.draw((class_2960)Accessories.of("theme/" + ComponentUtils.checkMode("light", "dark") + "/scrollbar/track"), (OwoUIDrawContext)context, (int)trackX, (int)trackY, (int)trackWidth, (int)trackHeight);
        NinePatchTexture.draw((class_2960)ComponentUtils.getScrollabarTexture(direction, active), (OwoUIDrawContext)context, (int)(x + 1), (int)(y + 1), (int)(width - 2), (int)(height - 2));
    };
    public static final Surface PANEL_INSET = (context, component) -> NinePatchTexture.draw((class_2960)Accessories.of("theme/" + ComponentUtils.checkMode("light", "dark") + "/inset"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static final Surface PANEL = (context, component) -> NinePatchTexture.draw((class_2960)Accessories.of("theme/" + ComponentUtils.checkMode("light", "dark") + "/panel"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    private static final ButtonComponent.Renderer BUTTON_RENDERER = (context, button, delta) -> {
        RenderSystem.enableDepthTest();
        NinePatchTexture.draw((class_2960)ComponentUtils.getBtnTexture(button), (OwoUIDrawContext)context, (int)button.method_46426(), (int)button.method_46427(), (int)button.width(), (int)button.height());
    };

    public static class_2960 getScrollabarTexture(ScrollContainer.ScrollDirection direction, boolean active) {
        String scrollBarType = (direction == ScrollContainer.ScrollDirection.VERTICAL ? "vertical" : "horizontal") + (active ? "" : "_disabled");
        String themeType = ComponentUtils.checkMode("light", "dark");
        return Accessories.of("theme/" + themeType + "/scrollbar/vanilla_" + scrollBarType);
    }

    private static class_2960 getBtnTexture(ButtonComponent btn) {
        String btnType = btn.method_37303() ? (btn.method_49606() ? "hovered" : "active") : "disabled";
        String themeType = ComponentUtils.checkMode("light", "dark");
        return Accessories.of("theme/" + themeType + "/button/" + btnType);
    }

    public static <T> T checkMode(T lightMode, T darkMode) {
        return Accessories.config().screenOptions.isDarkMode() ? darkMode : lightMode;
    }

    public static class_2960 getSlotTexture() {
        return ComponentUtils.checkMode(SLOT, DARK_SLOT);
    }

    public static Surface getPanelSurface() {
        return PANEL;
    }

    public static Surface getInsetPanelSurface() {
        return PANEL_INSET;
    }

    public static Surface getPanelWithInset(int insetWidth) {
        return (context, component) -> {
            class_2960 location = Accessories.of("theme/" + ComponentUtils.checkMode("light", "dark") + "/inset");
            NinePatchTexture.draw((class_2960)location, (OwoUIDrawContext)context, (int)(component.x() + insetWidth), (int)(component.y() + insetWidth), (int)(component.width() - insetWidth * 2), (int)(component.height() - insetWidth * 2));
        };
    }

    public static ButtonComponent.Renderer getButtonRenderer() {
        return BUTTON_RENDERER;
    }

    public static ScrollContainer.Scrollbar getScrollbarRenderer() {
        return VANILLA;
    }

    public static <C extends Component> void recursiveSearch(ParentComponent parentComponent, Class<C> target, Consumer<C> action) {
        if (parentComponent == null) {
            return;
        }
        for (Component child : parentComponent.children()) {
            if (target.isInstance(child)) {
                action.accept(child);
            }
            if (!(child instanceof ParentComponent)) continue;
            ParentComponent childParent = (ParentComponent)child;
            ComponentUtils.recursiveSearch(childParent, target, action);
        }
    }

    public static <S extends class_1735> Pair<Component, PositionedRectangle> slotAndToggle(S slot, Function<Integer, AccessoriesExperimentalScreen.ExtendedSlotComponent> slotBuilder) {
        return ComponentUtils.slotAndToggle(slot, true, slotBuilder);
    }

    public static <S extends class_1735> Pair<Component, PositionedRectangle> slotAndToggle(S slot, boolean isBatched, Function<Integer, AccessoriesExperimentalScreen.ExtendedSlotComponent> slotBuilder) {
        Positioning btnPosition = Positioning.absolute((int)14, (int)-1);
        Component toggleBtn = ComponentUtils.slotToggleBtn(slot).configure(component -> component.zIndex(360).sizing(Sizing.fixed((int)5)).positioning(btnPosition));
        ((ComponentExtension)toggleBtn).allowIndividualOverdraw(true);
        FlowLayout combinedLayout = Containers.verticalFlow((Sizing)Sizing.fixed((int)18), (Sizing)Sizing.fixed((int)18)).child((Component)slotBuilder.apply(slot.field_7874).isBatched(isBatched).margins(Insets.of((int)1))).child(toggleBtn);
        MutableBoundingArea combinedArea = (MutableBoundingArea)combinedLayout;
        return Pair.of((Object)combinedLayout, (Object)toggleBtn);
    }

    public static <S extends class_1735> ButtonComponent slotToggleBtn(S slot) {
        return ComponentUtils.toggleBtn((class_2561)class_2561.method_43470((String)""), () -> ((SlotTypeAccessible)slot).getContainer().shouldRender(slot.method_34266()), btn -> {
            class_1309 entity = ((SlotTypeAccessible)slot).getContainer().capability().entity();
            AccessoriesNetworking.sendToServer(SyncCosmeticToggle.of(entity.equals((Object)class_310.method_1551().field_1724) ? null : entity, ((SlotTypeAccessible)slot).slotType(), slot.method_34266()));
        });
    }

    public static ButtonComponent groupToggleBtn(AccessoriesExperimentalScreen screen, SlotGroup group) {
        ButtonComponent btn = ComponentUtils.toggleBtn((class_2561)class_2561.method_43473(), () -> {
            AccessoriesExperimentalMenu menu = (AccessoriesExperimentalMenu)screen.method_17577();
            return menu.isGroupSelected(group);
        }, buttonComponent -> {
            AccessoriesExperimentalMenu menu = (AccessoriesExperimentalMenu)screen.method_17577();
            if (menu.isGroupSelected(group)) {
                menu.removeSelectedGroup(group);
            } else {
                menu.addSelectedGroup(group);
            }
            screen.rebuildAccessoriesComponent();
        }, (context, button, delta) -> {
            class_1058 textureAtlasSprite = (class_1058)class_310.method_1551().method_1549(class_2960.method_60656((String)"textures/atlas/gui.png")).apply(group.icon());
            Color color = Color.WHITE;
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)color.red(), (float)color.green(), (float)color.blue(), (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            context.method_48465(button.x() + 3, button.y() + 3, 2, 8, 8, textureAtlasSprite, color.red(), color.green(), color.blue(), 1.0f);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        ArrayList<class_5250> tooltipData = new ArrayList<class_5250>();
        tooltipData.add(class_2561.method_43471((String)group.translation()));
        if (UniqueSlotHandling.isUniqueGroup(group.name(), true)) {
            tooltipData.add(class_2561.method_43470((String)group.name()).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}));
        }
        btn.sizing(Sizing.fixed((int)14)).tooltip(tooltipData);
        return btn;
    }

    public static ButtonComponent toggleBtn(class_2561 message, Supplier<Boolean> stateSupplier, Consumer<ButtonComponent> onToggle) {
        return ComponentUtils.toggleBtn(message, stateSupplier, onToggle, (context, button, delta) -> {});
    }

    public static ButtonComponent toggleBtn(class_2561 message, Supplier<Boolean> stateSupplier, Consumer<ButtonComponent> onToggle, ButtonComponent.Renderer extraRendering) {
        ButtonComponent.Renderer texturedRenderer = (context, btn, delta) -> {
            ComponentExtension extension;
            RenderSystem.enableDepthTest();
            Boolean state = (Boolean)stateSupplier.get();
            class_2960 texture = ComponentUtils.getToggleBtnTexture(btn, state);
            context.push();
            Runnable drawCall = () -> {
                NinePatchTexture.draw((class_2960)texture, (OwoUIDrawContext)context, (int)btn.method_46426(), (int)btn.method_46427(), (int)btn.width(), (int)btn.height());
                extraRendering.draw(context, btn, delta);
            };
            if (btn instanceof ComponentExtension && (extension = (ComponentExtension)btn).allowIndividualOverdraw()) {
                ScissorStack.popFramesAndDraw((int)7, (Runnable)drawCall);
            } else {
                drawCall.run();
            }
            context.pop();
        };
        return Components.button((class_2561)message, onToggle).renderer(texturedRenderer);
    }

    private static class_2960 getToggleBtnTexture(ButtonComponent btn, Boolean state) {
        String btnType = (state != false ? "enabled" : "disabled") + (btn.method_49606() ? "_hovered" : "");
        String themeType = ComponentUtils.checkMode("light", "dark");
        return Accessories.of("theme/" + themeType + "/button/toggle/rounded/" + btnType);
    }

    public static <C extends BaseOwoHandledScreen.SlotComponent> Component createCraftingComponent(int start, int end, Function<Integer, C> componentFactory, Consumer<Integer> slotEnabler, boolean isVertical) {
        FlowLayout craftingLayout = isVertical ? Containers.verticalFlow((Sizing)Sizing.fixed((int)36), (Sizing)Sizing.content()) : Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)36));
        slotEnabler.accept(0);
        slotEnabler.accept(1);
        slotEnabler.accept(2);
        slotEnabler.accept(3);
        slotEnabler.accept(4);
        craftingLayout.configure(layout -> layout.allowOverflow(true));
        ArrayList<Object> childrenList = new ArrayList<Object>();
        childrenList.add((!isVertical ? Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()) : Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content())).child((Component)((BaseOwoHandledScreen.SlotComponent)componentFactory.apply(start + 1)).margins(Insets.of((int)1))).child((Component)((BaseOwoHandledScreen.SlotComponent)componentFactory.apply(start + 2)).margins(Insets.of((int)1))));
        childrenList.add((!isVertical ? Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()) : Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content())).child((Component)((BaseOwoHandledScreen.SlotComponent)componentFactory.apply(start + 3)).margins(Insets.of((int)1))).child((Component)((BaseOwoHandledScreen.SlotComponent)componentFactory.apply(start + 4)).margins(Insets.of((int)1))));
        childrenList.add(new ArrowComponent(isVertical ? ArrowComponent.Direction.DOWN : ArrowComponent.Direction.RIGHT).centered(true).margins(Insets.of((int)3, (int)3, (int)1, (int)1)).id("crafting_arrow"));
        childrenList.add((!isVertical ? Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.expand()) : Containers.horizontalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content())).child((Component)((BaseOwoHandledScreen.SlotComponent)componentFactory.apply(start)).margins(Insets.of((int)1))).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER));
        craftingLayout.children(childrenList).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        return craftingLayout;
    }

    public static <C extends BaseOwoHandledScreen.SlotComponent> Component createPlayerInv(int start, int end, Function<Integer, C> componentFactory, Consumer<Integer> slotEnabler) {
        FlowLayout playerLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        int row = 0;
        FlowLayout rowLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> layout.allowOverflow(true));
        int rowCount = 0;
        for (int i = start; i < end; ++i) {
            BaseOwoHandledScreen.SlotComponent slotComponent = (BaseOwoHandledScreen.SlotComponent)componentFactory.apply(i);
            slotEnabler.accept(i);
            rowLayout.child((Component)slotComponent.margins(Insets.of((int)1)));
            if (row >= 8) {
                playerLayout.child((Component)rowLayout);
                rowLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> layout.allowOverflow(true));
                if (++rowCount == 3) {
                    rowLayout.margins(Insets.top((int)4));
                }
                row = 0;
                continue;
            }
            ++row;
        }
        return playerLayout.allowOverflow(true);
    }

    public static interface OnCreativeTabChange {
        public void onTabChange(class_1761 var1);
    }

    public static interface CreativeScreenExtension {
        public Event<OnCreativeTabChange> getEvent();

        public class_1761 getTab();
    }
}

