/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.infoScreen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8662;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.faewulf.lib.util.config.Config;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;
import xyz.faewulf.lib.util.config.infoScreen.rainITem;

public class ModInfoScreen
extends class_437 {
    private final String MOD_ID;
    private final class_2960 MAIN_IMAGE;
    private final class_2960 LIGHT_RAYS;
    private final class_437 parent;
    private final class_310 client;
    private final List<rainITem> fallingEntities = new ArrayList<rainITem>();
    public final class_2960 ATLAS_TEXTURE;
    private final int ATLAS_SIZE = 96;
    private final int TILE_SIZE = 32;
    private int[][] tileMap;
    private int tilesX;
    private int tilesY;
    private final float logo_offset_Y = 20.0f;
    private final class_2960 ICON_DISCORD;
    private final class_2960 ICON_KOFI;
    private final class_2960 ICON_GITHUB;
    private String URL_GITHUB = "https://github.com/FaeWulf";
    private String URL_WEBSITE = "https://faewulf.xyz/";
    private String URL_DONATE = "https://ko-fi.com/faewulf";
    private String URL_DISCORD = "https://faewulf.xyz/discord";
    private final class_8132 layout = new class_8132((class_437)this, 100, 60);
    private class_7845 contentLayout;
    private class_7845 footerLayout;
    private class_4185 settingButton;
    private float time = 0.0f;

    protected ModInfoScreen(class_437 parent, String MOD_ID) {
        super((class_2561)class_2561.method_43470((String)"Info"));
        this.parent = parent;
        this.client = class_310.method_1551();
        this.tilesX = (int)Math.ceil((float)this.field_22789 * 1.0f / 32.0f);
        this.tilesY = (int)Math.ceil((float)this.field_22790 * 1.0f / 32.0f);
        this.tileMap = new int[this.tilesX][this.tilesY];
        this.MOD_ID = MOD_ID;
        this.MAIN_IMAGE = class_2960.method_43902((String)MOD_ID, (String)"textures/gui/d.png");
        this.LIGHT_RAYS = class_2960.method_43902((String)MOD_ID, (String)"textures/gui/light_rays.png");
        this.ATLAS_TEXTURE = class_2960.method_43902((String)MOD_ID, (String)"textures/gui/atlas_background.png");
        this.ICON_DISCORD = class_2960.method_43902((String)MOD_ID, (String)"icon/discord");
        this.ICON_KOFI = class_2960.method_43902((String)MOD_ID, (String)"icon/kofi");
        this.ICON_GITHUB = class_2960.method_43902((String)MOD_ID, (String)"icon/github");
    }

    public static ModInfoScreen getScreen(class_437 parent, String MOD_ID) {
        return new ModInfoScreen(parent, MOD_ID);
    }

    public void setUrls(@Nullable String discord, @Nullable String website, @Nullable String donate, @Nullable String sourcecode) {
        if (discord != null) {
            this.URL_DISCORD = discord;
        }
        if (sourcecode != null) {
            this.URL_GITHUB = sourcecode;
        }
        if (website != null) {
            this.URL_WEBSITE = website;
        }
        if (donate != null) {
            this.URL_DONATE = donate;
        }
    }

    protected void method_25426() {
        this.generateRandomTileMap();
        Config.reloadConfig(this.MOD_ID);
        for (int i = 0; i < 25; ++i) {
            int texture = i % 9;
            float x = (float)(Math.random() * (double)this.field_22789);
            float y = (float)(Math.random() * (double)this.field_22790);
            float velocityX = (float)(Math.random() * 1.0) - 0.5f;
            float velocityY = 1.0f + (float)(Math.random() * 1.0);
            float rotationSpeed = (float)(Math.random() * 14.0 - 7.0);
            this.fallingEntities.add(new rainITem(texture, x, y, velocityX, velocityY, rotationSpeed, this.field_22789, this.field_22790));
        }
        this.contentLayout = new class_7845();
        this.footerLayout = new class_7845();
        class_7845.class_7939 rowHelper = this.contentLayout.method_47610(1);
        rowHelper.method_47616().method_46464(4).method_46467();
        this.settingButton = (class_4185)rowHelper.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)(this.MOD_ID + ".info.configurations")), button -> this.client.method_1507(ConfigScreen.getScreen(this, this.MOD_ID))).method_46431());
        if (ConfigLoaderFromAnnotation.loadConfig(this.MOD_ID).isEmpty()) {
            this.settingButton.field_22763 = false;
        }
        class_7845.class_7939 rowHelperFooterLayout = this.footerLayout.method_47610(5);
        rowHelperFooterLayout.method_47616().method_46467().method_46464(2);
        rowHelperFooterLayout.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83c\udf10"), button -> this.openWebLink(this.URL_WEBSITE)).method_46432(20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)(this.MOD_ID + ".info.website.tooltip")))).method_46431());
        class_8662 iconButton = class_8662.method_52723((class_2561)class_2561.method_43470((String)"Kofi").method_27692(class_124.field_1061), button -> this.openWebLink(this.URL_DONATE), (boolean)true).method_52726(20, 20).method_52727(this.ICON_KOFI, 20, 20).method_52724();
        iconButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)(this.MOD_ID + ".info.kofi.tooltip"))));
        rowHelperFooterLayout.method_47613((class_8021)iconButton, 1);
        rowHelperFooterLayout.method_47613((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.method_25419()).method_46432(100).method_46431(), 1);
        iconButton = class_8662.method_52723((class_2561)class_2561.method_43470((String)"Discord").method_27692(class_124.field_1078), button -> this.openWebLink(this.URL_DISCORD), (boolean)true).method_52726(20, 20).method_52727(this.ICON_DISCORD, 16, 16).method_52724();
        iconButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)(this.MOD_ID + ".info.discord.tooltip"))));
        rowHelperFooterLayout.method_47613((class_8021)iconButton, 1);
        iconButton = class_8662.method_52723((class_2561)class_2561.method_43470((String)"Github"), button -> this.openWebLink(this.URL_GITHUB), (boolean)true).method_52726(20, 20).method_52727(this.ICON_GITHUB, 16, 16).method_52724();
        iconButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)(this.MOD_ID + ".info.github.tooltip"))));
        rowHelperFooterLayout.method_47613((class_8021)iconButton, 1);
        this.layout.method_48999((class_8021)this.contentLayout);
        this.layout.method_48996((class_8021)this.footerLayout);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    public void method_25393() {
        super.method_25393();
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public void method_25420(@NotNull class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.drawRandomTiledBackground(guiGraphics);
        this.randomShtShowering(guiGraphics, pPartialTick);
        guiGraphics.method_25296(0, 0, this.field_22789, this.field_22790, -1442840576, Integer.MIN_VALUE);
        this.time += pPartialTick * 0.05f;
        this.drawLightRays(guiGraphics);
        this.drawWobblingImage(guiGraphics);
    }

    private void drawLightRays(class_332 guiGraphics) {
        int centerX = this.field_22789 / 2;
        int centerY = (int)(((float)this.layout.method_48998() + 20.0f) / 2.0f);
        int size = 128;
        float rotationAngle = this.time * 20.0f;
        class_4587 matrixStack = guiGraphics.method_51448();
        matrixStack.method_22903();
        float wobbleOffsetY = (float)Math.sin(this.time) * 5.0f;
        matrixStack.method_46416((float)centerX, (float)centerY + wobbleOffsetY, 0.0f);
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(rotationAngle));
        guiGraphics.method_51448().method_46416((float)(-size) / 2.0f, (float)(-size) / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25290(this.LIGHT_RAYS, 0, 0, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.disableBlend();
        matrixStack.method_22909();
    }

    private void drawWobblingImage(class_332 guiGraphics) {
        int imageSize = 64;
        int centerX = this.field_22789 / 2;
        int centerY = (int)(((float)this.layout.method_48998() + 20.0f) / 2.0f);
        float wobbleOffsetY = (float)Math.sin(this.time) * 5.0f;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)centerX, (float)centerY + wobbleOffsetY, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25290(this.MAIN_IMAGE, -imageSize / 2, -imageSize / 2, 0.0f, 0.0f, imageSize, imageSize, imageSize, imageSize);
        RenderSystem.disableBlend();
        guiGraphics.method_51448().method_22909();
    }

    protected void method_48640() {
        this.tilesX = (int)Math.ceil((float)this.field_22789 * 1.0f / 32.0f);
        this.tilesY = (int)Math.ceil((float)this.field_22790 * 1.0f / 32.0f);
        this.tileMap = new int[this.tilesX][this.tilesY];
        this.generateRandomTileMap();
        this.layout.method_48222();
        this.fallingEntities.forEach(rainITem2 -> rainITem2.updateScreenSize(this.field_22789, this.field_22790));
    }

    public void method_25419() {
        if (this.client != null) {
            this.client.method_1507(this.parent);
        } else {
            super.method_25419();
        }
    }

    private void randomShtShowering(class_332 guiGraphics, float delta) {
        for (rainITem entity : this.fallingEntities) {
            entity.update(delta);
            entity.render(guiGraphics, delta);
        }
    }

    private void drawRandomTiledBackground(class_332 guiGraphics) {
        int tilesPerRow = 3;
        for (int y = 0; y < this.tilesY; ++y) {
            for (int x = 0; x < this.tilesX; ++x) {
                int tileIndex = this.tileMap[x][y];
                int tileX = tileIndex % tilesPerRow * 32;
                int tileY = tileIndex / tilesPerRow * 32;
                guiGraphics.method_25290(this.ATLAS_TEXTURE, x * 32, y * 32, (float)tileX, (float)tileY, 32, 32, 96, 96);
            }
        }
    }

    private void generateRandomTileMap() {
        Random random = new Random();
        int tilesPerRow = 3;
        for (int y = 0; y < this.tilesY; ++y) {
            for (int x = 0; x < this.tilesX; ++x) {
                int tileX = random.nextInt(tilesPerRow);
                int tileY = random.nextInt(tilesPerRow);
                this.tileMap[x][y] = tileY * tilesPerRow + tileX;
            }
        }
    }

    private void openWebLink(String url) {
        this.client.method_1507((class_437)new class_407(confirmed -> {
            if (confirmed) {
                class_156.method_668().method_670(url);
            }
            this.client.method_1507((class_437)this);
        }, url, true));
    }
}

