/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.Compare;

public class ItemTagRegistry {
    private static final List<String> BASE_PATHS = new ArrayList<String>();
    private static final Map<String, List<class_1792>> TYPE_TO_ITEMS_MAP = new HashMap<String, List<class_1792>>();

    public static void add(String path) {
        BASE_PATHS.add(path);
    }

    public static void loadAllItemTags() {
        TYPE_TO_ITEMS_MAP.clear();
        try {
            for (String basePath : BASE_PATHS) {
                class_310.method_1551().method_1478().method_14488(basePath, path -> path.toString().endsWith(".json")).forEach((location, resource) -> {
                    try {
                        InputStreamReader reader = new InputStreamReader(resource.method_14482());
                        JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        reader.close();
                        String type = basePath + ":" + json.get("type").getAsString();
                        JsonArray itemsArray = json.getAsJsonArray("items");
                        List<class_1792> itemList = ItemTagRegistry.parseItemsArray(itemsArray);
                        TYPE_TO_ITEMS_MAP.putIfAbsent(type, new ArrayList());
                        TYPE_TO_ITEMS_MAP.get(type).addAll(itemList);
                    }
                    catch (Exception e) {
                        Constants.LOG.error("Opps something went wrong!");
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Exception e) {
            Constants.LOG.error("Opps something went wrong!");
            e.printStackTrace();
        }
    }

    private static List<class_1792> parseItemsArray(JsonArray itemsArray) {
        ArrayList<class_1792> itemList = new ArrayList<class_1792>();
        for (JsonElement element : itemsArray) {
            class_1792 item2;
            String itemString = element.getAsString();
            if (itemString.startsWith("#")) {
                String tagId = itemString.substring(1);
                class_7923.field_41178.method_10220().forEach(item -> {
                    if (Compare.isHasTag(item, tagId)) {
                        itemList.add((class_1792)item);
                    }
                });
                continue;
            }
            class_2960 itemResource = class_2960.method_12829((String)itemString);
            if (itemResource == null || (item2 = (class_1792)class_7923.field_41178.method_10223(itemResource)) == class_1802.field_8162) continue;
            itemList.add(item2);
        }
        return itemList;
    }

    public static Map<String, List<class_1792>> getTypeToItemsMap() {
        return TYPE_TO_ITEMS_MAP;
    }
}

