/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.platform.registry;

import io.github.flemmli97.tenshilib.platform.registry.PlatformRegistry;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import io.github.flemmli97.tenshilib.platform.registry.VanillaEntrySupplier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class VanillaRegistryHandler<T>
implements PlatformRegistry<T> {
    private final class_5321<? extends class_2378<T>> key;
    private final String modid;
    private final Map<VanillaEntrySupplier<T, ? extends T>, Supplier<? extends T>> entries = new LinkedHashMap<VanillaEntrySupplier<T, ? extends T>, Supplier<? extends T>>();
    private final Set<VanillaEntrySupplier<T, ? extends T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());

    public VanillaRegistryHandler(class_5321<? extends class_2378<T>> key, String modid) {
        this.key = key;
        this.modid = modid;
    }

    @Override
    public <I extends T> RegistryEntrySupplier<T, I> register(String name, Supplier<I> sup) {
        class_2960 id = class_2960.method_60655((String)this.modid, (String)name);
        VanillaEntrySupplier v = new VanillaEntrySupplier(id);
        this.entries.putIfAbsent(v, sup);
        return v;
    }

    @Override
    public void registerContent() {
        class_2378 registry = this.registryFrom();
        this.entries.forEach((v, s) -> {
            class_2378.method_10230((class_2378)registry, (class_2960)v.getID(), s.get());
            v.updateValue(registry);
        });
    }

    protected class_2378<T> registryFrom() {
        class_2378 reg = (class_2378)class_7923.field_41167.method_10223(this.key.method_29177());
        if (reg == null) {
            throw new NullPointerException("Failed to get a corresponding registry for " + String.valueOf(this.key));
        }
        return reg;
    }

    @Override
    public Collection<? extends RegistryEntrySupplier<T, ? extends T>> getEntries() {
        return this.entriesView;
    }
}

