/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import io.github.flemmli97.tenshilib.common.utils.CircleSector;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RayTraceUtils {
    public static List<class_1297> getEntities(class_1309 entity, float reach, float aoe) {
        return RayTraceUtils.getEntities(entity, reach, aoe, null);
    }

    public static List<class_1297> getEntities(class_1309 entity, float reach, float aoe, Predicate<class_1297> pred) {
        return RayTraceUtils.getEntitiesIn(entity, entity.method_19538().method_1031(0.0, (double)entity.method_5751(), 0.0), entity.method_5828(1.0f), reach, aoe, pred);
    }

    public static List<class_1297> getEntitiesIgnorePitch(class_1309 entity, float reach, float aoe, Predicate<class_1297> pred) {
        return RayTraceUtils.getEntitiesIn(entity, entity.method_19538().method_1031(0.0, 0.1, 0.0), class_243.method_1030((float)0.0f, (float)entity.method_5705(1.0f)), reach, aoe, pred);
    }

    public static List<class_1297> getEntitiesIn(class_1309 entity, class_243 pos, class_243 look, float reach, float aoe, Predicate<class_1297> pred) {
        CircleSector circ = new CircleSector(pos, look, reach, aoe, (class_1297)entity);
        return entity.method_37908().method_8333((class_1297)entity, entity.method_5829().method_1014((double)(reach + 1.0f)), t -> t != entity && (pred == null || pred.test((class_1297)t)) && !t.method_5722((class_1297)entity) && t.method_5863() && circ.intersects(t.method_37908(), t.method_5829().method_1009(0.15, (double)t.method_17682() <= 0.3 ? (double)t.method_17682() : 0.15, 0.15)));
    }

    public static class_3966 calculateEntityFromLook(class_1309 entity, float reach) {
        return RayTraceUtils.calculateEntityFromLook(entity, entity.method_5836(1.0f), entity.method_5828(1.0f), reach, null);
    }

    public static class_3966 calculateEntityFromLook(class_1309 entity, class_243 pos, class_243 dir, float reach, @Nullable Predicate<class_1297> pred) {
        class_243 loc;
        double dist;
        class_243 scaledDir = dir.method_1021((double)reach);
        class_3966 result = RayTraceUtils.rayTraceEntities(entity.method_37908(), (class_1297)entity, pos, pos.method_1019(scaledDir), entity.method_5829().method_18804(scaledDir).method_1014(1.0), t -> class_1301.field_6155.test(t) && t.method_5863() && (pred == null || pred.test((class_1297)t)), class_1297::method_5871);
        if (result != null && (dist = pos.method_1025(loc = result.method_17784())) <= (double)(reach * reach)) {
            return result;
        }
        return null;
    }

    @Nullable
    public static class_2338 randomPosAround(class_1937 world, class_1297 e, class_2338 pos, int range, boolean grounded, Random rand) {
        int randX = pos.method_10263() + rand.nextInt(2 * range) - range;
        int randY = pos.method_10264() + rand.nextInt(2 * range) - range;
        int randZ = pos.method_10260() + rand.nextInt(2 * range) - range;
        if (!grounded) {
            class_2338 pos1 = new class_2338(randX, randY, randZ);
            while (Math.abs(randY - pos1.method_10264()) < range && !world.method_18026(e.method_5829().method_996(pos1))) {
                pos1 = pos1.method_10084();
            }
            if (!world.method_18026(e.method_5829().method_996(pos1))) {
                return null;
            }
            return pos1;
        }
        int y = pos.method_10264() - range;
        class_2338 pos1 = new class_2338(randX, y, randZ);
        while (!(pos1.method_10264() - y >= range || world.method_8320(pos1.method_10074()).method_26169((class_1922)world, pos1.method_10074(), e, class_2350.field_11036) && world.method_18026(e.method_5829().method_996(pos1)))) {
            pos1 = pos1.method_10084();
        }
        if (!world.method_18026(e.method_5829().method_996(pos1))) {
            return null;
        }
        return pos1;
    }

    public static class_239 entityRayTrace(class_1297 e, float range, class_3959.class_3960 blockMode, class_3959.class_242 fluidMode, boolean includeEntities, boolean getEntityHitVec, @Nullable Predicate<class_1297> pred) {
        class_243 posEye = e.method_5836(1.0f);
        class_243 dir = e.method_5720().method_1021((double)range);
        class_243 lookPos = posEye.method_1019(dir);
        if (includeEntities) {
            class_3966 entityHitResult;
            class_3965 raytraceresult = e.method_37908().method_17742(new class_3959(posEye, lookPos, blockMode, fluidMode, e));
            if (raytraceresult.method_17783() != class_239.class_240.field_1333) {
                lookPos = raytraceresult.method_17784();
            }
            if ((entityHitResult = getEntityHitVec ? RayTraceUtils.rayTraceEntities(e.method_37908(), e, posEye, lookPos, e.method_5829().method_18804(dir).method_1014(1.0), pred, ent -> Float.valueOf(0.3f)) : class_1675.method_18077((class_1937)e.method_37908(), (class_1297)e, (class_243)posEye, (class_243)lookPos, (class_238)e.method_5829().method_18804(dir).method_1014(1.0), pred == null ? entity -> true : pred)) != null) {
                raytraceresult = entityHitResult;
            }
            return raytraceresult;
        }
        return e.method_37908().method_17742(new class_3959(posEye, lookPos, blockMode, fluidMode, e));
    }

    @Nullable
    public static class_3966 rayTraceEntities(class_1297 e, class_243 from, class_243 to, Predicate<class_1297> pred) {
        return RayTraceUtils.rayTraceEntities(e.method_37908(), e, from, to, e.method_5829().method_18804(e.method_18798()).method_1014(1.0), pred, ent -> Float.valueOf(0.3f));
    }

    @Nullable
    public static class_3966 rayTraceEntities(class_1937 world, class_1297 e, class_243 from, class_243 to, class_238 aabb, Predicate<class_1297> pred, Function<class_1297, Float> inflateRadius) {
        double d0 = Double.MAX_VALUE;
        class_1297 entity = null;
        class_243 hit = null;
        for (class_1297 entity1 : world.method_8333(e, aabb, pred)) {
            class_238 axisalignedbb = entity1.method_5829().method_1014((double)inflateRadius.apply(entity1).floatValue());
            if (axisalignedbb.method_1006(from)) {
                entity = entity1;
                hit = from;
                if (axisalignedbb.method_1006(to)) break;
                hit = axisalignedbb.method_992(from, to).orElse(from);
                break;
            }
            Optional optional = axisalignedbb.method_992(from, to);
            if (!optional.isPresent()) continue;
            if (d0 == 0.0) {
                entity = entity1;
                hit = (class_243)optional.get();
                break;
            }
            double d1 = from.method_1025((class_243)optional.get());
            if (!(d1 < d0)) continue;
            entity = entity1;
            d0 = d1;
            hit = (class_243)optional.get();
        }
        return entity == null ? null : new class_3966(entity, hit);
    }

    public static class_3966 projectileRayTrace(class_1937 world, class_1297 entity, class_243 from, class_243 to, class_238 check, Predicate<class_1297> pred, double radius) {
        double distVar = Double.MAX_VALUE;
        class_1297 ret = null;
        from = from.method_1031(0.0, (double)entity.method_17682() * 0.5, 0.0);
        class_243 dir = to.method_1020(from);
        class_238 entityBB = entity.method_5829();
        for (class_1297 entity1 : world.method_8333(entity, check, pred)) {
            class_238 axisalignedbb = entity1.method_5829().method_1014((double)0.3f);
            Pair<class_243, class_243> points = MathUtils.closestPointsAABB(entityBB, axisalignedbb);
            double dist = ((class_243)points.getLeft()).method_1025((class_243)points.getRight());
            if (!(dist < distVar) || !(dist <= radius * radius) || radius != 0.0 && !MathUtils.isInFront(entity1.method_19538(), from, dir)) continue;
            ret = entity1;
            distVar = dist;
        }
        return ret == null ? null : new class_3966(ret);
    }

    public static List<Vector3f> rotatedVecs(class_243 dir, class_243 axis, float minDeg, float maxDeg, float step) {
        float y;
        ArrayList<Vector3f> list = new ArrayList<Vector3f>();
        Vector3f axisf = new Vector3f((float)axis.field_1352, (float)axis.field_1351, (float)axis.field_1350);
        list.add(new Vector3f((float)dir.field_1352, (float)dir.field_1351, (float)dir.field_1350));
        for (y = step; y <= maxDeg; y += step) {
            list.add(RayTraceUtils.rotatedAround(dir, axisf, y));
        }
        for (y = minDeg; y <= -step; y += step) {
            list.add(RayTraceUtils.rotatedAround(dir, axisf, y));
        }
        return list;
    }

    public static Vector3f rotatedAround(class_243 dir, Vector3f axis, float deg) {
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f((float)Math.PI / 180 * deg, (Vector3fc)axis));
        Vector3f newDir = new Vector3f((float)dir.field_1352, (float)dir.field_1351, (float)dir.field_1350);
        newDir.rotate((Quaternionfc)quaternion);
        return newDir;
    }
}

