/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Pair;

public class MathUtils {
    public static final class_243 NORMAL_X = new class_243(1.0, 0.0, 0.0);
    public static final class_243 NORMAL_Y = new class_243(0.0, 1.0, 0.0);
    public static final class_243 NORMAL_Z = new class_243(0.0, 0.0, 1.0);

    public static float degToRad(float degree) {
        return degree * ((float)Math.PI / 180);
    }

    public static float radToDeg(float rad) {
        return rad * 57.295776f;
    }

    public static double[] closestOnCircle(double centerX, double centerY, double pointX, double pointY, double radius) {
        double x = pointX - centerX;
        double y = pointY - centerY;
        double d0 = Math.sqrt(x * x + y * y);
        return new double[]{x / d0 * radius + centerX, y / d0 * radius + centerY};
    }

    public static double phiFromPoint(double centerX, double centerY, double pointX, double pointY) {
        return Math.atan2(pointY - centerY, pointX - centerX);
    }

    public static List<float[]> pointsOfCircle(float radius, int density) {
        float rad = MathUtils.degToRad(density);
        float i = -rad;
        ArrayList<float[]> list = new ArrayList<float[]>();
        while ((double)i < Math.PI * 2) {
            list.add(new float[]{radius * class_3532.method_15362((float)(i += rad)), radius * class_3532.method_15374((float)i)});
        }
        return list;
    }

    public static class_243 rotate(class_243 rotAxis, class_243 vec, float angle) {
        double[] res = MathUtils.rotate(rotAxis.field_1352, rotAxis.field_1351, rotAxis.field_1350, vec.field_1352, vec.field_1351, vec.field_1350, angle);
        return new class_243(res[0], res[1], res[2]);
    }

    public static double[] rotate(double axisX, double axisY, double axisZ, double vecX, double vecY, double vecZ, float angle) {
        double rot = axisX * vecX + axisY * vecY + axisZ * vecZ;
        double x = axisX * rot * (double)(1.0f - class_3532.method_15362((float)angle)) + vecX * (double)class_3532.method_15362((float)angle) + (-axisZ * vecY + axisY * vecZ) * (double)class_3532.method_15374((float)angle);
        double y = axisY * rot * (double)(1.0f - class_3532.method_15362((float)angle)) + vecY * (double)class_3532.method_15362((float)angle) + (axisZ * vecX - axisX * vecZ) * (double)class_3532.method_15374((float)angle);
        double z = axisZ * rot * (double)(1.0f - class_3532.method_15362((float)angle)) + vecZ * (double)class_3532.method_15362((float)angle) + (-axisY * vecX + axisX * vecY) * (double)class_3532.method_15374((float)angle);
        return new double[]{x, y, z};
    }

    public static float[] rotate(float axisX, float axisY, float axisZ, float vecX, float vecY, float vecZ, float angle) {
        float rot = axisX * vecX + axisY * vecY + axisZ * vecZ;
        float x = axisX * rot * (1.0f - class_3532.method_15362((float)angle)) + vecX * class_3532.method_15362((float)angle) + (-axisZ * vecY + axisY * vecZ) * class_3532.method_15374((float)angle);
        float y = axisY * rot * (1.0f - class_3532.method_15362((float)angle)) + vecY * class_3532.method_15362((float)angle) + (axisZ * vecX - axisX * vecZ) * class_3532.method_15374((float)angle);
        float z = axisZ * rot * (1.0f - class_3532.method_15362((float)angle)) + vecZ * class_3532.method_15362((float)angle) + (-axisY * vecX + axisX * vecY) * class_3532.method_15374((float)angle);
        return new float[]{x, y, z};
    }

    public static class_243 closestPointToLine(class_243 point, class_243 from, class_243 dir) {
        if (dir.equals((Object)class_243.field_1353)) {
            return from;
        }
        double lengthSq = dir.method_1027();
        double x = Math.max(0.0, Math.min(1.0, point.method_1020(from).method_1026(dir) / lengthSq));
        return from.method_1019(dir.method_1021(x));
    }

    public static double[] rotate2d(double x, double y, double angle) {
        return new double[]{x * Math.cos(angle) - y * Math.sin(angle), y * Math.cos(angle) + x * Math.sin(angle)};
    }

    public static double[][] createRegularPolygonPoints(int shape, float width) {
        if (shape <= 2) {
            throw new IllegalArgumentException("Can't create a polygon with 2 or less corners!");
        }
        double[][] res = new double[shape][];
        class_243 base = new class_243((double)width, 0.0, 0.0);
        float rotatePer = 360.0f / (float)shape;
        class_243 axis = new class_243(0.0, 0.0, 1.0);
        if (shape % 2 == 0) {
            base = MathUtils.rotate(axis, base, MathUtils.degToRad(rotatePer * 0.5f));
        }
        res[0] = new double[]{base.field_1352, base.field_1351};
        float angle = rotatePer;
        for (int i = 1; i < shape; ++i) {
            class_243 rotated = MathUtils.rotate(axis, base, MathUtils.degToRad(angle));
            angle += rotatePer;
            res[i] = new double[]{rotated.field_1352, rotated.field_1351, rotated.field_1350};
        }
        return res;
    }

    public static float[][] createRegularPolygonPointsF(int shape, float width) {
        if (shape <= 2) {
            throw new IllegalArgumentException("Can't create a polygon with 2 or less corners!");
        }
        float[][] res = new float[shape][];
        class_243 base = new class_243((double)width, 0.0, 0.0);
        float rotatePer = 360.0f / (float)shape;
        class_243 axis = new class_243(0.0, 0.0, 1.0);
        if (shape % 2 == 0) {
            base = MathUtils.rotate(axis, base, MathUtils.degToRad(rotatePer * 0.5f));
        }
        res[0] = new float[]{(float)base.field_1352, (float)base.field_1351};
        float angle = rotatePer;
        for (int i = 1; i < shape; ++i) {
            class_243 rotated = MathUtils.rotate(axis, base, MathUtils.degToRad(angle));
            angle += rotatePer;
            res[i] = new float[]{(float)rotated.field_1352, (float)rotated.field_1351};
        }
        return res;
    }

    public static boolean isInFront(class_243 pos, class_243 from, class_243 dir) {
        return from.method_1019(dir).method_1025(pos) < from.method_1020(dir).method_1025(pos);
    }

    public static Pair<class_243, class_243> closestPointsAABB(class_238 axisalignedbb, class_238 axisalignedbb2) {
        class_243 first = new class_243(axisalignedbb.field_1323 <= axisalignedbb2.field_1323 ? axisalignedbb2.field_1323 : (axisalignedbb.field_1320 >= axisalignedbb2.field_1320 ? axisalignedbb2.field_1320 : axisalignedbb.field_1323), axisalignedbb.field_1322 <= axisalignedbb2.field_1322 ? axisalignedbb2.field_1322 : (axisalignedbb.field_1325 >= axisalignedbb2.field_1325 ? axisalignedbb2.field_1325 : axisalignedbb.field_1322), axisalignedbb.field_1321 <= axisalignedbb2.field_1321 ? axisalignedbb2.field_1321 : (axisalignedbb.field_1324 >= axisalignedbb2.field_1324 ? axisalignedbb2.field_1324 : axisalignedbb.field_1321));
        class_243 second = new class_243(axisalignedbb2.field_1323 <= axisalignedbb.field_1323 ? axisalignedbb.field_1323 : (axisalignedbb2.field_1320 >= axisalignedbb.field_1320 ? axisalignedbb.field_1320 : axisalignedbb2.field_1323), axisalignedbb2.field_1322 <= axisalignedbb.field_1322 ? axisalignedbb.field_1322 : (axisalignedbb2.field_1325 >= axisalignedbb.field_1325 ? axisalignedbb.field_1325 : axisalignedbb2.field_1322), axisalignedbb2.field_1321 <= axisalignedbb.field_1321 ? axisalignedbb.field_1321 : (axisalignedbb2.field_1324 >= axisalignedbb.field_1324 ? axisalignedbb.field_1324 : axisalignedbb2.field_1321));
        return Pair.of((Object)first, (Object)second);
    }

    public static double distTo(class_1297 e, class_243 from, class_243 to) {
        double d = Double.MAX_VALUE;
        class_243 dir = to.method_1020(from);
        for (double height = 0.0; height <= (double)e.method_17682(); height += (double)e.method_17682() * 0.1) {
            class_243 point = e.method_19538().method_1031(0.0, height, 0.0);
            double nD = MathUtils.closestPointToLine(point, from, dir).method_1025(point);
            if (!(nD < d)) continue;
            d = nD;
        }
        return d;
    }

    public static class_243 farestPointToLine(class_243 point, class_243 l1, class_243 dir) {
        return new class_243(Math.abs(l1.field_1352 - point.field_1352) > Math.abs(dir.field_1352 - point.field_1352) ? l1.field_1352 : dir.field_1352, Math.abs(l1.field_1351 - point.field_1351) > Math.abs(dir.field_1351 - point.field_1351) ? l1.field_1351 : dir.field_1351, Math.abs(l1.field_1350 - point.field_1350) > Math.abs(dir.field_1350 - point.field_1350) ? l1.field_1350 : dir.field_1350);
    }

    public static double roundTo(double val, double step) {
        return (double)Math.round(val / (double)((float)step)) * step;
    }
}

