/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class CircleSector {
    private final float theta;
    private final float radius;
    private final float rotAmount;
    private final class_243 center;
    private final class_243 rotAxis;
    private final class_243 look;
    private final class_1297 entity;
    private final List<class_243> vecs = new LinkedList<class_243>();

    public CircleSector(class_243 pos, class_243 look, float radius, float theta, @Nullable class_1297 entity) {
        this.rotAmount = MathUtils.degToRad(theta > 120.0f ? 10.0f : (theta > 30.0f ? 5.0f : 3.0f));
        this.theta = MathUtils.degToRad(theta);
        this.radius = radius;
        this.rotAxis = MathUtils.rotate(MathUtils.rotate(new class_243(0.0, 1.0, 0.0), new class_243(1.0, 0.0, 0.0), (float)class_3532.method_15349((double)look.field_1352, (double)look.field_1350)), look, -MathUtils.degToRad(90.0f)).method_1029();
        this.center = pos;
        this.look = look.method_1029().method_1021((double)radius);
        this.entity = entity;
        this.calculateVecs();
    }

    private void calculateVecs() {
        float rot;
        this.vecs.add(this.look);
        for (rot = -this.theta; rot < 0.0f; rot += this.rotAmount) {
            this.vecs.add(MathUtils.rotate(this.rotAxis, this.look, rot));
        }
        for (rot = this.theta; rot > 0.0f; rot -= this.rotAmount) {
            this.vecs.add(MathUtils.rotate(this.rotAxis, this.look, rot));
        }
    }

    public boolean intersects(class_1937 world, class_238 aabb) {
        if (aabb.method_1006(this.center)) {
            return true;
        }
        for (class_243 ray : this.vecs) {
            class_3965 blocks = world.method_17742(new class_3959(this.center, this.center.method_1019(ray), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this.entity));
            ray = blocks.method_17783() != class_239.class_240.field_1333 ? blocks.method_17784() : this.center.method_1019(ray);
            if (!aabb.method_992(this.center, ray).isPresent()) continue;
            return true;
        }
        return false;
    }

    public void display(class_3218 world) {
        float rot = -this.theta;
        class_243 ray = MathUtils.rotate(this.rotAxis, this.look, rot);
        while (rot <= this.theta) {
            class_3965 blocks = world.method_17742(new class_3959(this.center, this.center.method_1019(ray.method_1021((double)this.radius)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this.entity));
            float reach = (float)blocks.method_17784().method_1022(this.center);
            class_243 from = this.look;
            class_243 to = ray.method_1021((double)reach).method_1021(0.1);
            for (int i = 0; i < 10; ++i) {
                if (i == 9) {
                    world.method_14199((class_2394)class_2398.field_11240, from.field_1352, from.field_1351, from.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                } else {
                    world.method_14199((class_2394)class_2398.field_11207, from.field_1352, from.field_1351, from.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                }
                from = from.method_1019(to);
            }
            ray = MathUtils.rotate(this.rotAxis, this.look, rot += this.rotAmount);
        }
    }
}

