/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.network;

import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.client.ClientHandlers;
import io.github.flemmli97.tenshilib.common.utils.ArrayUtils;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class S2CEntityAnimation
implements class_8710 {
    public static final class_8710.class_9154<S2CEntityAnimation> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"tenshilib", (String)"s2c_entity_animation"));
    public static final class_9139<class_9129, S2CEntityAnimation> STREAM_CODEC = new class_9139<class_9129, S2CEntityAnimation>(){

        public S2CEntityAnimation decode(class_9129 buf) {
            return new S2CEntityAnimation(buf.readInt(), buf.readInt());
        }

        public void encode(class_9129 buf, S2CEntityAnimation pkt) {
            buf.method_53002(pkt.entityID);
            buf.method_53002(pkt.animID);
        }
    };
    private final int entityID;
    private final int animID;

    private S2CEntityAnimation(int entityID, int animID) {
        this.entityID = entityID;
        this.animID = animID;
    }

    public static <T extends class_1297> S2CEntityAnimation create(T entity) {
        return new S2CEntityAnimation(entity);
    }

    private S2CEntityAnimation(class_1297 e) {
        this.entityID = e.method_5628();
        IAnimated entity = (IAnimated)e;
        this.animID = Optional.ofNullable(entity.getAnimationHandler().getAnimation()).map(anim -> {
            if (anim == AnimatedAction.VANILLA_ATTACK) {
                return -1;
            }
            int i = 0;
            for (AnimatedAction a : entity.getAnimationHandler().getAnimations()) {
                if (a.getID().equals(anim.getID())) break;
                ++i;
            }
            if (i < entity.getAnimationHandler().getAnimations().length) {
                return i;
            }
            TenshiLib.LOGGER.error("This animation is not registered for {}. Registered animations are {} but set animation is {}", (Object)e, (Object)ArrayUtils.arrayToString(entity.getAnimationHandler().getAnimations(), AnimatedAction::getID), (Object)anim.getID());
            return -2;
        }).orElse(-2);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static class Handler {
        public static void handlePacket(S2CEntityAnimation pkt, class_1657 player) {
            ClientHandlers.updateAnim(pkt.entityID, pkt.animID);
        }
    }
}

