/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5532;

public abstract class AnimatedAttackGoal<T extends class_1314>
extends class_1352 {
    protected final T attacker;
    protected class_1309 target;
    protected AnimatedAction next;
    protected String prevAnim = "";
    protected int idleTime;
    protected int pathFindDelay;
    protected double distanceToTargetSq;
    protected boolean movementDone;

    public AnimatedAttackGoal(T entity) {
        this.attacker = entity;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 living = this.attacker.method_5968();
        return living != null && living.method_5805() && this.attacker.method_18407(living.method_24515());
    }

    public boolean method_6266() {
        return this.method_6264();
    }

    public void method_6270() {
        this.next = null;
        this.target = null;
        this.idleTime = 0;
        this.movementDone = false;
        this.attacker.method_5942().method_6340();
        this.attacker.method_5930(0.0f);
        this.attacker.method_5938(0.0f);
        this.prevAnim = "";
        this.pathFindDelay = 0;
    }

    public boolean method_38846() {
        return true;
    }

    public abstract AnimatedAction randomAttack();

    public abstract void handlePreAttack();

    public abstract void handleAttack(AnimatedAction var1);

    public abstract void handleIdle();

    public abstract int coolDown(AnimatedAction var1);

    public boolean canChooseAttack(AnimatedAction anim) {
        return anim != null;
    }

    public void setupValues() {
        this.target = this.attacker.method_5968();
        this.distanceToTargetSq = this.attacker.method_5858((class_1297)this.target);
    }

    public void method_6268() {
        if (this.attacker.method_5968() == null) {
            return;
        }
        AnimatedAction anim = ((IAnimated)this.attacker).getAnimationHandler().getAnimation();
        this.setupValues();
        --this.pathFindDelay;
        if (anim != null) {
            this.prevAnim = anim.getID();
            this.handleAttack(anim);
        }
        if (this.next == null && anim == null) {
            AnimatedAction choose;
            if (this.idleTime <= 0 && this.canChooseAttack(choose = this.randomAttack())) {
                this.next = choose;
                this.idleTime = this.coolDown(this.next);
                this.movementDone = false;
            } else {
                this.handleIdle();
                --this.idleTime;
            }
        }
        if (this.next != null) {
            this.handlePreAttack();
            if (this.movementDone) {
                if (anim == null) {
                    ((IAnimated)this.attacker).getAnimationHandler().setAnimation(this.next);
                }
                this.next = null;
            }
        }
    }

    protected void moveRandomlyAround() {
        this.moveRandomlyAround(81.0);
    }

    protected void moveRandomlyAround(double maxDistSq) {
        this.attacker.method_5988().method_6226((class_1297)this.target, 30.0f, 30.0f);
        if (this.distanceToTargetSq <= maxDistSq) {
            class_243 rand;
            if (this.attacker.method_5942().method_6357() && (rand = class_5532.method_31510(this.attacker, (int)5, (int)4)) != null) {
                this.moveTo(rand.field_1352, rand.field_1351, rand.field_1350, 1.0);
            }
        } else {
            this.moveTo((class_1297)this.target, 1.0);
        }
    }

    protected void moveToWithDelay(double x, double y, double z, double speed) {
        if (this.pathFindDelay <= 0) {
            if (!this.moveTo(x, y, z, speed)) {
                this.pathFindDelay += 15;
            }
            this.pathFindDelay += this.attacker.method_59922().method_43048(10) + 5;
        }
    }

    protected void moveToWithDelay(double speed) {
        if (this.pathFindDelay <= 0) {
            if (!this.moveTo((class_1297)this.target, speed)) {
                this.pathFindDelay += 15;
            }
            this.pathFindDelay += this.attacker.method_59922().method_43048(10) + 5;
        }
    }

    private boolean moveTo(double x, double y, double z, double speed) {
        class_11 path = this.attacker.method_5942().method_6352(x, y, z, 0);
        return path != null && this.attacker.method_5942().method_6334(path, speed);
    }

    private boolean moveTo(class_1297 target, double speed) {
        class_11 path = this.attacker.method_5942().method_6349(target, 0);
        return path != null && this.attacker.method_5942().method_6334(path, speed);
    }

    protected class_2338 randomPosAwayFrom(class_1309 away, float minDis) {
        double angle = Math.random() * Math.PI * 2.0;
        double x = Math.cos(angle) * (double)minDis;
        double z = Math.sin(angle) * (double)minDis;
        float min = minDis * minDis;
        class_2338 pos = this.attacker.method_24515().method_10069(class_3532.method_15357((double)x), 0, class_3532.method_15357((double)z));
        if (away.method_5707(class_243.method_24953((class_2382)pos)) > (double)min && this.attacker.method_18407(pos)) {
            return pos;
        }
        return this.attacker.method_24515();
    }

    protected void circleAround(double posX, double posZ, float radius, boolean clockWise, float speed) {
        double z;
        double x = this.attacker.method_23317() - posX;
        double r = x * x + (z = this.attacker.method_23321() - posZ) * z;
        if (r < ((double)radius - 1.5) * ((double)radius - 1.5) || r > ((double)radius + 1.5) * ((double)radius + 1.5)) {
            double[] c = MathUtils.closestOnCircle(posX, posZ, this.attacker.method_23317(), this.attacker.method_23321(), radius);
            this.attacker.method_5942().method_6337(c[0], this.attacker.method_23318(), c[1], (double)speed);
        } else {
            double angle = MathUtils.phiFromPoint(posX, posZ, this.attacker.method_23317(), this.attacker.method_23321()) + (double)(clockWise ? MathUtils.degToRad(15.0f) : -MathUtils.degToRad(15.0f));
            double nPosX = (double)radius * Math.cos(angle);
            double nPosZ = (double)radius * Math.sin(angle);
            this.attacker.method_5942().method_6337(posX + nPosX, this.attacker.method_23318(), posZ + nPosZ, (double)speed);
        }
    }

    protected void circleAroundTargetFacing(float radius, boolean clockWise, float speed) {
        this.attacker.method_5951((class_1297)this.target, 30.0f, 30.0f);
        double x = this.attacker.method_23317() - this.target.method_23317();
        double z = this.attacker.method_23321() - this.target.method_23321();
        double r = x * x + z * z;
        this.attacker.method_5962().method_6243(r < ((double)radius - 1.5) * ((double)radius - 1.5) ? -0.5f : (r > ((double)radius + 1.5) * ((double)radius + 1.5) ? 0.5f : 0.0f), clockWise ? speed : -speed);
    }

    protected void teleportAround(double posX, double posY, double posZ, int range) {
        double x = posX + (this.attacker.method_59922().method_43058() - 0.5) * (double)range * 2.0;
        double y = posY + (double)this.attacker.method_59922().method_43048(3);
        double z = posZ + (this.attacker.method_59922().method_43058() - 0.5) * (double)range * 2.0;
        this.attacker.method_6082(x, y, z, false);
    }
}

