/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.model;

import io.github.flemmli97.tenshilib.TenshiLib;
import java.util.ArrayList;
import java.util.Stack;
import net.minecraft.class_3532;

public class SimpleAnimationExpression {
    private static final String REGEX_SPLIT = "(?<=%1$s)|(?=%1$s)";
    private static final String DELIMITER = "[+\\-\\*/()]";
    private static final String[] DELIMS = new String[]{"[+\\-\\*/()]", "(math\\.sin)", "(math\\.cos)", "(time)", "(query.time)"};
    private static final String DEL_COMP = String.join((CharSequence)"|", DELIMS);

    private static Type type(String s) {
        return switch (s) {
            case "+" -> Type.ADD;
            case "-" -> Type.SUB;
            case "*" -> Type.MULT;
            case "/" -> Type.DIV;
            case "(" -> Type.BRACKETOPEN;
            case ")" -> Type.BRACKETCLOSE;
            case "math.sin" -> Type.SIN;
            case "math.cos" -> Type.COS;
            case "time", "query.time" -> Type.VAR;
            default -> Type.NUMBER;
        };
    }

    public static Value of(String exp) {
        exp = exp.replace(" ", "");
        try {
            float f = Float.parseFloat(exp);
            return new ConstantValue(f);
        }
        catch (NumberFormatException e) {
            try {
                return SimpleAnimationExpression.ofSplit(exp.split(String.format(REGEX_SPLIT, DEL_COMP)));
            }
            catch (NumberFormatException numberFormatException) {
                TenshiLib.LOGGER.error("Couldn't parse expression " + exp);
                return new ConstantValue(0.0f);
            }
        }
    }

    private static Value ofSplit(String[] sub) {
        Stack<Value> consts = new Stack<Value>();
        Stack<Type> ops = new Stack<Type>();
        ArrayList<String> bracketSS = new ArrayList<String>();
        int bracket = 0;
        for (String s : sub) {
            Type type = SimpleAnimationExpression.type(s);
            if (type == Type.BRACKETOPEN) {
                ++bracket;
            }
            if (type == Type.BRACKETCLOSE && --bracket <= 0) {
                bracketSS.remove(0);
                Value b = SimpleAnimationExpression.ofSplit(bracketSS.toArray(new String[0]));
                consts.push(b);
                bracketSS.clear();
                continue;
            }
            if (bracket > 0) {
                bracketSS.add(s);
                continue;
            }
            if (type == Type.NUMBER) {
                consts.push(new ConstantValue(Float.parseFloat(s)));
                continue;
            }
            if (type == Type.VAR) {
                consts.push(new TickValue());
                continue;
            }
            if (!ops.isEmpty() && ((Type)((Object)ops.peek())).priority > type.priority) {
                Value v = null;
                while (!ops.empty() && ((Type)((Object)ops.peek())).priority > type.priority) {
                    Type t = (Type)((Object)ops.pop());
                    v = SimpleAnimationExpression.read(t, consts, v);
                }
                ops.push(type);
                consts.push(v);
                continue;
            }
            ops.push(type);
        }
        Value v = null;
        while (!ops.empty()) {
            Type t = (Type)((Object)ops.pop());
            v = SimpleAnimationExpression.read(t, consts, v);
        }
        if (v == null && !consts.empty()) {
            v = (Value)consts.pop();
        }
        return v;
    }

    private static Value read(Type t, Stack<Value> stack, Value prev) {
        switch (t.ordinal()) {
            case 3: {
                Value sec = prev == null ? stack.pop() : prev;
                Value first = stack.pop();
                return new Addition(first, sec);
            }
            case 4: {
                Value value;
                if (stack.empty()) {
                    if (prev instanceof BiValue) {
                        BiValue bi = (BiValue)prev;
                        return bi.negateFirst();
                    }
                    if (prev instanceof ConstantValue) {
                        ConstantValue consts = (ConstantValue)prev;
                        return consts.negate();
                    }
                    return new NegValue(prev);
                }
                Value sec = prev == null ? stack.pop() : prev;
                Value first = stack.pop();
                if (sec instanceof BiValue) {
                    BiValue b = (BiValue)sec;
                    value = b.negateSecond();
                } else {
                    value = sec;
                }
                return new Substraction(first, value);
            }
            case 1: {
                Value sec = prev == null ? stack.pop() : prev;
                Value first = stack.pop();
                return new Multiplication(first, sec);
            }
            case 2: {
                Value sec = prev == null ? stack.pop() : prev;
                Value first = stack.pop();
                return new Division(first, sec);
            }
            case 5: {
                return new Sin(prev != null ? prev : stack.pop());
            }
            case 6: {
                return new Cos(prev != null ? prev : stack.pop());
            }
        }
        return new ConstantValue(0.0f);
    }

    static enum Type {
        NUMBER(0),
        MULT(1),
        DIV(1),
        ADD(0),
        SUB(0),
        SIN(2),
        COS(2),
        BRACKETOPEN(2),
        BRACKETCLOSE(2),
        VAR(0);

        int priority;

        private Type(int priority) {
            this.priority = priority;
        }
    }

    record ConstantValue(float constant) implements Value
    {
        @Override
        public float get(float time) {
            return this.constant;
        }

        public ConstantValue negate() {
            return new ConstantValue(-this.constant);
        }

        @Override
        public String toString() {
            return "" + this.constant;
        }
    }

    static interface Value {
        public float get(float var1);
    }

    record TickValue() implements Value
    {
        @Override
        public float get(float time) {
            return time;
        }

        @Override
        public String toString() {
            return "time";
        }
    }

    record Addition(Value first, Value second) implements BiValue
    {
        @Override
        public float get(float time) {
            return this.first.get(time) + this.second.get(time);
        }

        @Override
        public Value getFirst() {
            return this.first;
        }

        @Override
        public Value getSecond() {
            return this.second;
        }

        @Override
        public Value negateFirst() {
            Value value = this.first;
            if (value instanceof ConstantValue) {
                ConstantValue c = (ConstantValue)value;
                return new Addition(c.negate(), this.second);
            }
            return new Addition(new NegValue(this.first), this.second);
        }

        @Override
        public Value negateSecond() {
            Value value = this.second;
            if (value instanceof ConstantValue) {
                ConstantValue c = (ConstantValue)value;
                return new Addition(this.first, c.negate());
            }
            return new Addition(this.first, new NegValue(this.second));
        }

        @Override
        public String toString() {
            String f = this.first instanceof ConstantValue || this.first instanceof TickValue ? this.first.toString() : String.format("(%s)", this.first);
            String s = this.second instanceof ConstantValue || this.second instanceof TickValue ? this.second.toString() : String.format("(%s)", this.second);
            return String.format("%s+%s", f, s);
        }
    }

    static interface BiValue
    extends Value {
        public Value getFirst();

        public Value getSecond();

        public Value negateFirst();

        public Value negateSecond();
    }

    record NegValue(Value val) implements Value
    {
        @Override
        public float get(float time) {
            return -this.val.get(time);
        }

        @Override
        public String toString() {
            return "-" + String.valueOf(this.val);
        }
    }

    record Substraction(Value first, Value second) implements BiValue
    {
        @Override
        public float get(float time) {
            return this.first.get(time) - this.second.get(time);
        }

        @Override
        public Value getFirst() {
            return this.first;
        }

        @Override
        public Value getSecond() {
            return this.second;
        }

        @Override
        public Value negateFirst() {
            Value value = this.first;
            if (value instanceof ConstantValue) {
                ConstantValue c = (ConstantValue)value;
                return new Substraction(c.negate(), this.second);
            }
            return new Substraction(new NegValue(this.first), this.second);
        }

        @Override
        public Value negateSecond() {
            Value value = this.second;
            if (value instanceof ConstantValue) {
                ConstantValue c = (ConstantValue)value;
                return new Substraction(this.first, c.negate());
            }
            return new Substraction(this.first, new NegValue(this.second));
        }

        @Override
        public String toString() {
            String f = this.first instanceof ConstantValue || this.first instanceof TickValue ? this.first.toString() : String.format("(%s)", this.first);
            String s = this.second instanceof ConstantValue || this.second instanceof TickValue ? this.second.toString() : String.format("(%s)", this.second);
            return String.format("%s-%s", f, s);
        }
    }

    record Multiplication(Value first, Value second) implements BiValue
    {
        @Override
        public float get(float time) {
            return this.first.get(time) * this.second.get(time);
        }

        @Override
        public Value getFirst() {
            return this.first;
        }

        @Override
        public Value getSecond() {
            return this.second;
        }

        @Override
        public Value negateFirst() {
            Value value = this.first;
            if (value instanceof ConstantValue) {
                ConstantValue c = (ConstantValue)value;
                return new Multiplication(c.negate(), this.second);
            }
            return new Multiplication(new NegValue(this.first), this.second);
        }

        @Override
        public Value negateSecond() {
            Value value = this.second;
            if (value instanceof ConstantValue) {
                ConstantValue c = (ConstantValue)value;
                return new Multiplication(this.first, c.negate());
            }
            return new Multiplication(this.first, new NegValue(this.second));
        }

        @Override
        public String toString() {
            String f = this.first instanceof ConstantValue || this.first instanceof TickValue ? this.first.toString() : String.format("(%s)", this.first);
            String s = this.second instanceof ConstantValue || this.second instanceof TickValue ? this.second.toString() : String.format("(%s)", this.second);
            return String.format("%s*%s", f, s);
        }
    }

    record Division(Value first, Value second) implements BiValue
    {
        @Override
        public float get(float time) {
            return this.first.get(time) / this.second.get(time);
        }

        @Override
        public Value getFirst() {
            return this.first;
        }

        @Override
        public Value getSecond() {
            return this.second;
        }

        @Override
        public Value negateFirst() {
            Value value = this.first;
            if (value instanceof ConstantValue) {
                ConstantValue c = (ConstantValue)value;
                return new Division(c.negate(), this.second);
            }
            return new Division(new NegValue(this.first), this.second);
        }

        @Override
        public Value negateSecond() {
            Value value = this.second;
            if (value instanceof ConstantValue) {
                ConstantValue c = (ConstantValue)value;
                return new Division(this.first, c.negate());
            }
            return new Division(this.first, new NegValue(this.second));
        }

        @Override
        public String toString() {
            String f = this.first instanceof ConstantValue || this.first instanceof TickValue ? this.first.toString() : String.format("(%s)", this.first);
            String s = this.second instanceof ConstantValue || this.second instanceof TickValue ? this.second.toString() : String.format("(%s)", this.second);
            return String.format("%s/%s", f, s);
        }
    }

    record Sin(Value value) implements Value
    {
        @Override
        public float get(float time) {
            return class_3532.method_15374((float)((float)Math.PI / 180 * this.value.get(time)));
        }

        @Override
        public String toString() {
            return String.format("sin(%s)", this.value);
        }
    }

    record Cos(Value value) implements Value
    {
        @Override
        public float get(float time) {
            return class_3532.method_15362((float)((float)Math.PI / 180 * this.value.get(time)));
        }

        @Override
        public String toString() {
            return String.format("cos(%s)", this.value);
        }
    }
}

